/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.stock.StockArea;

public class DecrementStockArea
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<InventoryGroup> inventoryGroup;
    private Reference<Terminal> terminal;
    private Reference<StockArea> stockArea;

    public DecrementStockArea() {
        this.inventoryGroup = this.createReference(DecrementStockArea.Properties.INVENTORY_GROUP);
        this.terminal = this.createReference(DecrementStockArea.Properties.TERMINAL);
        this.stockArea = this.createReference(DecrementStockArea.Properties.STOCK_AREA);
    }

    public DecrementStockArea(InventoryGroup anInventoryGroup, StockArea aStockArea, Terminal aTerminal) {
        this.inventoryGroup = this.createReference(DecrementStockArea.Properties.INVENTORY_GROUP);
        this.terminal = this.createReference(DecrementStockArea.Properties.TERMINAL);
        this.stockArea = this.createReference(DecrementStockArea.Properties.STOCK_AREA);
        if (anInventoryGroup == null) {
            throw new NullPointerException("Try to create a StockAreaDecrementMenuGroup with a null menu group");
        }
        if (aStockArea == null) {
            throw new NullPointerException("Try to create a StockAreaDecrementMenuGroup with a null stock area");
        }
        if (aTerminal == null) {
            throw new NullPointerException("Try to create a StockAreaDecrementMenuGroup with a null terminal");
        }
        this.inventoryGroup.set(anInventoryGroup);
        this.stockArea.set(aStockArea);
        this.terminal.set(aTerminal);
    }

    public InventoryGroup getInventoryGroup() {
        return this.inventoryGroup.get();
    }

    public StockArea getStockArea() {
        return this.stockArea.get();
    }

    public Terminal getTerminal() {
        return this.terminal.get();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public String toString() {
        return "Area {" + this.getStockArea() + "} for group {" + this.getInventoryGroup() + "} w terminal {" + this.getTerminal() + "}[" + this.getID() + "]";
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InventoryGroup> INVENTORY_GROUP;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<StockArea> STOCK_AREA;
    }
}

