/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.stock.StockArea;

public class DecrementStockAreaInventoryItem
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<InventoryItem> inventoryItem;
    private Reference<Terminal> terminal;
    private Reference<StockArea> stockArea;

    public DecrementStockAreaInventoryItem() {
        this.inventoryItem = this.createReference(DecrementStockAreaInventoryItem.Properties.INVENTORY_ITEM);
        this.terminal = this.createReference(DecrementStockAreaInventoryItem.Properties.TERMINAL);
        this.stockArea = this.createReference(DecrementStockAreaInventoryItem.Properties.STOCK_AREA);
    }

    public DecrementStockAreaInventoryItem(InventoryItem inventoryItem, StockArea stockArea, Terminal terminal) {
        this.inventoryItem = this.createReference(DecrementStockAreaInventoryItem.Properties.INVENTORY_ITEM);
        this.terminal = this.createReference(DecrementStockAreaInventoryItem.Properties.TERMINAL);
        this.stockArea = this.createReference(DecrementStockAreaInventoryItem.Properties.STOCK_AREA);
        if (inventoryItem == null) {
            throw new NullPointerException("Try to create a DecrementStockAreaInventoryItem with a null menu item");
        }
        if (stockArea == null) {
            throw new NullPointerException("Try to create a DecrementStockAreaInventoryItem with a null stock area");
        }
        if (terminal == null) {
            throw new NullPointerException("Try to create a DecrementStockAreaInventoryItem with a null terminal");
        }
        this.inventoryItem.set(inventoryItem);
        this.stockArea.set(stockArea);
        this.terminal.set(terminal);
    }

    public InventoryItem getInventoryItem() {
        return this.inventoryItem.get();
    }

    public StockArea getStockArea() {
        return this.stockArea.get();
    }

    public Terminal getTerminal() {
        return this.terminal.get();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public String toString() {
        return "Area {" + this.getStockArea() + "} for item {" + this.getInventoryItem() + "} w terminal {" + this.getTerminal() + "}[" + this.getID() + "]";
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InventoryItem> INVENTORY_ITEM;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<StockArea> STOCK_AREA;
    }
}

