/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import ordermate.database.config.Quantity;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;

public class ScanDataLinkSummary
implements PropertiedObject {
    public static final Props Properties = new Props();
    private StockItem stockItemExisting;
    private InventoryItem inventoryItemExisting;
    private StockItem stockItem;
    private InventoryItem inventoryItem;
    private List<InventoryItemUnit> inventoryItemUnits = new ArrayList<InventoryItemUnit>();
    private List<StockInventoryUsageLink> stockInventoryUsageLinks = new ArrayList<StockInventoryUsageLink>();

    public ScanDataLinkSummary(StockItem stockItem, InventoryItem inventoryItem, StockItem existingStockItem, InventoryItem existingInventoryItem) {
        if (stockItem == null || inventoryItem == null) {
            throw new InvalidParameterException("No null values allowed in ScanDataLinkSummary! (except existing)\nStockItem:" + stockItem + "\nInvItem:" + inventoryItem);
        }
        this.setStockItem(stockItem);
        this.setInventoryItem(inventoryItem);
        this.setStockItemExisting(existingStockItem);
        this.setInventoryItemExisting(existingInventoryItem);
    }

    public ScanDataLinkSummary(StockItem stockItem, InventoryItem inventoryItem) {
        if (stockItem == null || inventoryItem == null) {
            throw new InvalidParameterException("No null values allowed in ScanDataLinkSummary!\nStockItem:" + stockItem + "\nInvItem:" + inventoryItem);
        }
        this.setStockItem(stockItem);
        this.setInventoryItem(inventoryItem);
        this.setStockItemExisting(null);
        this.setInventoryItemExisting(null);
    }

    public StockItem getStockItem() {
        return this.stockItem;
    }

    public void setStockItem(StockItem stockItem) {
        if (stockItem == null) {
            throw new InvalidParameterException("Cannot set StockItem to null");
        }
        this.stockItem = stockItem;
    }

    public InventoryItem getInventoryItem() {
        return this.inventoryItem;
    }

    public void setInventoryItem(InventoryItem inventoryItem) {
        if (inventoryItem == null) {
            throw new InvalidParameterException("Cannot set InventoryItem to null");
        }
        this.inventoryItem = inventoryItem;
        this.createInventoryItemUnitList();
        this.createStockInventoryUsageLinkList();
    }

    public List<InventoryItemUnit> getInventoryItemUnits() {
        return this.inventoryItemUnits;
    }

    public List<StockInventoryUsageLink> getStockInventoryUsageLinks() {
        return this.stockInventoryUsageLinks;
    }

    public String getStockItemName() {
        return this.stockItem.getName();
    }

    public String getStockItemGroupName() {
        return this.stockItem.getStockGroup().getName();
    }

    public String getInventoryItemName() {
        return this.inventoryItem.getLabel();
    }

    public String getInventoryItemGroupName() {
        return this.inventoryItem.getMenuGroup().getLabel();
    }

    public List<Quantity> getStockItemQuantitys() {
        ArrayList<Quantity> qtys = new ArrayList<Quantity>();
        for (StockInventoryUsageLink stockInvUsageLink : this.stockInventoryUsageLinks) {
            qtys.add(stockInvUsageLink.getQuantity());
        }
        return qtys;
    }

    public List<Integer> getLiquorFileIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (StockInventoryUsageLink stockInvUsageLink : this.stockInventoryUsageLinks) {
            ids.add(stockInvUsageLink.getLiquorfileId());
        }
        return ids;
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    @Override
    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return PropertiedObject.PropsHelper.getPropertyValue(this, prop);
    }

    private void createInventoryItemUnitList() {
        if (this.inventoryItem != null) {
            this.inventoryItemUnits = this.inventoryItem.getUnits();
        }
    }

    private void createStockInventoryUsageLinkList() {
        if (this.inventoryItemUnits != null) {
            this.stockInventoryUsageLinks.clear();
            this.stockInventoryUsageLinks.addAll((Collection<StockInventoryUsageLink>)new HashSet<StockInventoryUsageLink>(){
                {
                    for (InventoryItemUnit invItemUnit : ScanDataLinkSummary.this.inventoryItemUnits) {
                        this.addAll(invItemUnit.getStockLinks());
                    }
                }
            });
        }
    }

    public void doSave() {
        StockItem toSave;
        if (this.stockItemExisting == null) {
            this.stockItem.save();
            toSave = this.stockItem;
        } else {
            this.stockItemExisting.setName(this.stockItem.getName());
            this.stockItemExisting.setPurchaseQty(this.stockItem.getPurchaseQty());
            this.stockItemExisting.setCurrentCost(this.stockItem.getCurrentReplacementCost());
            this.stockItemExisting.setOuterQuantity(this.stockItem.getOuterQuantity());
            this.stockItemExisting.setOuterName(this.stockItem.getOuterName());
            this.stockItemExisting.setStockGroup(this.stockItem.getStockGroup());
            this.stockItemExisting.setBarcodes(this.stockItem.getBarcodes());
            this.stockItemExisting.save();
            toSave = this.stockItemExisting;
        }
        if (this.inventoryItemExisting == null) {
            this.inventoryItem.save();
        } else {
            this.inventoryItemExisting.setLabel(this.inventoryItem.getLabel());
            this.inventoryItemExisting.setMenuGroup(this.inventoryItem.getMenuGroup());
            this.updateInventoryItemUnitsAndLinks(toSave, this.inventoryItemExisting);
            this.inventoryItemExisting.save();
        }
    }

    private void updateInventoryItemUnitsAndLinks(StockItem stockItem, InventoryItem invItem) {
        for (InventoryItemUnit unit : this.inventoryItem.getUnits()) {
            for (StockInventoryUsageLink stockInvUsageLinks : unit.getStockInventoryUsageLinks()) {
                stockInvUsageLinks.setStockItem(stockItem);
            }
            invItem.addUnit(unit);
        }
    }

    public StockItem getStockItemExisting() {
        return this.stockItemExisting;
    }

    public void setStockItemExisting(StockItem stockItemExsiting) {
        this.stockItemExisting = stockItemExsiting;
    }

    public InventoryItem getInventoryItemExisting() {
        return this.inventoryItemExisting;
    }

    public void setInventoryItemExisting(InventoryItem inventoryItemExisting) {
        this.inventoryItemExisting = inventoryItemExisting;
    }

    public static class Props
    extends PropertiedObject.Props {
        public PropertiedObject.Property<StockItem> STOCK_ITEM;
        public PropertiedObject.Property<InventoryItem> INVENTORY_ITEM;
        public PropertiedObject.Property<StockItem> STOCK_ITEM_EXISTING;
        public PropertiedObject.Property<InventoryItem> INVENTORY_ITEM_EXISTING;
        public PersistentObject.DerivedProperty<List<InventoryItemUnit>> INVENTORY_ITEM_UNITS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ScanDataLinkSummary.class), "inventoryItemUnits");
        public PersistentObject.DerivedProperty<List<StockInventoryUsageLink>> STOCK_INVENTORY_USAGE_LINKS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ScanDataLinkSummary.class), "stockInventoryUsageLinks");
        public PersistentObject.DerivedProperty<String> STOCK_ITEM_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ScanDataLinkSummary.class), "stockItemName");
        public PersistentObject.DerivedProperty<String> STOCK_ITEM_GROUP_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ScanDataLinkSummary.class), "stockItemGroupName");
        public PersistentObject.DerivedProperty<String> INVENTORY_ITEM_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ScanDataLinkSummary.class), "inventoryItemName");
        public PersistentObject.DerivedProperty<String> INVENTORY_ITEM_GROUP_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ScanDataLinkSummary.class), "inventoryItemGroupName");
        public PersistentObject.DerivedProperty<List<Quantity>> STOCK_ITEM_QUANTITYS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ScanDataLinkSummary.class), "stockItemQuantitys");
        public PersistentObject.DerivedProperty<List<Integer>> LIQUOR_FILE_IDS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ScanDataLinkSummary.class), "liquorFileIds");
    }
}

