/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import java.rmi.RemoteException;
import java.util.List;
import ordermate.database.Data;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.accounting.settings.BaseAccountingConfiguration;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.stock.StockAreaGlLink;
import ordermate.database.stock.StockTake;
import ordermate.reports.accounting.GLType;
import stockmate.database.interfaces.stock.StockAreaI;

public class StockArea
extends PersistentDisplayableObject
implements Saveable,
StockAreaI,
ExportableObject {
    public static final Props Properties = new Props();
    private String systemState;
    private boolean scandataExported = false;
    private boolean scandataConsolidated = false;
    private Reference<GLAccount> glCode;
    private PersistentWriteableList<StockAreaGlLink> glLinks;
    private transient StockTake statsStockTakeStart;
    private transient StockTake statsStockTakeEnd;
    private Price adjust;
    private Price transfers;
    private Price wastage;
    private Price purchases;
    private Long masterId;

    public StockArea() {
        this.glCode = this.createReference(StockArea.Properties.GL_CODE);
        this.glLinks = this.createWriteableList(StockArea.Properties.GL_LINKS);
        this.statsStockTakeStart = null;
        this.statsStockTakeEnd = null;
        this.adjust = null;
        this.transfers = null;
        this.wastage = null;
        this.purchases = null;
        this.setSystemState("ACTIVE");
    }

    public String getName() {
        return this.getLabel();
    }

    public void setName(String str) {
        this.setLabel(str);
    }

    @Override
    public void delete() {
        this.setSystemState("DELETED");
        PersistenceManager.save(this);
        List terminals = Terminal.getTerminalsLinkedToArea(this);
        List<StockArea> stockAreas = StockArea.getStockAreas();
        if (stockAreas.size() > 0) {
            StockArea defaultStockArea = stockAreas.get(0);
            for (int i = 0; i < terminals.size(); ++i) {
                Terminal t = (Terminal)terminals.get(i);
                t.setStockArea(defaultStockArea);
                t.save();
            }
        }
    }

    @Override
    public void save() {
        boolean firstSave;
        boolean bl = firstSave = !this.isPersistent();
        if (this.glCode != null) {
            this.glCode.saveChild();
        }
        PersistenceManager.save(this);
        if (this.getSystemState().equals("ACTIVE") && firstSave) {
            this.createGlLinks();
            try {
                Data.database.addLiveStockEntriesForNewStockArea(this.intID());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        }
        if (this.glLinks != null) {
            this.glLinks.saveChild();
        }
    }

    private void createGlLinks() {
        for (GLType glType : GLType.stockMovementGlTypes.values()) {
            StockAreaGlLink glLink = new StockAreaGlLink(this, BaseAccountingConfiguration.getInstance().getGLCodeForType(glType), glType);
            this.glLinks.add(glLink);
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static List<StockArea> getStockAreas() {
        return Query.createQueryList(StockArea.class, "SELECT * FROM stock_area WHERE system_state = 'ACTIVE' ORDER BY Name ");
    }

    public static StockArea getStockArea(String name) {
        Object[] params = new Object[]{name};
        return PersistenceManager.getObject(StockArea.class, "SELECT * FROM stock_area WHERE Name = ? AND system_state = 'ACTIVE' LIMIT 1 ", params);
    }

    public static boolean stockAreasExist() {
        try {
            return Data.database.stockAreasExist();
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return false;
        }
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public GLAccount getGlCode() {
        return this.glCode.get();
    }

    public void setGlCode(GLAccount glCode) {
        this.glCode.set(glCode);
    }

    public boolean isScandataExported() {
        return this.scandataExported;
    }

    public void setScandataExported(boolean value) {
        this.scandataExported = value;
    }

    public boolean isScandataConsolidated() {
        return this.scandataConsolidated;
    }

    public void setScandataConsolidated(boolean value) {
        this.scandataConsolidated = value;
    }

    protected void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    public String getSystemState() {
        return this.systemState;
    }

    @Override
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public List<StockAreaGlLink> getGlLinks() {
        return this.glLinks.getUnmodifiable();
    }

    protected void setGlLinks(List<StockAreaGlLink> values) {
        this.glLinks.set(values);
    }

    public void setGLAccountByType(GLAccount glAccount, GLType type) {
        for (StockAreaGlLink glLink : this.glLinks) {
            if (!glLink.getGlType().equals((Object)type)) continue;
            glLink.setGlAccount(glAccount);
            break;
        }
    }

    public GLAccount getGLAccountByType(GLType type) {
        for (StockAreaGlLink glLink : this.glLinks) {
            if (!glLink.getGlType().equals((Object)type)) continue;
            return glLink.getGlAccount();
        }
        return null;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<GLAccount> GL_CODE;
        public PropertiedObject.Property SCANDATA_EXPORTED;
        public PropertiedObject.Property SCANDATA_CONSOLIDATED;
        public PropertiedObject.Property<Long> MASTER_ID;
        public PropertiedObject.Property<StockAreaGlLink> GL_LINKS;
    }
}

