/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.stock.StockArea;
import ordermate.reports.accounting.GLType;

public class StockAreaGlLink
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<StockArea> stockArea;
    private Reference<GLAccount> glAccount;
    private GLType glType;

    @Deprecated
    public StockAreaGlLink() {
        this.stockArea = this.createReference(StockAreaGlLink.Properties.STOCK_AREA);
        this.glAccount = this.createReference(StockAreaGlLink.Properties.GL_ACCOUNT);
        this.glType = GLType.COGS;
    }

    public StockAreaGlLink(StockArea area, GLAccount gl, GLType type) {
        this.stockArea = this.createReference(StockAreaGlLink.Properties.STOCK_AREA);
        this.glAccount = this.createReference(StockAreaGlLink.Properties.GL_ACCOUNT);
        this.glType = GLType.COGS;
        if (area == null) {
            throw new IllegalArgumentException("StockArea cannot be null!");
        }
        if (type == null) {
            throw new IllegalArgumentException("GL Type cannot be null");
        }
        this.setStockArea(area);
        this.setGlAccount(gl);
        this.setGlType(type);
    }

    public GLType getGlType() {
        return this.glType;
    }

    public void setGlType(GLType value) {
        if (value != null) {
            this.glType = value;
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        if (this.glAccount != null) {
            this.glAccount.saveChild();
        }
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public StockArea getStockArea() {
        return this.stockArea.get();
    }

    public void setStockArea(StockArea stockArea) {
        this.stockArea.set(stockArea);
    }

    public GLAccount getGlAccount() {
        return this.glAccount.get();
    }

    public void setGlAccount(GLAccount glAccount) {
        this.glAccount.set(glAccount);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<StockArea> STOCK_AREA;
        public PropertiedObject.Property<GLAccount> GL_ACCOUNT;
        public PropertiedObject.Property<GLType> GL_TYPE;
    }
}

