/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import ordermate.database.stock.StockItem;
import stockmate.database.interfaces.stock.StockBarcodeI;

public class StockBarcode
extends PersistentObject
implements SaveableChild,
StockBarcodeI {
    public static final Props Properties = new Props();
    private String barcode;
    private Reference stockItem;

    public StockBarcode() {
        this.stockItem = this.createReference(StockBarcode.Properties.STOCK_ITEM);
    }

    public StockBarcode(String aBarcode, StockItem anItem) {
        this.stockItem = this.createReference(StockBarcode.Properties.STOCK_ITEM);
        if (anItem == null) {
            throw new IllegalArgumentException("Null stock item for stock barcode " + aBarcode);
        }
        if (aBarcode == null) {
            throw new IllegalArgumentException("Null stock barcode for stock item " + anItem);
        }
        this.barcode = aBarcode;
        this.stockItem.set(anItem);
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    public StockItem getStockItem() {
        return (StockItem)this.stockItem.get();
    }

    @Override
    public String toString() {
        return this.getBarcode() + "-" + this.getStockItem() + "[" + this.getID() + "]";
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property BARCODE;
        public PropertiedObject.Property STOCK_ITEM;
    }
}

