/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.enums.OversellModeType;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.stock.StockCount;

public class StockControlProperty
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private static Reference instance = new LocalCachedReference<StockControlProperty>(new QueryReference<StockControlProperty>(StockControlProperty.class, Query.select(StockControlProperty.class)));
    private boolean stockControlEnabled;
    private boolean stockCountDownEnabled;
    private OversellModeType oversellMode = OversellModeType.IGNORE;
    private OversellModeType stockCountdownOversellMode = OversellModeType.IGNORE;
    private boolean showSOHInFrontEnd;
    private boolean showStockCountInFrontEnd;
    private boolean lockStocklessItemsEnabled;
    private String orderNumberPrefix;
    private int nextOrderNumber;

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public void setLockStocklessItemsEnabled(boolean enable) {
        this.lockStocklessItemsEnabled = enable;
    }

    public boolean isLockStocklessItemsEnabled() {
        return this.lockStocklessItemsEnabled;
    }

    @Override
    public void delete() {
    }

    public boolean isShowSOHInFrontEnd() {
        return this.showSOHInFrontEnd;
    }

    public void setShowSOHInFrontEnd(boolean b) {
        this.showSOHInFrontEnd = b;
    }

    public boolean isShowStockCountInFrontEnd() {
        return this.showStockCountInFrontEnd;
    }

    public void setShowStockCountInFrontEnd(boolean value) {
        this.showStockCountInFrontEnd = value;
    }

    public OversellModeType getOversellMode() {
        return this.oversellMode;
    }

    public void setOversellMode(OversellModeType mode) {
        this.oversellMode = mode;
    }

    public OversellModeType getStockCountdownOversellMode() {
        return this.stockCountdownOversellMode;
    }

    public void setStockCountdownOversellMode(OversellModeType newValue) {
        this.stockCountdownOversellMode = newValue;
    }

    public boolean isStockOversellCheckable() {
        return this.isStockControlEnabled() && !this.getOversellMode().equals(OversellModeType.IGNORE) || this.isStockCountDownEnabled() && !this.getStockCountdownOversellMode().equals(OversellModeType.IGNORE);
    }

    public boolean isStockControlEnabled() {
        boolean result;
        boolean bl = result = this.stockControlEnabled && PersistentLicenseManager.getInstance().getBoolean(LicenseType.StockControlEnabled);
        if (!result && this.stockControlEnabled) {
            OrderMate.LOG.warn("Stock control is enabled but is not licensed.  Stock control will not work.");
        }
        return result;
    }

    public boolean isStockCountDownEnabled() {
        return this.stockCountDownEnabled;
    }

    public void setStockControlEnabled(boolean enabled) {
        this.stockControlEnabled = enabled;
    }

    public void setStockCountDownEnabled(boolean enabled) {
        this.stockCountDownEnabled = enabled;
    }

    public String getOrderNumberPrefix() {
        return this.orderNumberPrefix;
    }

    public int getNextOrderNumber() {
        return this.nextOrderNumber;
    }

    public void setOrderNumberPrefix(String str) {
        this.orderNumberPrefix = str;
    }

    public void incrementNextOrderNumber() {
        ++this.nextOrderNumber;
    }

    protected void setNextOrderNumber(int newNextOrderNumber) {
        this.nextOrderNumber = newNextOrderNumber;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public static StockControlProperty getInstance() {
        return (StockControlProperty)instance.get();
    }

    public void clearStockCount() {
        OrderMate.LOG.info("Clearing all stock counts");
        List<StockCount> allCounts = PersistenceManager.getObjectList(StockCount.class, Query.select(StockCount.class).toString());
        for (StockCount nextCount : allCounts) {
            nextCount.setQuantity(null);
            nextCount.saveChild();
        }
        OrderMate.LOG.info("Stock counts cleared");
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property STOCK_CONTROL_ENABLED;
        public PropertiedObject.Property STOCK_COUNTDOWN_ENABLED;
        public PropertiedObject.Property OVERSELL_MODE;
        public PropertiedObject.Property STOCK_COUNTDOWN_OVERSELL_MODE;
        public PropertiedObject.Property SHOW_SOH_IN_FRONT_END;
        public PropertiedObject.Property SHOW_STOCK_COUNT_IN_FRONT_END;
        public PropertiedObject.Property LOCK_STOCKLESS_ITEMS_ENABLED;
        public PropertiedObject.Property ORDER_NUMBER_PREFIX;
        public PropertiedObject.Property NEXT_ORDER_NUMBER;
    }
}

