/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.guicore.TreeNodeSupport;
import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import ordermate.OrderMate;
import ordermate.database.integration.accounting.GLAccountCode;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.stock.StockItem;
import ordermate.integration.finance.AccountingExportManager;
import stockmate.database.interfaces.stock.StockGroupI;

public class StockGroup
extends PersistentDisplayableObject
implements GLAccountCode,
Saveable,
StockGroupI,
TreeNode,
ExportableObject,
Displayable {
    public static final Props Properties = new Props();
    private String systemState = "ACTIVE";
    private Reference<GLAccount> glCode;
    private Reference<StockGroup> parentGroup;
    private PersistentWriteableList<StockGroup> subGroups;
    private PersistentWriteableList<StockItem> stockItems;
    private Long masterId;
    private static final TreeNodeSupport treeNodeSupport = new TreeNodeSupport(StockGroup.Properties.PARENT_GROUP, StockGroup.Properties.SUB_GROUPS);
    private static LocalCacheListManager<StockGroup> stockGroups = new LocalCacheListManager<StockGroup>(Query.createQueryList(StockGroup.class, Query.select(StockGroup.class).active(StockGroup.class).orderBy(StockGroup.Properties.LABEL)));

    public StockGroup() {
        this.glCode = this.createReference(StockGroup.Properties.GL_CODE);
        this.parentGroup = this.createReference(StockGroup.Properties.PARENT_GROUP);
        this.subGroups = this.createWriteableList(StockGroup.Properties.SUB_GROUPS);
        this.stockItems = this.createWriteableList(StockGroup.Properties.STOCK_ITEMS);
    }

    @Override
    public void delete() {
        Collection<StockItem> items = this.getItemsWithStockOnHand();
        if (items.size() > 0) {
            OrderMate.LOG.info("Stock group " + this + " won't be deleted because it contains these items with stock on hand: " + items);
            return;
        }
        this.systemState = "DELETED";
        this.stockItems.deleteChild();
        this.subGroups.deleteChild();
        this.save();
    }

    public Collection<StockItem> getItemsWithStockOnHand() {
        Collection<StockItem> retValue = StockGroup.getItemsWithStockOnHand(this);
        List<StockGroup> recursiveSubGroups = this.getRecursiveSubGroups();
        for (StockGroup subGroup : recursiveSubGroups) {
            retValue.addAll(StockGroup.getItemsWithStockOnHand(subGroup));
        }
        return retValue;
    }

    public static Collection<StockItem> getItemsWithStockOnHand(StockGroup group) {
        ArrayList<StockItem> retValue = new ArrayList<StockItem>();
        for (StockItem item : group.getStockItems()) {
            if (item.getTotalStockOnHand().doubleValue() == 0.0) continue;
            retValue.add(item);
        }
        return retValue;
    }

    public List<StockItem> getStockItems() {
        return this.stockItems.getUnmodifiable();
    }

    public static StockGroup getStockGroupForName(String name) {
        StockGroup retval = null;
        Object[] params = new Object[]{};
        String select = Query.select(StockGroup.class).equals(StockGroup.Properties.LABEL, name).active(StockGroup.class).toString();
        retval = PersistenceManager.getObject(StockGroup.class, select, params);
        return retval;
    }

    public List<StockGroup> getRecursiveSubGroups() {
        ArrayList<StockGroup> allSubGroups = new ArrayList<StockGroup>(this.getSubGroups());
        for (StockGroup group : this.subGroups) {
            allSubGroups.addAll(group.getRecursiveSubGroups());
        }
        return allSubGroups;
    }

    public List<StockGroup> getSubGroups() {
        return this.subGroups;
    }

    public boolean isSubGroupOf(StockGroup group) {
        for (StockGroup g = this; g != null; g = g.getParentGroup()) {
            if (!g.equals(group)) continue;
            return true;
        }
        return false;
    }

    public void setParentGroup(StockGroup group) {
        if (group != null && (this.equals(group) || group.isSubGroupOf(this))) {
            throw new IllegalArgumentException("The group " + group + " cannot be parent of " + this + " because it is a child subgroup (" + group.getSubGroups() + ").");
        }
        if (this.parentGroup.get() != null) {
            this.parentGroup.get().subGroups.remove(this);
        }
        this.parentGroup.set(group);
        if (group != null) {
            group.subGroups.add(this);
        }
    }

    public StockGroup getParentGroup() {
        return this.parentGroup.get();
    }

    public static List<StockGroup> getTopLevelStockGroups() {
        List<StockGroup> retval = null;
        Object[] params = new Object[]{};
        String select = Query.select(StockGroup.class).isNull(StockGroup.Properties.PARENT_GROUP).active(StockGroup.class).orderBy(StockGroup.Properties.LABEL).toString();
        retval = PersistenceManager.getObjectList(StockGroup.class, select, params);
        return retval;
    }

    public static List<StockGroup> getAllStockGroups() {
        List<StockGroup> retval = stockGroups.getList();
        return retval;
    }

    public static StockGroup getDefaultStockGroup() {
        StockGroup retval = null;
        List<StockGroup> topLevelGroups = StockGroup.getTopLevelStockGroups();
        if (topLevelGroups.size() > 0) {
            retval = topLevelGroups.get(0);
        }
        return retval;
    }

    public static StockGroup getUnassignedStockGroup() {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(StockGroup.class).equals(StockGroup.Properties.LABEL, "Unassigned Items");
        StockGroup unassignedGroup = PersistenceManager.getObject(StockGroup.class, oQuery.toString(), null);
        if (unassignedGroup == null) {
            unassignedGroup = new StockGroup();
            unassignedGroup.setLabel("Unassigned Items");
            unassignedGroup.save();
        } else {
            unassignedGroup.setSystemState("ACTIVE");
            unassignedGroup.save();
        }
        return unassignedGroup;
    }

    @Override
    public String toString() {
        return this.getName() != null ? this.getName() : "No Stock Group Name, ID :" + this.getID();
    }

    public void setGlCode(GLAccount newGLCode) {
        this.glCode.set(newGLCode);
    }

    public GLAccount getGlCode() {
        return this.glCode.get();
    }

    @Override
    public String getGlAccountCode() {
        if (this.glCode.get() == null) {
            if (this.getParentGroup() != null) {
                return this.getParentGroup().getGlAccountCode();
            }
            return AccountingExportManager.getInstance().getAccountingSettings().getDefaultCOGsGLCode().getGlCode();
        }
        return this.glCode.get().getGlCode();
    }

    public GLAccount getGlAccountOrDefault() {
        if (this.glCode.get() == null) {
            if (this.getParentGroup() != null) {
                return this.getParentGroup().getGlAccountOrDefault();
            }
            return AccountingExportManager.getInstance().getAccountingSettings().getDefaultCOGsGLCode();
        }
        return this.glCode.get();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (this.glCode != null) {
            this.glCode.saveChild();
        }
        if (PersistenceManager.save(this)) {
            stockGroups.clearCache();
        }
        this.subGroups.saveChild();
        this.stockItems.saveChild();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public String getLabelFull() {
        if (this.getParentGroup() == null) {
            return this.getName();
        }
        return this.getParentGroup().getLabelFull() + "/" + this.getName();
    }

    protected String getSystemState() {
        return this.systemState;
    }

    protected void setSystemState(String newState) {
        this.systemState = newState;
    }

    @Override
    public int getChildCount() {
        return treeNodeSupport.getChildCount(this);
    }

    @Override
    public int getIndex(TreeNode node) {
        return treeNodeSupport.getIndex(this, node);
    }

    @Override
    public TreeNode getParent() {
        return treeNodeSupport.getParent(this);
    }

    @Override
    public boolean isLeaf() {
        return treeNodeSupport.isLeaf(this);
    }

    public Enumeration children() {
        return treeNodeSupport.children(this);
    }

    @Override
    public boolean getAllowsChildren() {
        return treeNodeSupport.getAllowsChildren();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return treeNodeSupport.getChildAt(this, childIndex);
    }

    @Override
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public void addStockItem(StockItem item) {
        this.stockItems.add(item);
    }

    public void addSubgroup(StockGroup subgroup) {
        this.subGroups.add(subgroup);
    }

    public String getName() {
        return this.getLabel();
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property<GLAccount> GL_CODE;
        public PropertiedObject.Property<StockGroup> PARENT_GROUP;
        public PropertiedObject.Property<StockGroup> SUB_GROUPS;
        public PropertiedObject.Property<StockItem> STOCK_ITEMS;
        public PropertiedObject.Property<Long> MASTER_ID;
    }
}

