/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Assert;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockInvoiceEntrySaveContext;
import ordermate.database.stock.StockSupplier;
import ordermate.database.stock.StockTake;
import stockmate.database.interfaces.stock.StockInvoiceI;

public class StockInvoice
extends PersistentObject
implements Saveable,
StockInvoiceI,
Displayable {
    public static final Props Properties = new Props();
    public static final String INVOICE = "Invoice";
    public static final String CREDIT_NOTE = "Credit Note";
    public static final String DELIVERY_NOTE = "Delivery Note";
    public static final String PURCHASE_ORDER = "Purchase Order";
    public static final List<String> availableTypes = Collections.unmodifiableList(Arrays.asList("Invoice", "Credit Note", "Delivery Note", "Purchase Order"));
    public static final List<String> accountableTypes = Collections.unmodifiableList(Arrays.asList("Invoice", "Credit Note", "Delivery Note"));
    private String systemState = "ACTIVE";
    private String orderNumber = "";
    private String invoiceNumber = "";
    private Reference<StockSupplier> supplier;
    private Reference<StockArea> stockArea;
    private Date date;
    private Date creationDate;
    private Date dateExported;
    private String invoiceType;
    private Price expectedTotal;
    private Price adminCost;
    private Price freightCost;
    private Price discount;
    private PersistentWriteableList<StockInvoiceEntry> entries;
    private Date localCreationTime;

    public StockInvoice() {
        this.supplier = this.createReference(StockInvoice.Properties.SUPPLIER);
        this.stockArea = this.createReference(StockInvoice.Properties.STOCK_AREA);
        this.date = new Date();
        this.creationDate = null;
        this.dateExported = null;
        this.invoiceType = INVOICE;
        this.expectedTotal = null;
        this.adminCost = new Price(0.0, 0.0);
        this.freightCost = new Price(0.0, 0.0);
        this.discount = new Price(0.0, 0.0);
        this.entries = (PersistentWriteableList)this.createList(StockInvoice.Properties.ENTRIES);
        this.localCreationTime = new Date();
    }

    public static StockInvoice getInvoice(Long id) {
        if (id == null) {
            OrderMate.LOG.warn("Invoice id should not be null");
            return null;
        }
        return PersistenceManager.getByID(id, StockInvoice.class);
    }

    public boolean isActive() {
        return this.getSystemState().equals("ACTIVE");
    }

    @Override
    public void save() {
        if (!this.isPersistent()) {
            this.creationDate = null;
        }
        StockInvoiceEntrySaveContext context = null;
        if (this.isPersistent()) {
            context = new StockInvoiceEntrySaveContext();
            context.newStockAreaID = this.getStockArea().intID();
            try {
                long existingAreaID;
                context.oldStockAreaID = existingAreaID = Data.database.getInvoiceStockArea(this.intID());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        }
        PersistenceManager.save(this);
        if (!this.isPersistent()) {
            this.localCreationTime = new Date();
        }
        if (context != null) {
            this.entries.prepareForSave(context);
        }
        this.entries.saveChild();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void delete() {
        this.setSystemState("DELETED");
        for (StockInvoiceEntry entry : this.entries) {
            entry.deleteChild();
        }
        PersistenceManager.save(this);
    }

    public static List<String> getInvoiceTypes() {
        return availableTypes;
    }

    public static List<String> getAccountableInvoiceTypes() {
        return accountableTypes;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public void setDate(Date invoiceDate) {
        this.date = new Date(invoiceDate.getTime());
    }

    public Price getTotalCost() {
        Price cost = new Price(0.0, 0.0);
        for (StockInvoiceEntry entry : this.entries) {
            cost = cost.add(entry.getPricePaid());
        }
        cost = cost.add(this.freightCost);
        cost = cost.add(this.adminCost);
        cost = cost.subtract(this.discount);
        return cost;
    }

    public Price getTotalCostExTax() {
        return this.getTotalCost().subtract(this.getTaxAmount());
    }

    public Price getTaxAmount() {
        double baseRate = SystemProperty.getInstance().getBaseTaxRate();
        double tax = 0.0;
        for (StockInvoiceEntry entry : this.entries) {
            tax += entry.getIncludedTax().doubleValue();
        }
        tax += FinanceUtils.getTaxValue(this.freightCost.doubleValue(), baseRate);
        tax += FinanceUtils.getTaxValue(this.adminCost.doubleValue(), baseRate);
        return new Price(tax -= FinanceUtils.getTaxValue(this.discount.doubleValue(), baseRate), 0.0);
    }

    public List<StockInvoiceEntry> getEntries() {
        return this.entries.getUnmodifiable();
    }

    public void addEntry(StockInvoiceEntry received) {
        received.setInvoice(this);
        if (!this.entries.contains(received)) {
            this.entries.add(received);
        }
    }

    public void setInvoiceType(String type) {
        this.invoiceType = type;
        boolean positiveValues = !type.equals(CREDIT_NOTE);
        for (StockInvoiceEntry entry : this.entries) {
            entry.setValueSign(positiveValues);
        }
        if (this.expectedTotal != null) {
            double expectedTotalVal = this.expectedTotal.doubleValue();
            expectedTotalVal = positiveValues ? Math.abs(expectedTotalVal) : -Math.abs(expectedTotalVal);
            this.expectedTotal = new Price(expectedTotalVal, 0.01);
        }
        double admin = positiveValues ? Math.abs(this.adminCost.doubleValue()) : -Math.abs(this.adminCost.doubleValue());
        double freight = positiveValues ? Math.abs(this.freightCost.doubleValue()) : -Math.abs(this.freightCost.doubleValue());
        double disc = positiveValues ? Math.abs(this.discount.doubleValue()) : -Math.abs(this.discount.doubleValue());
        this.adminCost = new Price(admin, 0.0);
        this.freightCost = new Price(freight, 0.0);
        this.discount = new Price(disc, 0.0);
    }

    public String getInvoiceType() {
        return this.invoiceType;
    }

    public void removeEntry(StockInvoiceEntry received) {
        received.setSystemState("ACTIVE");
        this.entries.remove(received);
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String str) {
        this.invoiceNumber = str;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String str) {
        this.orderNumber = str;
    }

    public StockSupplier getSupplier() {
        return this.supplier.get();
    }

    public void setSupplier(StockSupplier stockSupplier) {
        this.supplier.set(stockSupplier);
    }

    public StockArea getStockArea() {
        return this.stockArea.get();
    }

    public Price getExpectedTotal() {
        return this.expectedTotal;
    }

    public void setExpectedTotal(Price expectedTotalCost) {
        this.expectedTotal = expectedTotalCost;
    }

    public void setStockArea(StockArea newArea) {
        this.stockArea.set(newArea);
    }

    public void setAdminCost(Price cost) {
        this.adminCost = cost;
    }

    public Price getAdminCost() {
        return this.adminCost;
    }

    public void setFreightCost(Price cost) {
        this.freightCost = cost;
    }

    public Price getFreightCost() {
        return this.freightCost;
    }

    public void setDiscount(Price discountValue) {
        this.discount = discountValue;
    }

    public Date getCreationDate() {
        return this.creationDate != null ? new Date(this.creationDate.getTime()) : new Date(this.localCreationTime.getTime());
    }

    public Price getDiscount() {
        return this.discount;
    }

    public void setDateExported(Date dateExported) {
        this.dateExported = dateExported;
    }

    public Date getDateExported() {
        return this.dateExported;
    }

    public boolean isFrozen() {
        long invoiceCreationDate = this.getCreationDate().getTime();
        StockTake lastSavedStockTake = StockTake.getLastSavedStockTake();
        if (lastSavedStockTake == null || PURCHASE_ORDER.equals(this.invoiceType)) {
            return false;
        }
        return invoiceCreationDate < lastSavedStockTake.getDate().getTime();
    }

    @Override
    public String getLabel() {
        String orderNum = this.getOrderNumber();
        return orderNum != null ? orderNum : "<Invoice>";
    }

    public StockInvoice convertPurchaseOrderToInvoice() {
        Assert.isEqual(this.invoiceType, PURCHASE_ORDER, "Invoice must be a purchase order in order to convert");
        StockInvoice invoice = new StockInvoice();
        invoice.setInvoiceType(INVOICE);
        invoice.setDate(this.getDate());
        invoice.setOrderNumber(this.getOrderNumber());
        invoice.setInvoiceNumber(this.getOrderNumber());
        invoice.setSupplier(this.getSupplier());
        invoice.setStockArea(this.getStockArea());
        for (StockInvoiceEntry entry : this.entries) {
            StockInvoiceEntry newEntry = new StockInvoiceEntry(entry);
            invoice.addEntry(newEntry);
        }
        return invoice;
    }

    public static List getAllStockInvoices() {
        return PersistenceManager.getObjectList(StockInvoice.class, "SELECT stock_invoice.* FROM stock_invoice WHERE stock_invoice.system_state = 'ACTIVE' ORDER BY CreationDate ", null);
    }

    public static List getStockInvoicesForSupplier(StockSupplier supplier) {
        String sql = Query.select(StockInvoice.class).equalsParam(StockInvoice.Properties.SUPPLIER).active(StockInvoice.class).orderBy(StockInvoice.Properties.CREATION_DATE).toString();
        Object[] params = new Object[]{supplier.getID()};
        return PersistenceManager.getObjectList(StockInvoice.class, sql, params);
    }

    public static List getStockInvoicesForDates(Date from, Date to) {
        Object[] params = new Object[]{from, to};
        return PersistenceManager.getObjectList(StockInvoice.class, "SELECT stock_invoice.* FROM stock_invoice WHERE stock_invoice.system_state = 'ACTIVE' AND Date >= ? AND Date <= ? ORDER BY Date ", params);
    }

    public static List getStockInvoicesForCreationDates(Date from, Date to) {
        Object[] params = new Object[]{from, to};
        return PersistenceManager.getObjectList(StockInvoice.class, "SELECT stock_invoice.* FROM stock_invoice WHERE stock_invoice.system_state = 'ACTIVE' AND CreationDate >= ? AND CreationDate <= ? ORDER BY CreationDate ", params);
    }

    public static StockInvoice getStockInvoiceForNumber(String invoiceNumber) {
        Object[] params = new Object[]{invoiceNumber};
        return PersistenceManager.getObject(StockInvoice.class, "SELECT stock_invoice.* FROM stock_invoice WHERE stock_invoice.system_state = 'ACTIVE' AND InvoiceNumber = ? LIMIT 1 ", params);
    }

    @Override
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    public Color getForegroundColor() {
        return null;
    }

    @Override
    public String getIcon() {
        return "";
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    private void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    private String getSystemState() {
        return this.systemState;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<String> ORDER_NUMBER;
        public PropertiedObject.Property<String> INVOICE_NUMBER;
        public PropertiedObject.Property<StockSupplier> SUPPLIER;
        public PropertiedObject.Property<StockArea> STOCK_AREA;
        public PropertiedObject.Property<Date> DATE;
        public PropertiedObject.Property<Price> EXPECTED_TOTAL;
        public PropertiedObject.Property<String> INVOICE_TYPE;
        public PropertiedObject.Property<Date> CREATION_DATE;
        public PropertiedObject.Property ADMIN_COST;
        public PropertiedObject.Property FREIGHT_COST;
        public PropertiedObject.Property DISCOUNT;
        public PropertiedObject.Property<StockInvoiceEntry> ENTRIES;
        public PropertiedObject.Property<Date> DATE_EXPORTED;
    }
}

