/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.rmi.RemoteException;
import ordermate.database.Data;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockInvoiceEntrySaveContext;
import ordermate.database.stock.StockItem;
import stockmate.database.interfaces.stock.StockInvoiceEntryI;

public class StockInvoiceEntry
extends PersistentObject
implements SaveableChild,
StockInvoiceEntryI,
Displayable {
    public static final Props Properties = new Props();
    private String systemState = "ACTIVE";
    private Reference<StockItem> stockItem;
    private Reference<StockInvoice> invoice;
    private double numReceived;
    private double bonusReceived;
    private Price pricePaid;
    private boolean taxIncluded;
    public static final int SAVE_COST_MODE_AVERAGE = 0;
    public static final int SAVE_COST_MODE_NEW = 1;
    private int saveCostMode;
    private String cachedBonusQuantityString;
    private String cachedQuantityString;
    private StockInvoiceEntrySaveContext saveContext;

    public StockInvoiceEntry() {
        this.stockItem = this.createReference(StockInvoiceEntry.Properties.STOCK_ITEM);
        this.invoice = this.createReference(StockInvoiceEntry.Properties.INVOICE);
        this.numReceived = 1.0;
        this.bonusReceived = 0.0;
        this.pricePaid = new Price(Price.ZERO, 0.0);
        this.taxIncluded = true;
        this.saveCostMode = 0;
        this.cachedBonusQuantityString = null;
        this.cachedQuantityString = null;
        this.saveContext = null;
        this.saveCostMode = SystemProperty.getInstance().getStockInvoicePricePreference().ordinal();
    }

    public StockInvoiceEntry(StockInvoiceEntry entry) {
        this.stockItem = this.createReference(StockInvoiceEntry.Properties.STOCK_ITEM);
        this.invoice = this.createReference(StockInvoiceEntry.Properties.INVOICE);
        this.numReceived = 1.0;
        this.bonusReceived = 0.0;
        this.pricePaid = new Price(Price.ZERO, 0.0);
        this.taxIncluded = true;
        this.saveCostMode = 0;
        this.cachedBonusQuantityString = null;
        this.cachedQuantityString = null;
        this.saveContext = null;
        this.setStockItem(entry.getStockItem());
        this.setNumReceived(entry.getNumReceived());
        this.setBonusReceived(entry.getBonusReceived());
        this.setPricePaid(entry.getPricePaid());
        this.setTaxIncluded(entry.isTaxIncluded());
    }

    @Override
    public String getLabel() {
        String stockItemString = "(none)";
        StockItem item = this.getStockItem();
        if (item != null) {
            stockItemString = item.getLabel();
        }
        return stockItemString + " x " + MathsUtils.roundDoubleToDecPlaces(this.getNumReceived(), 2);
    }

    @Override
    public void saveChild() {
        StockInvoice stockInvoice = this.getInvoice();
        if (stockInvoice.getInvoiceType().equals("Purchase Order")) {
            PersistenceManager.saveChild(this);
        } else {
            boolean firstSave = !this.isPersistent();
            StockArea area = stockInvoice.getStockArea();
            StockItem item = this.getStockItem();
            long oldAreaID = area.intID();
            long newAreaID = area.intID();
            if (this.saveContext != null) {
                oldAreaID = this.saveContext.oldStockAreaID;
                newAreaID = this.saveContext.newStockAreaID;
            }
            try {
                if (firstSave) {
                    long newID = Data.database.createStockInvoiceEntry(item.intID(), this.numReceived, this.bonusReceived, this.pricePaid.doubleValue(), stockInvoice.intID(), stockInvoice.getInvoiceType(), this.taxIncluded, area.intID());
                    this.setID_WorkAround(new Long(newID));
                } else {
                    Data.database.updateInvoiceEntry(this.intID(), this.numReceived, this.bonusReceived, item.intID(), oldAreaID, newAreaID, this.pricePaid.doubleValue());
                }
                double costPerUnit = this.getPricePaidPerUnit().doubleValue();
                if (this.saveCostMode == 1) {
                    Data.database.setStockItemAverageCostPerUnit(item.intID(), newAreaID, costPerUnit);
                }
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        }
        this.saveContext = null;
    }

    String getSystemState() {
        return this.systemState;
    }

    void setSystemState(String sysState) {
        this.systemState = sysState;
    }

    public int getSaveCostMode() {
        return this.saveCostMode;
    }

    public boolean overridesCost() {
        return this.saveCostMode == 1;
    }

    public void setOverridesCost(boolean b) {
        this.setSaveCostMode(b ? 1 : 0);
    }

    public void setSaveCostMode(int saveCostModeOption) {
        this.saveCostMode = saveCostModeOption;
    }

    @Override
    public void prepareForSave(SaveContext context) {
        this.saveContext = (StockInvoiceEntrySaveContext)context;
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void deleteChild() {
        if (this.systemState.equals("ACTIVE")) {
            this.systemState = "DELETED";
            try {
                Data.database.deleteStockInvoiceEntry(this.intID(), this.getInvoice().getInvoiceType());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        }
    }

    public String getOuterQuantityString() {
        StockItem item = this.getStockItem();
        Quantity quantityPerUnit = item.getPurchaseQty();
        double outerMult = item.getOuterQuantity();
        if (outerMult == 1.0 || item.getOuterContainer() == null) {
            return this.getQuantityString();
        }
        double numOuters = (int)(this.numReceived * quantityPerUnit.doubleValue() / (outerMult * quantityPerUnit.doubleValue()));
        String outerString = "";
        if (!MathsUtils.approxEquals(numOuters, 0.0)) {
            outerString = outerString + MeasureUnitHelper.stringify(numOuters, item.getOuterContainer());
        }
        double numInners = this.numReceived * quantityPerUnit.doubleValue() % (outerMult * quantityPerUnit.doubleValue());
        String innerString = "";
        if (numOuters == 0.0 || !MathsUtils.approxEquals(numInners, 0.0)) {
            Quantity innerQuantity = new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), numInners, false);
            if (outerString.length() > 0) {
                innerString = innerString + " + ";
            }
            innerString = innerString + innerQuantity;
        }
        return outerString + innerString;
    }

    public String getOuterBonusQuantityString() {
        StockItem item = this.getStockItem();
        Quantity quantityPerUnit = item.getPurchaseQty();
        double outerMult = item.getOuterQuantity();
        if (outerMult == 1.0 || item.getOuterContainer() == null) {
            return this.getBonusQuantityString();
        }
        double numOuters = (int)(this.bonusReceived * quantityPerUnit.doubleValue() / (outerMult * quantityPerUnit.doubleValue()));
        String outerString = "";
        if (!MathsUtils.approxEquals(numOuters, 0.0)) {
            outerString = outerString + MeasureUnitHelper.stringify(numOuters, item.getOuterContainer());
        }
        double numInners = this.bonusReceived * quantityPerUnit.doubleValue() % (outerMult * quantityPerUnit.doubleValue());
        String innerString = "";
        if (numOuters == 0.0 || !MathsUtils.approxEquals(numInners, 0.0)) {
            Quantity innerQuantity = new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), numInners, false);
            if (outerString.length() > 0) {
                innerString = innerString + " + ";
            }
            innerString = innerString + innerQuantity;
        }
        return outerString + innerString;
    }

    public String getQuantityString() {
        if (this.cachedQuantityString == null) {
            Quantity qtyPerUnit = this.getStockItem().getPurchaseQty();
            double numReceivedRounded = MathsUtils.roundDoubleToDecPlaces(this.getNumReceived(), 3);
            this.cachedQuantityString = String.valueOf(numReceivedRounded);
            this.cachedQuantityString = this.cachedQuantityString + " x " + qtyPerUnit;
        }
        return this.cachedQuantityString;
    }

    public String getBonusQuantityString() {
        if (this.cachedBonusQuantityString == null) {
            Quantity qtyPerUnit = this.getStockItem().getPurchaseQty();
            double theBonusReceived = MathsUtils.roundDoubleToDecPlaces(this.getBonusReceived(), 3);
            this.cachedBonusQuantityString = String.valueOf(theBonusReceived);
            if (qtyPerUnit.doubleValue() == 1.0) {
                this.cachedBonusQuantityString = this.cachedBonusQuantityString + qtyPerUnit.getMeasureUnit().getSuffix();
            } else if (theBonusReceived > 0.0) {
                this.cachedBonusQuantityString = this.cachedBonusQuantityString + " x " + qtyPerUnit;
            }
        }
        return this.cachedBonusQuantityString;
    }

    public StockItem getStockItem() {
        return this.stockItem.get();
    }

    public void setStockItem(StockItem newItem) {
        this.stockItem.set(newItem);
        this.cachedBonusQuantityString = null;
        this.cachedQuantityString = null;
        this.setTaxIncluded(newItem.isTaxIncluded());
    }

    public Price getPricePaid() {
        return this.pricePaid;
    }

    public Price getPricePaidExTax() {
        if (this.isTaxIncluded()) {
            return this.pricePaid.subtract(this.getIncludedTax());
        }
        return this.pricePaid;
    }

    public void setPricePaid(Price price) {
        this.pricePaid = price;
    }

    public Price getIncludedTax() {
        double retval = 0.0;
        if (this.isTaxIncluded()) {
            retval = FinanceUtils.getTaxValue(this.pricePaid.doubleValue(), SystemProperty.getInstance().getBaseTaxRate());
        }
        return new Price(retval, 0.0);
    }

    public boolean isTaxIncluded() {
        return this.taxIncluded;
    }

    public void setTaxIncluded(boolean b) {
        this.taxIncluded = b;
    }

    public void setPricePaidPerUnit(Price pricePerUnit) {
        double pricePaidTotal = pricePerUnit.doubleValue() * this.getNumReceived();
        this.setPricePaid(new Price(pricePaidTotal, 0.0));
    }

    public Price getPricePaidPerUnit() {
        double pricePaidPerUnit = 0.0;
        if (this.getNumReceived() != 0.0) {
            pricePaidPerUnit = this.pricePaid.doubleValue() / this.getNumReceived();
        }
        return new Price(pricePaidPerUnit, 0.01);
    }

    public double getTotalReceived() {
        return this.getNumReceived() + this.getBonusReceived();
    }

    void setValueSign(boolean positive) {
        this.numReceived = positive ? Math.abs(this.numReceived) : -Math.abs(this.numReceived);
        this.bonusReceived = positive ? Math.abs(this.bonusReceived) : -Math.abs(this.bonusReceived);
        double price = positive ? Math.abs(this.pricePaid.doubleValue()) : -Math.abs(this.pricePaid.doubleValue());
        this.pricePaid = new Price(price, 0.0);
    }

    public double getNumReceived() {
        return this.numReceived;
    }

    public void setNumReceived(double newNumReceived) {
        this.cachedQuantityString = null;
        this.numReceived = newNumReceived;
    }

    public void setBonusReceived(double newBonusReceived) {
        this.cachedBonusQuantityString = null;
        this.bonusReceived = newBonusReceived;
    }

    public Quantity getTotalReceivedQuantity() {
        double totalReceived = this.getNumReceived() + this.getBonusReceived();
        return new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), totalReceived, false);
    }

    public Quantity getTotalReceivedPaidQuantity() {
        double totalReceivedPaid = this.getNumReceived();
        return new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), totalReceivedPaid, false);
    }

    public Quantity getTotalReceivedBonusQuantity() {
        double totalBonusReceived = this.getBonusReceived();
        return new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), totalBonusReceived, false);
    }

    public double getBonusReceived() {
        return this.bonusReceived;
    }

    public StockInvoice getInvoice() {
        return this.invoice.get();
    }

    void setInvoice(StockInvoice newInvoice) {
        this.invoice.set(newInvoice);
    }

    @Override
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    public Color getForegroundColor() {
        return null;
    }

    @Override
    public String getIcon() {
        return "";
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<StockItem> STOCK_ITEM;
        public PropertiedObject.Property<StockInvoice> INVOICE;
        public PropertiedObject.Property<Double> NUM_RECEIVED;
        public PropertiedObject.Property<Double> BONUS_RECEIVED;
        public PropertiedObject.Property<Price> PRICE_PAID;
        public PropertiedObject.Property TAX_INCLUDED;
        public PersistentObject.DerivedProperty<Price> PRICE_PAID_PER_UNIT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockInvoiceEntry.class), "pricePaidPerUnit");
    }
}

