/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.MinMax;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.database.EventContext;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.config.MeasureContainer;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.finance.CostedItem;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.sales.SalesComponent;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockBarcode;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItemParLevel;
import ordermate.database.stock.StockItemSupplier;
import ordermate.database.stock.StockLink;
import ordermate.database.stock.StockLinkable;
import ordermate.database.stock.StockOnHand;
import ordermate.database.stock.StockParLevel;
import ordermate.database.stock.StockSupplier;
import ordermate.database.stock.StockYieldHelper;
import ordermate.database.stock.usage.PreProdManager;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.database.stock.usagelink.StockItemIngredientLink;
import ordermate.database.stock.usagelink.StockUsageLink;
import ordermate.database.stock.usagelink.StockUsageModLink;
import ordermate.database.users.User;
import stockmate.database.interfaces.stock.MeasureUnitI;
import stockmate.database.interfaces.stock.StockItemI;

public class StockItem
extends PersistentDisplayableObject
implements Saveable,
StockItemI,
ExportableObject,
StockLinkable<StockItemIngredientLink>,
CostedItem {
    public static final Props Properties = new Props();
    private static boolean cached = false;
    private String systemState = "ACTIVE";
    private double currentCost = 0.0;
    private double oldCost = 0.0;
    private boolean taxIncluded = true;
    private double yield = 0.0;
    private double purchaseQty = 1.0;
    private String shortName = "";
    private Reference<MeasureContainer> outerContainer;
    private double outerQuantity;
    private Reference<MeasureUnitContainer> displayMeasureUnitContainer;
    private Reference<MeasureUnit> ingredientMeasureUnit;
    private Date creationTime;
    private PersistentWriteableList<StockOnHand> stockOnHand;
    private PersistentWriteableList<StockItemSupplier> stockItemSuppliers;
    private PersistentWriteableList<StockBarcode> stockBarcodes;
    private Integer stockIdentifier;
    private Date localCreationTime;
    private Price temporaryCost;
    private boolean quantityHasChanged;
    private Quantity oldQuantity;
    private Reference<StockGroup> stockGroup;
    private Quantity cachedStockOnHand;
    private Long extId;
    private Long masterId;
    private PersistentWriteableList<StockItemIngredientLink> stockIngredientLinks;
    private PersistentWriteableList<StockItemParLevel> stockItemParLevels;
    private String containerName;
    private boolean replacementCostMatchPreProdCost;

    public StockItem() {
        this.outerContainer = this.createReference(StockItem.Properties.OUTER_CONTAINER);
        this.outerQuantity = 1.0;
        this.displayMeasureUnitContainer = this.createReference(StockItem.Properties.DISPLAY_MEASURE_UNIT_CONTAINER);
        this.ingredientMeasureUnit = this.createReference(StockItem.Properties.INGREDIENT_MEASURE_UNIT);
        this.creationTime = null;
        this.stockOnHand = (PersistentWriteableList)this.createList(StockItem.Properties.STOCK_ON_HAND);
        this.stockItemSuppliers = (PersistentWriteableList)this.createList(StockItem.Properties.STOCK_ITEM_SUPPLIERS);
        this.stockBarcodes = (PersistentWriteableList)this.createList(StockItem.Properties.STOCK_BARCODES);
        this.localCreationTime = new Date();
        this.temporaryCost = Price.ZERO_DOLLAR;
        this.quantityHasChanged = false;
        this.oldQuantity = null;
        this.stockGroup = this.createReference(StockItem.Properties.STOCK_GROUP);
        this.stockIngredientLinks = this.createWriteableList(StockItem.Properties.STOCK_INGREDIENT_LINKS);
        this.stockItemParLevels = this.createWriteableList(StockItem.Properties.STOCK_ITEM_PAR_LEVELS);
        this.containerName = null;
        MeasureUnit unit = MeasureUnitHelper.getMeasureUnit("unit");
        this.setDisplayMeasureUnitContainer(new MeasureUnitContainer(unit));
        this.setIngredientMeasureUnit(unit);
    }

    private StockItem(StockItem toCopy) {
        this.outerContainer = this.createReference(StockItem.Properties.OUTER_CONTAINER);
        this.outerQuantity = 1.0;
        this.displayMeasureUnitContainer = this.createReference(StockItem.Properties.DISPLAY_MEASURE_UNIT_CONTAINER);
        this.ingredientMeasureUnit = this.createReference(StockItem.Properties.INGREDIENT_MEASURE_UNIT);
        this.creationTime = null;
        this.stockOnHand = (PersistentWriteableList)this.createList(StockItem.Properties.STOCK_ON_HAND);
        this.stockItemSuppliers = (PersistentWriteableList)this.createList(StockItem.Properties.STOCK_ITEM_SUPPLIERS);
        this.stockBarcodes = (PersistentWriteableList)this.createList(StockItem.Properties.STOCK_BARCODES);
        this.localCreationTime = new Date();
        this.temporaryCost = Price.ZERO_DOLLAR;
        this.quantityHasChanged = false;
        this.oldQuantity = null;
        this.stockGroup = this.createReference(StockItem.Properties.STOCK_GROUP);
        this.stockIngredientLinks = this.createWriteableList(StockItem.Properties.STOCK_INGREDIENT_LINKS);
        this.stockItemParLevels = this.createWriteableList(StockItem.Properties.STOCK_ITEM_PAR_LEVELS);
        this.containerName = null;
        this.setLabel(toCopy.getLabel());
        this.systemState = toCopy.systemState;
        this.currentCost = toCopy.currentCost;
        this.oldCost = toCopy.oldCost;
        this.yield = toCopy.yield;
        this.taxIncluded = toCopy.taxIncluded;
        this.purchaseQty = toCopy.purchaseQty;
        this.shortName = toCopy.shortName;
        this.outerContainer.set(toCopy.outerContainer.get());
        this.outerQuantity = toCopy.outerQuantity;
        this.displayMeasureUnitContainer.set(new MeasureUnitContainer(toCopy.displayMeasureUnitContainer.get().getMeasureUnit(), toCopy.displayMeasureUnitContainer.get().getMeasureContainer(), toCopy.displayMeasureUnitContainer.get().getQuantityPerContainer()));
        this.ingredientMeasureUnit.set(toCopy.ingredientMeasureUnit.get());
        this.extId = toCopy.extId;
        this.replacementCostMatchPreProdCost = toCopy.replacementCostMatchPreProdCost;
    }

    public StockItem clone() {
        return new StockItem(this);
    }

    public static StockItem getStockItemForName(String name) {
        return StockItemQueries.getStockItemForName(name);
    }

    @Override
    public void save() {
        boolean firstSave;
        if (this.systemState == "ACTIVE") {
            if (this.getStockGroup() == null) {
                throw new IllegalStateException("The stock item " + this + " has no stock group and cannot be saved.");
            }
            if (!this.getStockGroup().isPersistent()) {
                throw new IllegalStateException("The stock item " + this + " has a non persistent stock group so this prevents this item from being associated to a stock group.");
            }
        }
        boolean bl = firstSave = !this.isPersistent();
        if (firstSave) {
            this.initStockOnHand();
        }
        if (!this.isPersistent()) {
            this.localCreationTime = new Date();
        }
        this.displayMeasureUnitContainer.saveChild();
        PersistenceManager.save(this);
        this.stockIngredientLinks.saveChild();
        this.stockItemSuppliers.saveChild();
        this.stockBarcodes.saveChild();
        this.stockItemParLevels.saveChild();
        if (firstSave) {
            try {
                Data.database.addLiveStockEntriesForNewStockItem(this.intID());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        }
        this.stockOnHand.saveChild();
        if (!firstSave) {
            try {
                MeasureUnitI oldMeasureUnit;
                MeasureUnitI newMeasureUnit;
                if (this.oldQuantity != null && !(newMeasureUnit = this.getPurchaseQty().getMeasureUnit()).equals(oldMeasureUnit = this.oldQuantity.getMeasureUnit())) {
                    Data.database.adjustStockForChangedStockItemMeasureUnit(this.intID(), newMeasureUnit.getName(), oldMeasureUnit.getName());
                }
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        }
        this.quantityHasChanged = false;
        this.oldQuantity = null;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this) || this.stockItemSuppliers.hasChildChanged() || this.stockBarcodes.hasChildChanged();
    }

    @Override
    public void delete() {
        for (StockUsageLink link : this.getAllStockUsageLinks()) {
            link.deleteChild();
        }
        this.clearStockUsage();
        this.setSystemState("DELETED");
        this.save();
    }

    public StockItem reload() {
        this.stockOnHand = (PersistentWriteableList)this.createList(StockItem.Properties.STOCK_ON_HAND);
        this.cachedStockOnHand = null;
        return this;
    }

    public static void setCached(boolean b) {
        cached = b;
    }

    public static boolean isCached() {
        return cached;
    }

    public String getName() {
        return this.getLabel();
    }

    public void setName(String str) {
        this.setLabel(str);
    }

    public StockOnHand getStockOnHandObject(StockArea area) {
        for (StockOnHand soh : this.getStockOnHand()) {
            if (!soh.stockAreaEquals(area)) continue;
            return soh;
        }
        OrderMateLog.LOG.warn("StockArea " + area + " was not found within the SOH list for item :" + this.getLabel() + " creating a new one.");
        StockOnHand newStockOnHand = new StockOnHand(this, area);
        newStockOnHand.saveChild();
        this.stockOnHand.add(newStockOnHand);
        return newStockOnHand;
    }

    private void initStockOnHand() {
        if (this.getStockOnHand().size() == 0) {
            for (StockArea area : StockArea.getStockAreas()) {
                StockOnHand soh = new StockOnHand(this, area);
                soh.setOnHandCostPerItem(this.getCurrentReplacementCost());
                this.stockOnHand.add(soh);
            }
        }
    }

    private boolean doReplacementCostCheck(Price cost) {
        ExperimentalFeature disableCostReplacementCostCheck = ExperimentalFeature.find("DISABLE_COST_REPLACEMENT_COST_CHECK");
        if (disableCostReplacementCostCheck != null && disableCostReplacementCostCheck.getBooleanValue(Boolean.FALSE).booleanValue()) {
            return true;
        }
        return !cost.equals(this.getCurrentReplacementCost());
    }

    public void setCurrentCost(Price cost) {
        if (this.doReplacementCostCheck(cost)) {
            this.oldCost = this.currentCost;
            this.currentCost = cost.doubleValue();
            if (this.getStockOnHand().size() > 0) {
                for (StockOnHand soh : this.getStockOnHand()) {
                    if (!MathsUtils.approxEquals(0.0, soh.getQuantity())) continue;
                    soh.setOnHandCostPerItem(cost);
                }
            }
        }
    }

    public Price getOldCost() {
        return new Price(this.oldCost, 0.0);
    }

    public void setOldCost(Price cost) {
        this.oldCost = cost.doubleValue();
    }

    public Quantity getPurchaseQty() {
        return new Quantity(this.getDisplayMeasureUnitContainer(), this.purchaseQty, true);
    }

    public void setPurchaseQty(MeasureUnit dispMeasureUnit, double rawAmount) {
        this.setPurchaseQty(new Quantity((MeasureUnitI)dispMeasureUnit, rawAmount));
    }

    public void setPurchaseQty(Quantity qty) {
        if (this.isPersistent()) {
            this.quantityHasChanged = true;
        }
        this.oldQuantity = this.getPurchaseQty();
        this.purchaseQty = qty.getRawValue();
        this.displayMeasureUnitContainer.get().setMeasureUnit((MeasureUnit)qty.getMeasureUnit());
    }

    public Quantity getTotalStockOnHand() {
        try {
            return new Quantity(this.getDisplayMeasureUnitContainer(), Data.database.getTotalStockOnHandForItem(this.intID()), true);
        }
        catch (RemoteException ex) {
            Data.handleException(ex);
            return null;
        }
    }

    public Quantity getStockOnHand(StockArea area) {
        return this.getStockOnHandObject(area).getTotalQuantity(this.getDisplayMeasureUnitContainer());
    }

    public boolean isDeleted() {
        return this.getSystemState().equals("DELETED");
    }

    public List<StockSupplier> getSuppliers() {
        ArrayList<StockSupplier> suppliers = new ArrayList<StockSupplier>(this.stockItemSuppliers.size());
        for (StockItemSupplier stockItemSupplier : this.stockItemSuppliers) {
            suppliers.add(stockItemSupplier.getStockSupplier());
        }
        return suppliers;
    }

    @Deprecated
    public List<Pair<StockSupplier, String>> getSupplierCodePairs() {
        ArrayList<Pair<StockSupplier, String>> supplierCodePairs = new ArrayList<Pair<StockSupplier, String>>(this.stockItemSuppliers.size());
        for (StockItemSupplier stockItemSupplier : this.stockItemSuppliers) {
            Pair<StockSupplier, String> pair = new Pair<StockSupplier, String>(stockItemSupplier.getStockSupplier(), stockItemSupplier.getProductCode());
            supplierCodePairs.add(pair);
        }
        return supplierCodePairs;
    }

    @Deprecated
    public void setSupplierCodePairs(List<Pair<StockSupplier, String>> suppliersAndProdCodes) {
        this.clearSuppliers();
        for (Pair<StockSupplier, String> pair : suppliersAndProdCodes) {
            StockSupplier supplier = pair.getKey();
            String code = pair.getValue();
            if (supplier == null) continue;
            this.addSupplier(supplier, code);
        }
    }

    public List<StockItemSupplier> getStockItemSuppliers() {
        return this.stockItemSuppliers.getUnmodifiable();
    }

    public boolean hasSupplier(StockSupplier supplier) {
        return this.getSuppliers().contains(supplier);
    }

    public void clearSuppliers() {
        this.stockItemSuppliers.clear();
    }

    public void addSupplier(StockSupplier aSupplier, String aProdCode) {
        if (this.getSuppliers().contains(aSupplier)) {
            this.removeSupplier(aSupplier);
        }
        if (aSupplier == null) {
            throw new NullPointerException("The supplier is null [" + this + "-" + aProdCode + "]");
        }
        StockItemSupplier itemSupplier = this.getStockItemSupplier(aSupplier);
        if (itemSupplier == null) {
            itemSupplier = new StockItemSupplier(aProdCode, this, aSupplier);
        } else {
            itemSupplier.setProductCode(aProdCode);
        }
        this.stockItemSuppliers.add(itemSupplier);
    }

    public void addSupplier(StockSupplier supplier) {
        this.addSupplier(supplier, "");
    }

    public void removeSupplier(StockSupplier supplier) {
        for (StockItemSupplier itemSupplier : this.stockItemSuppliers) {
            if (!itemSupplier.getStockSupplier().equals(supplier)) continue;
            this.stockItemSuppliers.remove(itemSupplier);
            break;
        }
    }

    public String getProductCode(StockSupplier supplier) {
        StockItemSupplier itemSupplier = this.getStockItemSupplier(supplier);
        return itemSupplier == null ? null : itemSupplier.getProductCode();
    }

    public StockItemSupplier getStockItemSupplier(StockSupplier supplier) {
        for (StockItemSupplier itemSupplier : this.stockItemSuppliers) {
            if (itemSupplier.getStockSupplier() == null || !itemSupplier.getStockSupplier().equals(supplier)) continue;
            return itemSupplier;
        }
        return null;
    }

    public boolean updateProductCode(StockSupplier supplier, String code) {
        for (StockItemSupplier itemSupplier : this.stockItemSuppliers) {
            if (!itemSupplier.getStockSupplier().equals(supplier)) continue;
            itemSupplier.setProductCode(code);
            return true;
        }
        return false;
    }

    public List<String> getProductCodes() {
        ArrayList<String> productCodes = new ArrayList<String>(this.stockItemSuppliers.size());
        for (StockItemSupplier stockItemSupplier : this.stockItemSuppliers) {
            productCodes.add(stockItemSupplier.getProductCode());
        }
        return productCodes;
    }

    public boolean hasProductCode(String prodCode) {
        return this.getProductCodes().contains(prodCode);
    }

    public Date getCreationTime() {
        return this.creationTime != null ? this.creationTime : this.localCreationTime;
    }

    public double getOuterQuantity() {
        return this.outerQuantity;
    }

    public String getOuterName() {
        return this.outerContainer.isNull() ? "" : this.outerContainer.get().getLabel();
    }

    public String getOuterDisplayName() {
        if (this.outerContainer.isNull()) {
            return "x " + this.purchaseQty / this.getDisplayMeasureUnitContainer().getMultiplier() + " " + this.getDisplayMeasureUnit().getSuffix();
        }
        return this.outerContainer.get().getLabel();
    }

    public void setOuterName(String name) {
        if (name == null || name.equals("")) {
            this.outerContainer.set(null);
        } else {
            MeasureContainer container = MeasureUnitHelper.getContainerForName(name);
            if (container == null) {
                container = new MeasureContainer(name);
                container.save();
            }
            this.outerContainer.set(container);
        }
    }

    public void setOuterQuantity(double qty) {
        this.outerQuantity = qty;
    }

    public double getRawOuterQuantity() {
        return this.outerQuantity * this.getDisplayMeasureUnitContainer().getMultiplier();
    }

    public MeasureContainer getOuterContainer() {
        return this.outerContainer.get();
    }

    public void setOuterContainer(MeasureContainer newContainer) {
        this.outerContainer.set(newContainer);
    }

    public MeasureUnitContainer getDisplayMeasureUnitContainer() {
        return this.displayMeasureUnitContainer.get();
    }

    public void setDisplayMeasureUnitContainer(MeasureUnitContainer link) {
        if (link != null) {
            this.displayMeasureUnitContainer.set(link);
        }
    }

    @Deprecated
    public MeasureUnitI getDisplayMeasureUnit() {
        if (this.displayMeasureUnitContainer.get().getMeasureUnit() == null) {
            this.displayMeasureUnitContainer.get().setMeasureUnit(MeasureUnitHelper.getMeasureUnit("unit"));
        }
        return this.displayMeasureUnitContainer.get().getMeasureUnit();
    }

    @Deprecated
    public void setDisplayMeasureUnit(MeasureUnitI mu) {
        this.displayMeasureUnitContainer.get().setMeasureUnit((MeasureUnit)mu);
    }

    public MeasureUnitI getIngredientMeasureUnit() {
        if (this.ingredientMeasureUnit.isNull()) {
            this.ingredientMeasureUnit.set(MeasureUnitHelper.getMeasureUnit("unit"));
        }
        return this.ingredientMeasureUnit.get();
    }

    public void setIngredientMeasureUnit(MeasureUnitI measure) {
        this.setIngredientMeasureUnit(measure.getName());
    }

    public void setIngredientMeasureUnit(String measureName) {
        this.ingredientMeasureUnit.set(MeasureUnitHelper.getMeasureUnit(measureName));
    }

    public StockGroup getStockGroup() {
        return this.stockGroup.get();
    }

    public void setStockGroup(StockGroup group) {
        this.stockGroup.set(group);
    }

    public boolean hasBarcode(String barcode) {
        return this.getBarcodes().contains(barcode);
    }

    public List<String> getBarcodes() {
        ArrayList<String> retval = new ArrayList<String>(this.getStockBarcodes().size());
        for (StockBarcode stockBarcode : this.getStockBarcodes()) {
            retval.add(stockBarcode.getBarcode());
        }
        return retval;
    }

    public List getStockBarcodes() {
        return this.stockBarcodes;
    }

    public void setBarcodes(List barcodes) {
        this.clearBarcodes();
        for (String barcode : barcodes) {
            this.addBarcode(barcode);
        }
    }

    public void addBarcode(String barcode) {
        if (!this.hasBarcode(barcode)) {
            this.stockBarcodes.add(new StockBarcode(barcode, this));
        }
    }

    public void clearBarcodes() {
        this.stockBarcodes.clear();
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public boolean isTaxIncluded() {
        return this.taxIncluded;
    }

    public void setTaxIncluded(boolean newIncludesTax) {
        this.taxIncluded = newIncludesTax;
    }

    public List<StockArea> getStockableAreas() {
        this.initStockOnHand();
        ArrayList<StockArea> stockableAreas = new ArrayList<StockArea>();
        for (StockOnHand soh : this.getStockOnHand()) {
            if (!soh.isStockAllowed()) continue;
            stockableAreas.add(soh.getStockArea());
        }
        return stockableAreas;
    }

    public void setStockableAreas(List areas) {
        this.initStockOnHand();
        for (StockOnHand soh : this.getStockOnHand()) {
            boolean stockable = areas.contains(soh.getStockArea());
            soh.setStockAllowed(stockable);
        }
    }

    public List<Pair<StockArea, MinMax>> getSuggestedMinMaxList() {
        this.initStockOnHand();
        ArrayList<Pair<StockArea, MinMax>> retval = new ArrayList<Pair<StockArea, MinMax>>();
        for (StockOnHand soh : this.getStockOnHand()) {
            StockArea area = soh.getStockArea();
            MinMax minMax = new MinMax(soh.getSuggestedMin(), soh.getSuggestedMax());
            retval.add(new Pair<StockArea, MinMax>(area, minMax));
        }
        return retval;
    }

    private StockItemParLevel getDefaultStockItemParLevel(StockArea area) {
        return this.getStockItemParLevel(area, StockParLevel.getDefaultStockParLevel());
    }

    private StockItemParLevel getStockItemParLevel(StockArea area, StockParLevel level) {
        for (StockItemParLevel parLevel : this.getStockItemParLevels()) {
            if (!parLevel.getStockArea().equals(area) || !parLevel.getStockParLevel().equals(level)) continue;
            return parLevel;
        }
        OrderMateLog.LOG.warn("StockArea " + area + " was not found within the StockItemParLevel list for item :" + this.getLabel() + " creating a new one.");
        StockItemParLevel stockParLevel = new StockItemParLevel();
        stockParLevel.setStockParLevel(level);
        stockParLevel.setStockArea(area);
        stockParLevel.setStockItem(this);
        this.addStockItemParLevel(stockParLevel);
        return stockParLevel;
    }

    public Quantity getSuggestedMin(StockArea area) {
        return this.getSuggestedMin(area, StockParLevel.getDefaultStockParLevel());
    }

    public Quantity getSuggestedMin(StockArea area, StockParLevel parLevel) {
        StockItemParLevel itemParLevel = this.getStockItemParLevel(area, parLevel);
        if (itemParLevel != null) {
            return itemParLevel.getSuggestedMin(this.getDisplayMeasureUnitContainer());
        }
        if (!StockParLevel.getDefaultStockParLevel().equals(parLevel)) {
            return this.getSuggestedMin(area);
        }
        return new Quantity(this.getDisplayMeasureUnitContainer(), 0.0, true);
    }

    public Quantity getSuggestedMax(StockArea area) {
        return this.getSuggestedMax(area, StockParLevel.getDefaultStockParLevel());
    }

    public Quantity getSuggestedMax(StockArea area, StockParLevel parLevel) {
        StockItemParLevel itemParLevel = this.getStockItemParLevel(area, parLevel);
        if (itemParLevel != null) {
            return itemParLevel.getSuggestedMax(this.getDisplayMeasureUnitContainer());
        }
        if (!StockParLevel.getDefaultStockParLevel().equals(parLevel)) {
            return this.getSuggestedMax(area);
        }
        return new Quantity(this.getDisplayMeasureUnitContainer(), 0.0, true);
    }

    public void setSuggestedMin(StockArea area, Quantity val) {
        this.initStockOnHand();
        StockItemParLevel itemParLevel = this.getDefaultStockItemParLevel(area);
        if (itemParLevel != null) {
            itemParLevel.setSuggestedMin(val);
        }
    }

    public void setSuggestedMax(StockArea area, Quantity val) {
        this.initStockOnHand();
        StockItemParLevel itemParLevel = this.getDefaultStockItemParLevel(area);
        if (itemParLevel != null) {
            itemParLevel.setSuggestedMax(val);
        }
    }

    public Integer getStockIdentifier() {
        return this.stockIdentifier;
    }

    public void setStockIdentifier(Integer newStockIdentifier) {
        this.stockIdentifier = newStockIdentifier;
    }

    private void setSystemState(String state) {
        this.systemState = state;
    }

    private String getSystemState() {
        return this.systemState;
    }

    public List<StockOnHand> getStockOnHand() {
        return this.stockOnHand.getUnmodifiable();
    }

    public Price getStockItemCost(boolean useAvg, StockArea area) {
        Price theCost = !useAvg ? this.getCurrentReplacementCost() : (area != null ? this.getCostOfStockOnHandIncTax(area) : this.getOverallCostOfStockOnHand());
        return theCost;
    }

    public Price getOverallCostOfStockOnHand() {
        if (this.getStockOnHand().size() == 0) {
            return this.temporaryCost;
        }
        double totalQuantity = 0.0;
        double totalCost = 0.0;
        for (StockOnHand soh : this.getStockOnHand()) {
            double sohQty = soh.getQuantity();
            totalQuantity += sohQty;
            totalCost += sohQty * soh.getOnHandCostPerItem().doubleValue() / this.purchaseQty;
        }
        if (totalQuantity == 0.0) {
            totalCost = 0.0;
            for (StockOnHand soh : this.getStockOnHand()) {
                totalCost += soh.getOnHandCostPerItem().doubleValue();
            }
            return new Price(totalCost / (double)this.getStockOnHand().size(), 0.0);
        }
        return new Price(totalCost * this.purchaseQty / totalQuantity, 0.0);
    }

    @Deprecated
    public Price getCurrentCost() {
        return this.getCurrentReplacementCost();
    }

    public Price getCostOfStockOnHandIncTax(StockArea area) {
        return this.getStockOnHandObject(area).getOnHandCostPerItem();
    }

    protected void setCostOfStockOnHand(StockArea area, Price cost) {
        this.getStockOnHandObject(area).setOnHandCostPerItem(cost);
    }

    public Price getCurrentReplacementCost() {
        if (this.isReplacementCostMatchPreProdCost()) {
            return this.getIngredientCostIncTax();
        }
        return new Price(this.currentCost, 0.0);
    }

    public Long getExtId() {
        return this.extId;
    }

    public void setExtId(Long value) {
        this.extId = value;
    }

    @Override
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public boolean isReplacementCostMatchPreProdCost() {
        return this.replacementCostMatchPreProdCost;
    }

    public void setReplacementCostMatchPreProdCost(boolean matchPreProd) {
        Price existingCost = this.getCurrentReplacementCost();
        this.replacementCostMatchPreProdCost = matchPreProd;
        if (!matchPreProd) {
            this.setCurrentCost(existingCost);
        }
    }

    @Override
    public void setStockUsage(StockItem item, Quantity amount) {
        this.setStockUsage(item, amount, false, false);
    }

    @Override
    public void setStockUsage(StockItem item, Quantity amount, boolean isFixedQty, boolean isRemoveable) {
        if (StockLinkable.StockLinkableHelper.updateExistingStockUsage(this, item, amount)) {
            return;
        }
        StockItemIngredientLink stockAddUsage = new StockItemIngredientLink(this, item, amount);
        stockAddUsage.setFixedQuantity(isFixedQty);
        this.stockIngredientLinks.add(stockAddUsage);
    }

    public Quantity getStockUsage(StockItem stockItem) {
        for (StockItemIngredientLink stockItemIngredientLink : this.stockIngredientLinks) {
            if (!stockItemIngredientLink.getStockItem().equals(stockItem)) continue;
            return stockItemIngredientLink.getQuantity();
        }
        return Quantity.ZERO();
    }

    @Override
    public void clearStockUsage() {
        this.stockIngredientLinks.clear();
    }

    @Override
    public Price getIngredientCostIncTax() {
        return StockLinkable.StockLinkableHelper.getOnHandCost(null, this, true);
    }

    @Override
    public Price getIngredientCostExTax() {
        return StockLinkable.StockLinkableHelper.getOnHandCost(null, this, false);
    }

    @Override
    public boolean removeStockLink(StockLink link) {
        return this.stockIngredientLinks.remove(link);
    }

    @Override
    public List<StockItemIngredientLink> getStockLinks() {
        return this.stockIngredientLinks;
    }

    public List<StockItemIngredientLink> getStockIngredientLinks() {
        return this.stockIngredientLinks;
    }

    @Override
    public void collapseStockLinks() {
        this.stockIngredientLinks.collapseUnsafe();
    }

    public Long useStock(PreProdManager preProdManager, StockArea area, Quantity qty, EventContext ctx, SalesComponent comp, String reason, String usageState, Price usageCost) {
        Price cost = usageCost;
        if (StockControlProperty.getInstance().isStockControlEnabled()) {
            if (usageState == null || usageState.equals("NONE")) {
                return null;
            }
            if (qty == null) {
                throw new IllegalArgumentException("Quantity of stock to use must not be null");
            }
            if (area == null) {
                throw new IllegalArgumentException("Area to decrement must not be null");
            }
            try {
                Quantity qtyOnHand;
                if (!this.getStockIngredientLinks().isEmpty() && preProdManager != null && (qtyOnHand = this.getStockOnHand(area)).lessThan(qty)) {
                    preProdManager.saveUsageAndUseStock(preProdManager.produceItem(area, this, qty.subtract(qtyOnHand).getRawValue() * -1.0, ctx));
                }
            }
            catch (RemoteException ex) {
                OrderMate.LOG.error("Could not produce stock item " + this, (Throwable)new Exception(ex));
            }
            if (cost == null) {
                double totalCost = this.getCostOfStockOnHandIncTax(area).doubleValue() * qty.getRawValue() / this.getPurchaseQty().getRawValue();
                cost = new Price(totalCost, 0.0);
            }
            Long stockUsageID = null;
            try {
                User user = ctx != null ? ctx.getUser() : null;
                long userID = user != null ? user.intID() : 0L;
                long compID = comp != null ? comp.intID() : 0L;
                stockUsageID = Data.database.useStock(this.intID(), qty.getRawValue(), userID, compID, reason, usageState, area.intID(), new Date(), true, cost.doubleValue());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
            return stockUsageID;
        }
        return null;
    }

    @Override
    public Price getPrice() {
        return null;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String value) {
        if (value != null && (value = value.trim()).isEmpty()) {
            value = null;
        }
        this.shortName = value;
    }

    protected double getYield() {
        return this.yield;
    }

    protected void setYield(double value) {
        this.yield = value;
    }

    public double getYieldFactor() {
        return StockYieldHelper.getYieldFactor(this);
    }

    public void setYieldFactor(double percentage) {
        StockYieldHelper.setYieldFactor(this, percentage);
    }

    public Quantity getYieldAsQuantity() {
        return StockYieldHelper.getYieldAsQuantity(this);
    }

    public void setYieldAsQuantity(Quantity qty) {
        StockYieldHelper.setYieldAsQuantity(this, qty);
    }

    public double getYieldAsPercentage() {
        return StockYieldHelper.getYieldAsPercentage(this);
    }

    public void setYieldAsPercentage(double percent) {
        StockYieldHelper.setYieldAsPercentage(this, percent);
    }

    public String getContainerName() {
        if ((this.containerName == null || this.containerName.equals("")) && this.getDisplayMeasureUnitContainer() != null && this.getDisplayMeasureUnitContainer().getMeasureContainer() != null) {
            this.containerName = this.getDisplayMeasureUnitContainer().getMeasureContainer().getLabel();
        }
        return this.containerName;
    }

    public PersistentWriteableList<StockItemParLevel> getStockItemParLevels() {
        return this.stockItemParLevels;
    }

    public void setStockItemParLevels(List<StockItemParLevel> stockItemParLevels) {
        this.stockItemParLevels.clear();
        this.stockItemParLevels.addAll(stockItemParLevels);
    }

    public void addStockItemParLevel(StockItemParLevel parLevel) {
        if (!this.stockItemParLevels.contains(parLevel)) {
            this.stockItemParLevels.add(parLevel);
        }
    }

    public void removeStockItemParLevel(StockItemParLevel parLevel) {
        if (this.stockItemParLevels.contains(parLevel)) {
            this.stockItemParLevels.remove(parLevel);
        }
    }

    public boolean isUsedAsIngredient() {
        return !this.getAllStockUsageLinks().isEmpty();
    }

    public List<StockUsageLink> getAllStockUsageLinks() {
        ArrayList<StockUsageLink> allLinks = new ArrayList<StockUsageLink>();
        allLinks.addAll(PersistenceManager.getObjectList(StockItemIngredientLink.class, Query.select(StockItemIngredientLink.class).equals(StockItemIngredientLink.Properties.STOCK_ITEM, this).toString()));
        allLinks.addAll(PersistenceManager.getObjectList(StockInventoryUsageLink.class, Query.select(StockInventoryUsageLink.class).equals(StockInventoryUsageLink.Properties.STOCK_ITEM, this).toString()));
        allLinks.addAll(PersistenceManager.getObjectList(StockUsageModLink.class, Query.select(StockUsageModLink.class).equals(StockUsageModLink.Properties.STOCK_ITEM, this).active(StockUsageModLink.class).toString()));
        return allLinks;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property<Price> CURRENT_COST;
        public PropertiedObject.Property<Price> OLD_COST;
        public PropertiedObject.Property TAX_INCLUDED;
        public PropertiedObject.Property PURCHASE_QTY;
        public PropertiedObject.Property<Date> CREATION_TIME;
        public PropertiedObject.Property<String> SHORT_NAME;
        public PropertiedObject.Property<MeasureContainer> OUTER_CONTAINER;
        public PropertiedObject.Property<Double> OUTER_QUANTITY;
        public PropertiedObject.Property<MeasureUnitContainer> DISPLAY_MEASURE_UNIT_CONTAINER;
        public PropertiedObject.Property<MeasureUnit> INGREDIENT_MEASURE_UNIT;
        public PropertiedObject.Property<StockOnHand> STOCK_ON_HAND;
        public PropertiedObject.Property<StockGroup> STOCK_GROUP;
        public PropertiedObject.Property<StockItemSupplier> STOCK_ITEM_SUPPLIERS;
        public PropertiedObject.Property<StockBarcode> STOCK_BARCODES;
        public PropertiedObject.Property STOCK_IDENTIFIER;
        public PropertiedObject.Property<Long> EXT_ID;
        public PropertiedObject.Property<Long> MASTER_ID;
        public PropertiedObject.Property YIELD;
        public PropertiedObject.Property<Boolean> REPLACEMENT_COST_MATCH_PRE_PROD_COST;
        public PersistentObject.DerivedProperty RAW_OUTER_QUANTITY = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockItem.class), "rawOuterQuantity");
        public PersistentObject.DerivedProperty<String> OUTER_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockItem.class), "outerName");
        public PersistentObject.DerivedProperty YIELD_AS_QUANTITY = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockItem.class), "yieldAsQuantity");
        public PersistentObject.DerivedProperty YIELD_FACTOR = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockItem.class), "yieldFactor");
        public PersistentObject.DerivedProperty YIELD_AS_PERCENTAGE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockItem.class), "yieldAsPercentage");
        public PersistentObject.DerivedProperty CONTAINER_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockItem.class), "containerName");
        public PropertiedObject.Property<StockItemIngredientLink> STOCK_INGREDIENT_LINKS;
        public PersistentObject.DerivedProperty BARCODES = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockItem.class), "barcodes");
        public PropertiedObject.Property<StockItemParLevel> STOCK_ITEM_PAR_LEVELS;
    }
}

