/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockParLevel;

public class StockItemParLevel
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<StockParLevel> stockParLevel;
    private Reference<StockArea> stockArea;
    private Reference<StockItem> stockItem;
    private double suggestedMin;
    private double suggestedMax;

    public StockItemParLevel() {
        this.stockParLevel = this.createReference(StockItemParLevel.Properties.STOCK_PAR_LEVEL);
        this.stockArea = this.createReference(StockItemParLevel.Properties.STOCK_AREA);
        this.stockItem = this.createReference(StockItemParLevel.Properties.STOCK_ITEM);
        this.suggestedMin = 0.0;
        this.suggestedMax = 0.0;
    }

    public StockParLevel getStockParLevel() {
        return this.stockParLevel.get();
    }

    public void setStockParLevel(StockParLevel stockParLevel) {
        this.stockParLevel.set(stockParLevel);
    }

    public StockArea getStockArea() {
        return this.stockArea.get();
    }

    public void setStockArea(StockArea stockArea) {
        this.stockArea.set(stockArea);
    }

    public StockItem getStockItem() {
        return this.stockItem.get();
    }

    public void setStockItem(StockItem stockItem) {
        this.stockItem.set(stockItem);
    }

    public double getSuggestedMin() {
        return this.suggestedMin;
    }

    public void setSuggestedMin(double suggestedMin) {
        this.suggestedMin = suggestedMin;
    }

    public double getSuggestedMax() {
        return this.suggestedMax;
    }

    public void setSuggestedMax(double suggestedMax) {
        this.suggestedMax = suggestedMax;
    }

    public Quantity getSuggestedMin(MeasureUnitContainer measureUnitContainer) {
        return new Quantity(measureUnitContainer, this.suggestedMin, true);
    }

    public Quantity getSuggestedMax(MeasureUnitContainer measureUnitContainer) {
        return new Quantity(measureUnitContainer, this.suggestedMax, true);
    }

    public void setSuggestedMax(Quantity qty) {
        this.suggestedMax = qty.getRawValue();
    }

    public void setSuggestedMin(Quantity qty) {
        this.suggestedMin = qty.getRawValue();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<StockParLevel> STOCK_PAR_LEVEL;
        public PropertiedObject.Property<StockItem> STOCK_ITEM;
        public PropertiedObject.Property<StockArea> STOCK_AREA;
        public PropertiedObject.Property SUGGESTED_MIN;
        public PropertiedObject.Property SUGGESTED_MAX;
    }
}

