/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;

public class StockItemSupplier
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private String productCode;
    private Reference<StockItem> stockItem;
    private Reference<StockSupplier> stockSupplier;

    public StockItemSupplier() {
        this.stockItem = this.createReference(StockItemSupplier.Properties.STOCK_ITEM);
        this.stockSupplier = this.createReference(StockItemSupplier.Properties.STOCK_SUPPLIER);
    }

    public StockItemSupplier(String aProductCode, StockItem aStockItem, StockSupplier aStockSupplier) {
        this.stockItem = this.createReference(StockItemSupplier.Properties.STOCK_ITEM);
        this.stockSupplier = this.createReference(StockItemSupplier.Properties.STOCK_SUPPLIER);
        this.setProductCode(aProductCode);
        this.setStockItem(aStockItem);
        this.setStockSupplier(aStockSupplier);
    }

    public void setProductCode(String newProductCode) {
        this.productCode = newProductCode != null ? newProductCode : "";
    }

    public String getProductCode() {
        return this.productCode == null ? "" : this.productCode;
    }

    public StockItem getStockItem() {
        return this.stockItem.get();
    }

    public void setStockItem(StockItem newStockItem) {
        this.stockItem.set(newStockItem);
    }

    public StockSupplier getStockSupplier() {
        return this.stockSupplier.get();
    }

    public void setStockSupplier(StockSupplier newStockSupplier) {
        this.stockSupplier.set(newStockSupplier);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        if (this.getStockItem() == null) {
            throw new NullPointerException("The stock item is null [" + this.getProductCode() + "-" + this.getStockSupplier() + "]");
        }
        if (this.getStockSupplier() == null) {
            throw new NullPointerException("The supplier is null [" + this.getStockItem() + "-" + this.getProductCode() + "]");
        }
        PersistenceManager.saveChild(this);
    }

    @Override
    public String toString() {
        return this.getStockItem() + " from " + this.getStockSupplier() + "(" + this.getProductCode() + ")[" + this.getID() + "]";
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> PRODUCT_CODE;
        public PropertiedObject.Property<StockItem> STOCK_ITEM;
        public PropertiedObject.Property<StockSupplier> STOCK_SUPPLIER;
    }
}

