/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.Quantity;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockLink;

public interface StockLinkable<T extends StockLink>
extends PersistentObjectI {
    public void setStockUsage(StockItem var1, Quantity var2);

    public void setStockUsage(StockItem var1, Quantity var2, boolean var3, boolean var4);

    public void clearStockUsage();

    public Price getIngredientCostIncTax();

    public Price getIngredientCostExTax();

    public boolean removeStockLink(StockLink var1);

    public List<T> getStockLinks();

    public void collapseStockLinks();

    public static class StockLinkableHelper {
        public static <S extends StockLink> List<Pair<StockItem, Quantity>> getStockUsage(StockLinkable<S> stockLinkable) {
            List<S> stockUsageLinks = stockLinkable.getStockLinks();
            ArrayList<Pair<StockItem, Quantity>> stockUsages = new ArrayList<Pair<StockItem, Quantity>>();
            for (StockLink link : stockUsageLinks) {
                stockUsages.add(new Pair<StockItem, Quantity>(link.getStockItem(), link.getQuantity()));
            }
            Collections.sort(stockUsages, new Comparator<Pair>(){

                @Override
                public int compare(Pair o1, Pair o2) {
                    Pair pair1 = o1;
                    Pair pair2 = o2;
                    StockItem key1 = (StockItem)pair1.key;
                    StockItem key2 = (StockItem)pair2.key;
                    return key1.getLabel().compareTo(key2.getLabel());
                }
            });
            return stockUsages;
        }

        public static <S extends StockLink> double calcReplacementCost(boolean incTax, StockLinkable<S> stockLinkable) {
            if (stockLinkable == null) {
                OrderMate.LOG.warn("calcReplacementCost was given a null stockLinkable - returning a cost of 0.0");
                return 0.0;
            }
            double cost = 0.0;
            for (StockLink stockLink : stockLinkable.getStockLinks()) {
                StockItem stockItem = stockLink.getStockItem();
                Quantity qty = stockLink.getQuantity();
                double rawIngredQty = qty.getRawValue();
                double stockItemCurrentCost = stockItem.getCurrentReplacementCost().doubleValue();
                double stockItemQtyPerUnit = stockItem.getPurchaseQty().getRawValue();
                if (!incTax && stockItem.isTaxIncluded()) {
                    stockItemCurrentCost = FinanceUtils.removeTax(stockItemCurrentCost, SystemProperty.getInstance().getBaseTaxRate());
                }
                cost += rawIngredQty * (stockItemCurrentCost / stockItemQtyPerUnit);
            }
            return cost;
        }

        public static <S extends StockLink> Price getOnHandCost(StockArea area, StockLinkable<S> stockLinkable, boolean incTax) {
            Price totalCost = new Price(0.0, 1.0E-6);
            for (StockLink stockLink : stockLinkable.getStockLinks()) {
                if (stockLink.getStockItem() != null && stockLink.getQuantity() != null) {
                    Price areaCostOnHand = new Price(stockLink.calculateStockItemLinkCost(area, incTax, true), 1.0E-6);
                    totalCost = totalCost.add(areaCostOnHand);
                    continue;
                }
                OrderMate.LOG.warn("One of stock item or stockLinkable is null : " + stockLink);
            }
            return totalCost;
        }

        public static <T extends StockLink> boolean updateExistingStockUsage(StockLinkable<T> stockLinkable, StockItem item, Quantity amount) {
            if (amount == null) {
                HashSet<StockLink> removeSet = new HashSet<StockLink>();
                for (StockLink option : stockLinkable.getStockLinks()) {
                    if (!option.getStockItem().equals(item)) continue;
                    removeSet.add(option);
                }
                for (StockLink link : removeSet) {
                    stockLinkable.removeStockLink(link);
                }
                return true;
            }
            for (StockLink stockLink : stockLinkable.getStockLinks()) {
                if (!stockLink.getStockItem().equals(item)) continue;
                stockLink.setQuantity(amount);
                return true;
            }
            return false;
        }
    }
}

