/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import ordermate.OrderMate;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.Quantity;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class StockOnHand
extends PersistentObject
implements SaveableChild,
ExportableObject {
    public static final Props Properties = new Props();
    private Reference<StockArea> stockArea;
    private Reference<StockItem> stockItem;
    private double quantity;
    private double averageCost;
    private double suggestedMin;
    private double suggestedMax;
    private boolean stockAllowed;
    private Long masterId;

    public StockOnHand() {
        this.stockArea = this.createReference(StockOnHand.Properties.STOCK_AREA);
        this.stockItem = this.createReference(StockOnHand.Properties.STOCK_ITEM);
        this.averageCost = 0.0;
        this.suggestedMin = 0.0;
        this.suggestedMax = 0.0;
        this.stockAllowed = true;
    }

    public StockOnHand(StockItem item, StockArea area) {
        this.stockArea = this.createReference(StockOnHand.Properties.STOCK_AREA);
        this.stockItem = this.createReference(StockOnHand.Properties.STOCK_ITEM);
        this.averageCost = 0.0;
        this.suggestedMin = 0.0;
        this.suggestedMax = 0.0;
        this.stockAllowed = true;
        this.stockItem.set(item);
        this.stockArea.set(area);
    }

    @Override
    public void saveChild() {
        if (this.getQuantity() < 0.0) {
            this.setOnHandCostPerItem(new Price(this.getStockItem().getCurrentReplacementCost(), 0.0));
        }
        PersistenceManager.saveChild(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void deleteChild() {
        OrderMate.LOG.warn("Stock on hand references may not be deleted");
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public StockArea getStockArea() {
        return this.stockArea.get();
    }

    public StockItem getStockItem() {
        return this.stockItem.get();
    }

    public double getSuggestedMin() {
        return this.suggestedMin;
    }

    public double getSuggestedMax() {
        return this.suggestedMax;
    }

    public Quantity getSuggestedMin(MeasureUnitI measureUnit) {
        return new Quantity(measureUnit, this.suggestedMin);
    }

    public Quantity getSuggestedMax(MeasureUnitI measureUnit) {
        return new Quantity(measureUnit, this.suggestedMax);
    }

    public void setSuggestedMax(Quantity qty) {
        this.suggestedMax = qty.getRawValue();
    }

    public void setSuggestedMin(Quantity qty) {
        this.suggestedMin = qty.getRawValue();
    }

    public void setSuggestedMax(double qty) {
        this.suggestedMax = qty;
    }

    public void setSuggestedMin(double qty) {
        this.suggestedMin = qty;
    }

    public boolean isStockAllowed() {
        return this.stockAllowed;
    }

    public void setStockAllowed(boolean b) {
        this.stockAllowed = b;
    }

    public Price getTotalCostValueOfStockOnHand() {
        double stockItemQty = this.getStockItem().getPurchaseQty().getRawValue();
        return new Price(this.quantity * this.averageCost / stockItemQty, 0.0);
    }

    public Price getTotalReplacementCostOfStockOnHand() {
        StockItem item = this.getStockItem();
        double stockItemQty = item.getPurchaseQty().getRawValue();
        double currentCost = item.getCurrentReplacementCost().doubleValue();
        return new Price(this.quantity * currentCost / stockItemQty, 0.0);
    }

    public double getQuantity() {
        return this.quantity;
    }

    public Quantity getTotalQuantity(MeasureUnitContainer measureUnitContainer) {
        return new Quantity(measureUnitContainer, this.quantity, true);
    }

    public Price getOnHandCostPerItem() {
        if (this.quantity < 0.0 && !MathsUtils.approxEquals(this.averageCost, this.getStockItem().getCurrentReplacementCost().doubleValue())) {
            Price cost = this.getStockItem().getCurrentReplacementCost();
            this.setOnHandCostPerItem(cost);
            return new Price(cost, 0.0);
        }
        return new Price(this.averageCost, 0.0);
    }

    public Price getTaxAmount() {
        if (this.getStockItem().isTaxIncluded()) {
            return FinanceUtils.getTaxValue(this.getOnHandCostPerItem(), SystemProperty.getInstance().getBaseTaxRate());
        }
        return new Price(0.0, 0.0);
    }

    public void setOnHandCostPerItem(Price p) {
        this.averageCost = p.doubleValue();
    }

    private double getAverageCost() {
        return this.averageCost;
    }

    public void setTotalQuantity(double rawQty) {
        this.quantity = rawQty;
    }

    public static StockOnHand getSOHForItemAndArea(StockItem item, StockArea area) {
        Object[] params = new Object[]{item.getID(), area.getID()};
        return PersistenceManager.getObject(StockOnHand.class, "SELECT * FROM stock_on_hand WHERE FK_stock_item = ? AND FK_stock_area = ? ", params);
    }

    public static Number getQuantityForItemAndArea(StockItem item, StockArea area) {
        Object[] params = new Object[]{item.getID(), area.getID()};
        Object[][] value = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT Quantity FROM stock_on_hand WHERE FK_stock_item = ? AND FK_stock_area = ? ", params);
        if (value != null && value.length > 0) {
            return value[0][0] != null ? (Number)((Number)value[0][0]) : (Number)null;
        }
        return null;
    }

    public boolean stockAreaEquals(StockArea area) {
        Long ourAreaID = this.stockArea.getObjectID();
        if (ourAreaID == null) {
            return area == null;
        }
        return ourAreaID.equals(area.getID());
    }

    public void setStockArea(StockArea area) {
        this.stockArea.set(area);
    }

    @Override
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<StockItem> STOCK_ITEM;
        public PropertiedObject.Property<StockArea> STOCK_AREA;
        public PropertiedObject.Property QUANTITY;
        public PropertiedObject.Property AVERAGE_COST;
        public PropertiedObject.Property SUGGESTED_MIN;
        public PropertiedObject.Property SUGGESTED_MAX;
        public PropertiedObject.Property STOCK_ALLOWED;
        public PropertiedObject.Property MASTER_ID;
    }
}

