/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import java.util.List;
import ordermate.database.dbconstants.SystemState;

public class StockParLevel
extends PersistentDisplayableObject
implements Saveable {
    public static final Props Properties = new Props();
    private String systemState = "ACTIVE";
    private boolean isDefault = false;
    private static LocalCacheListManager<StockParLevel> allParLevelCache = new LocalCacheListManager<StockParLevel>(Query.createQueryList(StockParLevel.class, Query.select(StockParLevel.class).active(StockParLevel.class)));

    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState systemState) {
        this.systemState = systemState.getSystemState();
    }

    protected void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    public static List<StockParLevel> getAllParLevels() {
        return allParLevelCache.getList();
    }

    private void clearCache() {
        allParLevelCache.clearCache();
    }

    public boolean getIsDefault() {
        return this.isDefault;
    }

    protected void setIsDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        if (this.getIsDefault()) {
            this.validateOtherDefaultSettings();
        }
        this.clearCache();
    }

    @Override
    public void delete() {
        this.setSystemState("DELETED");
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    private void validateOtherDefaultSettings() {
        for (StockParLevel parLevel : PersistenceManager.getObjectList(StockParLevel.class, Query.select(StockParLevel.class).toString())) {
            if (parLevel.equals(this) || !parLevel.getIsDefault()) continue;
            parLevel.setIsDefault(false);
            parLevel.save();
        }
    }

    public static StockParLevel getDefaultStockParLevel() {
        StockParLevel stockParLevel = PersistenceManager.getObject(StockParLevel.class, Query.select(StockParLevel.class).active(StockParLevel.class).equals(StockParLevel.Properties.IS_DEFAULT, 1.0).toString(), null);
        if (stockParLevel == null) {
            stockParLevel = new StockParLevel();
            stockParLevel.setLabel("Default");
            stockParLevel.setIsDefault(true);
            stockParLevel.save();
        }
        return stockParLevel;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property IS_DEFAULT;
    }
}

