/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockItemSupplier;
import stockmate.database.interfaces.stock.StockSupplierI;

public class StockSupplier
extends PersistentDisplayableObject
implements Saveable,
StockSupplierI,
ExportableObject {
    public static final Props Properties = new Props();
    private String systemState = "ACTIVE";
    private String address1 = "";
    private String address2 = "";
    private String phone = "";
    private String fax = "";
    private String email = "";
    private String accountNumber = "";
    private Date updateDate;
    private PersistentWriteableList<StockItemSupplier> stockItemSuppliers;
    private Long masterId;
    private static LocalCacheListManager<StockSupplier> stockSuppliers = new LocalCacheListManager<StockSupplier>(Query.createQueryList(StockSupplier.class, Query.select(StockSupplier.class).active(StockSupplier.class).orderBy(StockSupplier.Properties.LABEL)));

    public StockSupplier() {
        this.stockItemSuppliers = (PersistentWriteableList)this.createList(StockSupplier.Properties.STOCK_ITEM_SUPPLIERS);
    }

    public StockSupplier(StockSupplier toClone) {
        this.stockItemSuppliers = (PersistentWriteableList)this.createList(StockSupplier.Properties.STOCK_ITEM_SUPPLIERS);
        this.setLabel(toClone.getLabel());
        this.systemState = toClone.systemState;
        this.address1 = toClone.address1;
        this.address2 = toClone.address2;
        this.phone = toClone.phone;
        this.fax = toClone.fax;
        this.email = toClone.email;
        this.accountNumber = toClone.accountNumber;
        this.masterId = toClone.masterId;
        this.updateDate = toClone.updateDate;
    }

    @Override
    public void save() {
        this.updateDate = new Date();
        if (PersistenceManager.save(this)) {
            stockSuppliers.clearCache();
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        this.save();
        this.stockItemSuppliers.deleteChild();
    }

    public String getSystemState() {
        return this.systemState;
    }

    public String getName() {
        return this.getLabel();
    }

    public void setName(String newName) {
        this.setLabel(newName);
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String str) {
        this.address1 = str;
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String str) {
        this.address2 = str;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String str) {
        this.fax = str;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String str) {
        this.email = str;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String str) {
        this.phone = str;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String val) {
        this.accountNumber = val;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    void setUpdateDate(Date value) {
        this.updateDate = value;
    }

    public static boolean stockSuppliersExist() {
        return !StockSupplier.getSuppliers().isEmpty();
    }

    public static StockSupplier getDefaultSupplier() {
        StockSupplier retval = null;
        List<StockSupplier> suppliers = StockSupplier.getSuppliers();
        if (suppliers.size() > 0) {
            retval = suppliers.get(0);
        }
        return retval;
    }

    public static List<StockSupplier> getSuppliers() {
        return stockSuppliers.getList();
    }

    public static StockSupplier getSupplierForName(String name) {
        String select = Query.select(StockSupplier.class).equals(StockSupplier.Properties.LABEL, name).active(StockSupplier.class).toString();
        Object[] params = new Object[]{};
        return PersistenceManager.getObject(StockSupplier.class, select, params);
    }

    private List<StockItemSupplier> getStockItemSuppliers() {
        return this.stockItemSuppliers;
    }

    public List<StockItem> getStockItems() {
        ArrayList<StockItem> stockItems = new ArrayList<StockItem>(this.stockItemSuppliers.size());
        for (StockItemSupplier link : this.getStockItemSuppliers()) {
            stockItems.add(link.getStockItem());
        }
        return stockItems;
    }

    @Override
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<String> ADDRESS1;
        public PropertiedObject.Property<String> ADDRESS2;
        public PropertiedObject.Property<String> PHONE;
        public PropertiedObject.Property<String> FAX;
        public PropertiedObject.Property<String> EMAIL;
        public PropertiedObject.Property<String> ACCOUNT_NUMBER;
        public PropertiedObject.Property<StockItemSupplier> STOCK_ITEM_SUPPLIERS;
        public PropertiedObject.Property<Long> MASTER_ID;
        public PropertiedObject.Property<Date> UPDATE_DATE;
    }
}

