/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.DateDMY_HM;
import au.com.ordermate.util.OperationFailedException;
import au.com.ordermate.util.Price;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import ordermate.database.Data;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockTakeEntry;
import stockmate.database.interfaces.stock.StockTakeI;

public class StockTake
extends PersistentObject
implements Saveable,
StockTakeI {
    public static final Props Properties = new Props();
    private boolean live = true;
    private String systemState;
    private Date startDate;
    private Date endDate;
    private PersistentWriteableList<StockTakeEntry> stockTakeEntries;

    public StockTake() {
        this.stockTakeEntries = (PersistentWriteableList)this.createList(StockTake.Properties.STOCK_TAKE_ENTRIES);
    }

    public String getLiveStatus() {
        return this.isLive() ? "Live" : "Saved";
    }

    public String getLabel() {
        if (!this.isLive()) {
            return new DateDMY_HM(this.getDate()).toString();
        }
        return "(LIVE)";
    }

    public boolean isLive() {
        return this.live && "ACTIVE".equals(this.systemState);
    }

    public String getSystemState() {
        return this.systemState;
    }

    private Date getEndDate() {
        return this.endDate;
    }

    public Date getDate() {
        return new DateDMY(this.endDate);
    }

    @Override
    public void delete() {
        this.stockTakeEntries.clear();
        this.systemState = "DELETED";
        PersistenceManager.save(this);
    }

    public Price getVarianceValue(StockArea forArea) {
        Price retval = null;
        try {
            long stockAreaID = forArea != null ? forArea.intID() : 0L;
            retval = Data.database.getStockTakeVarianceValue(this.intID(), stockAreaID, this.isLive());
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
        return retval;
    }

    public List<StockTakeEntry> getStockTakeEntries() {
        return this.stockTakeEntries.getUnmodifiable();
    }

    public void updateStock() {
        this.live = false;
        try {
            Data.database.updateStockTake(this.intID());
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
    }

    public void setUncountedToZero(StockArea area) {
        Double ZERO = 0.0;
        for (StockTakeEntry nextEntry : this.stockTakeEntries) {
            if (!nextEntry.getStockArea().equals(area)) continue;
            if (nextEntry.getOuterQty() == null) {
                nextEntry.setOuterQty(ZERO);
            }
            if (nextEntry.getUnitQty() == null) {
                nextEntry.setUnitQty(ZERO);
            }
            nextEntry.saveChild();
        }
    }

    public boolean hasUncounted() {
        try {
            return Data.database.stockTakeHasUncounted(this.intID());
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return false;
        }
    }

    public static List getStockTakesWithinDateRange(Date from, Date to) {
        List retval = null;
        try {
            retval = Data.database.getStockTakesForDateRange(from, to);
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
        return retval;
    }

    public static Vector<StockTake> getStockTakes() {
        Vector retval;
        try {
            retval = Data.database.getStockTakes();
        }
        catch (RemoteException e) {
            retval = new Vector();
            Data.handleException(e);
        }
        return retval;
    }

    public static Vector getSavedStockTakes() {
        Vector retval;
        try {
            retval = Data.database.getSavedStockTakes();
        }
        catch (RemoteException e) {
            retval = new Vector();
            Data.handleException(e);
        }
        return retval;
    }

    public static StockTake getLiveStockTake() {
        StockTake retval = null;
        try {
            retval = Data.database.getLiveStockTake();
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
        return retval;
    }

    public static boolean hasLiveStockTake() {
        return StockTake.getLiveStockTake() != null;
    }

    public static StockTake getFirstStockTake() {
        try {
            return Data.database.getFirstStockTake();
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return null;
        }
    }

    public static StockTake getLastStockTake() {
        try {
            return Data.database.getLastStockTake();
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return null;
        }
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public Date getStartDate() {
        return new Date(this.startDate.getTime());
    }

    public StockTake getNextStockTake() {
        if (this.isLive()) {
            return null;
        }
        return PersistenceManager.getObject(StockTake.class, Query.select(StockTake.class).greaterThanParam(StockTake.Properties.END_DATE).active(StockTake.class).orderBy(StockTake.Properties.END_DATE).limit(1).toString(), new Object[]{this.getDate()});
    }

    public StockTake getPreviousStockTake() {
        return PersistenceManager.getObject(StockTake.class, Query.select(StockTake.class).lessThanParam(StockTake.Properties.END_DATE).active(StockTake.class).orderByDesc(StockTake.Properties.END_DATE).limit(1).toString(), new Object[]{this.getDate()});
    }

    public static StockTake getStockTake(long stockTakeID) {
        try {
            return Data.database.getStockTake(stockTakeID);
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return null;
        }
    }

    public static StockTake getLastSavedStockTake() {
        StockTake retval = null;
        try {
            retval = Data.database.getLastSavedStockTake();
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
        return retval;
    }

    public static StockTake createStockTake() throws OperationFailedException {
        try {
            return Data.database.createStockTake();
        }
        catch (RemoteException e) {
            throw new OperationFailedException("StockTake creation failed", e);
        }
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.stockTakeEntries.saveChild();
    }

    public StockTakeEntry updateStockTakeEntry(StockTakeEntry entry) {
        StockTakeEntry newEntry = (StockTakeEntry)PersistenceManager.reacquire(entry);
        this.stockTakeEntries.set(this.stockTakeEntries.indexOf(entry), newEntry);
        return newEntry;
    }

    public static StockTake getLastStockTakeForDate(Date start) {
        return StockTake.getLastStockTakeForDate(start, SQLDateType.DATE);
    }

    public static StockTake getLastStockTakeForDate(Date start, SQLDateType dateType) {
        ObjectQuery query = Query.select(StockTake.class).lessThanOrEqual(StockTake.Properties.END_DATE, start, dateType).active(StockTake.class).orderByDesc(StockTake.Properties.END_DATE);
        return PersistenceManager.getObject(StockTake.class, query.toString(), null);
    }

    public static StockTake getFirstStockTakeForDate(Date from) {
        ObjectQuery query = Query.select(StockTake.class).greaterThanOrEqual(StockTake.Properties.END_DATE, from, SQLDateType.DATE).active(StockTake.class).orderBy(StockTake.Properties.END_DATE);
        return PersistenceManager.getObject(StockTake.class, query.toString(), null);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property START_DATE;
        public PropertiedObject.Property END_DATE;
        public PropertiedObject.Property LIVE;
        public PropertiedObject.Property<StockTakeEntry> STOCK_TAKE_ENTRIES;
    }
}

