/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import ordermate.database.config.Quantity;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockTake;
import ordermate.services.stock.StockCostCalculator;
import stockmate.database.interfaces.stock.StockTakeEntryI;

public class StockTakeEntry
extends PersistentDisplayableObject
implements SaveableChild,
StockTakeEntryI {
    public static final Props Properties = new Props();
    public static final String TABLE_NAME = "stock_take_entry";
    private Reference<StockItem> stockItem;
    private Reference<StockArea> stockArea;
    private Reference<StockTake> stockTake;
    private Double outerQty;
    private Double unitQty;
    private Double rawActualQty;
    private double rawExpectedQty;
    private double costPerAtomicUnit;
    private String systemState;

    @Deprecated
    public StockTakeEntry() {
        this.stockItem = this.createReference(StockTakeEntry.Properties.STOCK_ITEM);
        this.stockArea = this.createReference(StockTakeEntry.Properties.STOCK_AREA);
        this.stockTake = this.createReference(StockTakeEntry.Properties.STOCK_TAKE);
        this.costPerAtomicUnit = Double.NaN;
        this.systemState = "ACTIVE";
    }

    public StockItem getStockItem() {
        return this.stockItem.get();
    }

    public StockArea getStockArea() {
        return this.stockArea.get();
    }

    public StockTake getStockTake() {
        return this.stockTake.get();
    }

    public Quantity getExpectedQuantity() {
        if (this.getStockTake().isLive()) {
            this.setRawExpectedQty(this.getStockItem().getStockOnHand(this.getStockArea()).getRawValue());
        }
        return new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), this.getRawExpectedQty(), true);
    }

    public Quantity getActualQuantity() {
        if (this.getRawActualQty() == null) {
            return null;
        }
        return new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), (double)this.getRawActualQty(), true);
    }

    public void setActualQuantityAmount(Quantity qty) {
        if (qty == null) {
            this.setRawActualQty(null);
        } else {
            this.setActualQuantity(qty);
        }
    }

    public void setActualQuantity(Quantity qty) {
        if (qty == null) {
            this.setRawActualQty(null);
        } else if (qty.getMeasureUnit().equals("units")) {
            this.setRawActualQty(qty.getRawValue() * this.getStockItem().getDisplayMeasureUnitContainer().getMultiplier());
        } else {
            if (qty.getRawValue() != 0.0 && !qty.getMeasureUnit().equals(this.getStockItem().getDisplayMeasureUnitContainer().getMeasureUnit())) {
                throw new IllegalArgumentException("Cannot set quantity to differing measure unit amount to that of stock item");
            }
            this.setRawActualQty(new Double(qty.getRawValue()));
        }
    }

    public double getCostPerAtomicUnit() {
        if (this.getStockTake().isLive()) {
            this.costPerAtomicUnit = StockCostCalculator.getCostPerAtomicUnit(this.getStockItem(), this.getStockArea());
        }
        return this.costPerAtomicUnit;
    }

    public Price getTotalExpectedValue() {
        double qty = this.getExpectedQuantity().getRawValue();
        double cost = this.getCostPerAtomicUnit();
        return new Price(qty * cost, 0.0);
    }

    public Price getValuationValue() {
        if (this.getActualQuantity() != null) {
            double qty = this.getActualQuantity().getRawValue();
            double cost = this.getCostPerAtomicUnit();
            return new Price(qty * cost, 0.0);
        }
        return null;
    }

    public Price getValuationValueEx() {
        Price valuation = this.getValuationValue();
        if (valuation == null) {
            return null;
        }
        if (this.getStockItem().isTaxIncluded()) {
            return FinanceUtils.removeTax(valuation, SystemProperty.getInstance().getBaseTaxRate());
        }
        return valuation;
    }

    public Quantity getVariance() {
        Quantity actual = this.getActualQuantity();
        if (actual != null) {
            double actualQuantity = actual.getRawValue();
            double expectedQuantity = this.getExpectedQuantity().getRawValue();
            return new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), actualQuantity - expectedQuantity, true);
        }
        return new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), 0.0, true);
    }

    public Price getVarianceValue() {
        Quantity variance = this.getVariance();
        if (variance == null) {
            return null;
        }
        double qty = variance.getRawValue();
        double cost = this.getCostPerAtomicUnit();
        return new Price(qty * cost, 0.0);
    }

    public Price getVarianceValueEx() {
        Price varianceEx = this.getVarianceValue();
        if (varianceEx == null) {
            return null;
        }
        if (this.getStockItem().isTaxIncluded()) {
            varianceEx = FinanceUtils.removeTax(varianceEx, SystemProperty.getInstance().getBaseTaxRate());
        }
        return varianceEx;
    }

    @Override
    public String toString() {
        return "Stocktake entry for " + this.getStockItem() + " in " + this.getStockArea();
    }

    protected void setStockItem(StockItem item) {
        this.stockItem.set(item);
    }

    @Override
    public void deleteChild() {
        this.setSystemState("DELETED");
        this.saveChild();
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    public void setRawActualQty(Double newRawActualQty) {
        this.rawActualQty = newRawActualQty;
        this.outerQty = null;
        this.unitQty = this.rawActualQty;
    }

    public Double getRawActualQty() {
        return this.rawActualQty;
    }

    protected void setRawExpectedQty(double newRawExpectedQty) {
        this.rawExpectedQty = newRawExpectedQty;
    }

    public double getRawExpectedQty() {
        return this.rawExpectedQty;
    }

    private void setSystemState(String newSystemState) {
        this.systemState = newSystemState;
    }

    private String getSystemState() {
        return this.systemState;
    }

    public void setOuterQty(Double value) {
        this.outerQty = value;
        this.recalculateActualQty();
    }

    public Double getOuterQty() {
        return this.outerQty;
    }

    public void setUnitQty(Double value) {
        this.unitQty = value;
        this.recalculateActualQty();
    }

    public Double getUnitQty() {
        return this.unitQty;
    }

    private void recalculateActualQty() {
        this.rawActualQty = this.unitQty == null ? (this.outerQty == null ? null : this.outerQty) : (this.outerQty == null ? this.unitQty : Double.valueOf(this.outerQty + this.unitQty));
    }

    public boolean isRecorded() {
        return this.getActualQuantity() != null;
    }

    public boolean isNotRecorded() {
        return this.getActualQuantity() == null;
    }

    public boolean hasVariance() {
        if (this.getVariance() == null) {
            return false;
        }
        return !this.getVariance().isZero();
    }

    public StockGroup getStockGroup() {
        return this.getStockItem().getStockGroup();
    }

    public Quantity getUnitQtyAsQty() {
        if (this.getUnitQty() != null) {
            StockItem item = this.getStockItem();
            return new Quantity(item.getDisplayMeasureUnitContainer(), (double)this.getUnitQty(), true);
        }
        return null;
    }

    public Quantity getOuterQtyAsQty() {
        if (this.getOuterQty() != null) {
            StockItem item = this.getStockItem();
            return new Quantity(item.getDisplayMeasureUnitContainer().getMeasureUnit(), item.getOuterQuantity() * item.getDisplayMeasureUnitContainer().getQuantityPerContainer(), item.getOuterContainer(), this.getOuterQty() / (item.getDisplayMeasureUnitContainer().getMultiplier() * item.getOuterQuantity() * item.getPurchaseQty().doubleValue()), false);
        }
        return null;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property RAW_EXPECTED_QTY;
        public PropertiedObject.Property RAW_ACTUAL_QTY;
        public PropertiedObject.Property<Quantity> OUTER_QTY;
        public PropertiedObject.Property<Quantity> UNIT_QTY;
        public PropertiedObject.Property COST_PER_ATOMIC_UNIT;
        public PropertiedObject.Property<StockItem> STOCK_ITEM;
        public PropertiedObject.Property<StockTake> STOCK_TAKE;
        public PropertiedObject.Property<StockArea> STOCK_AREA;
        public PersistentObject.DerivedProperty<Price> TOTAL_ACTUAL_VALUE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockTakeEntry.class), "valuationValue");
        public PersistentObject.DerivedProperty<Price> TOTAL_ACTUAL_VALUE_EX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockTakeEntry.class), "valuationValueEx");
        public PersistentObject.DerivedProperty<Quantity> ACTUAL_QUANTITY = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockTakeEntry.class), "actualQuantity");
        public PersistentObject.DerivedProperty<Quantity> EXPECTED_QUANTITY = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockTakeEntry.class), "expectedQuantity");
        public PersistentObject.DerivedProperty<Quantity> VARIANCE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockTakeEntry.class), "variance");
        public PersistentObject.DerivedProperty<Price> VARIANCE_COST = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockTakeEntry.class), "varianceValue");
        public PersistentObject.DerivedProperty<Price> VARIANCE_COST_EX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockTakeEntry.class), "varianceValueEx");
        public PersistentObject.DerivedProperty<StockGroup> STOCK_GROUP = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockTakeEntry.class), "stockGroup");
        public PersistentObject.DerivedProperty<Quantity> UNIT_QTY_AS_QTY = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockTakeEntry.class), "unitQtyAsQty");
        public PersistentObject.DerivedProperty<Quantity> OUTER_QTY_AS_QTY = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockTakeEntry.class), "outerQtyAsQty");
    }
}

