/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.image.IconLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import ordermate.OrderMate;
import ordermate.database.ConcurrentDatabaseModificationException;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.OrderedQuantity;
import ordermate.database.misc.enums.OversellModeType;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;

public final class StockUtilities {
    private static List<InventoryItem> permittedOversellItems = new ArrayList<InventoryItem>();
    private static StockUtilitiesGui gui;

    public static void clearPermittedOversellItems() {
        permittedOversellItems.clear();
    }

    public static void initGui(StockUtilitiesGui newGui) {
        if (gui != null) {
            OrderMate.LOG.warn("The stock utilities gui has already been setup");
        }
        gui = newGui;
    }

    public static void setupUnitButton(AbstractButton button, InventoryItemUnit unit) {
        StockControlProperty stockProps = StockControlProperty.getInstance();
        boolean lockStockless = stockProps.isLockStocklessItemsEnabled();
        boolean preventOversell = stockProps.getOversellMode().equals(OversellModeType.PREVENT);
        if (!unit.isStockLinked() && lockStockless) {
            button.setEnabled(false);
            button.setIcon(IconLoader.get(gui.getLockIcon()));
        }
        if (unit.shouldNotifyOfStockOverSold(1.0) && preventOversell) {
            button.setEnabled(false);
            button.setIcon(IconLoader.get(gui.getNoStockIcon()));
        }
    }

    public static boolean allowQuantityEdit(Account account, List<SalesLineItem> newlyOrderedItems, SalesLineItem itemWeWantToOrder, SalesQuantity quantityToSetTheItemTo, User user) {
        StockControlProperty stockProps = StockControlProperty.getInstance();
        if (!stockProps.isStockOversellCheckable()) {
            return true;
        }
        boolean allowEdit = true;
        for (SalesItem item : itemWeWantToOrder.getSalesItems()) {
            item.getComponentList();
            for (SalesComponent component : item.getComponentList()) {
                component.getInventoryItem();
                InventoryItem invItem = item.getInventoryItemIfSingle();
                if (invItem == null) continue;
                InventoryItemUnit unit = component.getUnit();
                if (unit != null) {
                    ArrayList<SalesLineItem> unsaved = new ArrayList<SalesLineItem>(account.getItemHelper().getAllItemsUnsaved());
                    unsaved.remove(itemWeWantToOrder);
                    SalesQuantity quantity = new OrderedQuantity(unsaved, true).getQuantity(invItem);
                    ArrayList<SalesLineItem> localNewlyOrdredItems = new ArrayList<SalesLineItem>(newlyOrderedItems);
                    localNewlyOrdredItems.remove(itemWeWantToOrder);
                    quantity = quantity.add(new OrderedQuantity(localNewlyOrdredItems, true).getQuantity(invItem));
                    quantity = quantity.add(quantityToSetTheItemTo);
                    itemWeWantToOrder.getQuantity();
                    boolean canResetCountdown = user.hasPermission(AllPermissions.STOCK_RESET);
                    allowEdit = allowEdit && StockUtilities.checkItemSelectedOverSell(unit, quantity, canResetCountdown);
                    continue;
                }
                throw new IllegalStateException("SalesComponent doesn't have an InventoryItemUnit.");
            }
        }
        return allowEdit;
    }

    public static boolean checkAccountOversell(Account account) {
        StockControlProperty props = StockControlProperty.getInstance();
        OversellModeType oversellMode = props.getOversellMode();
        boolean allowSave = true;
        if (props.isStockOversellCheckable()) {
            OrderedQuantity uncommittedData = account.getUnsavedData();
            Iterator i = uncommittedData.entryIterator();
            ArrayList<InventoryItem> oversoldItems = new ArrayList<InventoryItem>();
            while (i.hasNext()) {
                SalesQuantity stock;
                Map.Entry entry = (Map.Entry)i.next();
                InventoryItem item = (InventoryItem)entry.getKey();
                if (permittedOversellItems.contains(item)) continue;
                InventoryItemUnit unit = item.getUnitIfSingle();
                SalesQuantity uncommittedQty = (SalesQuantity)entry.getValue();
                if (unit == null || (stock = unit.getGenericStockCount()) == null || !uncommittedQty.greaterThan(stock)) continue;
                oversoldItems.add(item);
            }
            if (!oversoldItems.isEmpty()) {
                if (oversellMode.equals(OversellModeType.WARN)) {
                    allowSave = gui.promptAllowOverSell(oversoldItems);
                } else if (oversellMode.equals(OversellModeType.PREVENT)) {
                    gui.warnCannotOverSell(oversoldItems);
                    allowSave = false;
                }
            }
        }
        return allowSave;
    }

    public static boolean checkItemSelectedOverSell(InventoryItemUnit unit, SalesQuantity extraUncommittedQty, boolean canReset) {
        StockControlProperty props = StockControlProperty.getInstance();
        boolean allowSelection = true;
        boolean oversold = unit.shouldNotifyOfStockOverSold(extraUncommittedQty.getValue().doubleValue());
        if (oversold) {
            allowSelection = StockUtilities.doItemOverSellDialog(props, unit, canReset);
        }
        return allowSelection;
    }

    private static boolean doItemOverSellDialog(StockControlProperty props, InventoryItemUnit unit, boolean canReset) {
        StockControlProperty stockProp = props;
        if (stockProp == null) {
            stockProp = StockControlProperty.getInstance();
        }
        OversellModeType oversellMode = stockProp.isStockCountDownEnabled() && unit.isStockCountDownEnabled() ? stockProp.getStockCountdownOversellMode() : stockProp.getOversellMode();
        boolean allowSelection = true;
        if (oversellMode.equals(OversellModeType.WARN)) {
            allowSelection = gui.promptAllowOverSell(unit);
            if (allowSelection) {
                permittedOversellItems.add(unit.getItem());
            }
        } else if (oversellMode.equals(OversellModeType.PREVENT) && (allowSelection = gui.warnCannotOverSell(unit, canReset))) {
            allowSelection = StockUtilities.cancelStockcount(unit);
        }
        return allowSelection;
    }

    private static boolean cancelStockcount(InventoryItemUnit unit) {
        boolean failure = true;
        for (int i = 0; i < 3 && failure; ++i) {
            try {
                unit.cancelStockCount();
                failure = false;
                continue;
            }
            catch (ConcurrentDatabaseModificationException ex) {
                OrderMate.LOG.info("Error cancelling stock count, will retry " + i, (Throwable)ex);
                ++i;
            }
        }
        if (failure) {
            OrderMate.LOG.error("Unable to access the stock count concurrenly for " + unit);
        }
        return !failure;
    }

    private StockUtilities() {
    }

    public static interface StockUtilitiesGui {
        public boolean promptAllowOverSell(List var1);

        public boolean promptAllowOverSell(InventoryItemUnit var1);

        public void warnCannotOverSell(List var1);

        public boolean warnCannotOverSell(InventoryItemUnit var1, boolean var2);

        public String getLockIcon();

        public String getNoStockIcon();
    }
}

