/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class StockYieldHelper {
    public static double getYieldFactor(StockItem theItem) {
        return StockYieldHelper.getYieldFactor(theItem.getYield(), theItem.getDisplayMeasureUnitContainer());
    }

    protected static double getYieldFactor(double yield, MeasureUnitContainer container) {
        return yield / container.getMultiplier();
    }

    public static void setYieldFactor(StockItem theItem, double percentage) {
        theItem.setYield(StockYieldHelper.getYieldFromYieldFactor(percentage, theItem.getDisplayMeasureUnitContainer()));
    }

    protected static double getYieldFromYieldFactor(double yieldFactor, MeasureUnitContainer container) {
        return yieldFactor * container.getMultiplier();
    }

    public static Quantity getYieldAsQuantity(StockItem theItem) {
        return StockYieldHelper.getYieldAsQuantity(theItem.getYield(), theItem.getDisplayMeasureUnitContainer(), theItem.getIngredientMeasureUnit());
    }

    protected static Quantity getYieldAsQuantity(double yield, MeasureUnitContainer container, MeasureUnitI ingredientMeausreUnit) {
        return new Quantity(ingredientMeausreUnit, container.getMultiplier() - yield);
    }

    public static void setYieldAsQuantity(StockItem theItem, Quantity qty) {
        theItem.setYield(StockYieldHelper.getYieldFromQuantity(qty, theItem.getDisplayMeasureUnitContainer()));
    }

    protected static double getYieldFromQuantity(Quantity yieldQty, MeasureUnitContainer container) {
        return container.getMultiplier() - yieldQty.getRawValue();
    }

    public static double getYieldAsPercentage(StockItem theItem) {
        return (1.0 - StockYieldHelper.getYieldFactor(theItem)) * 100.0;
    }

    protected static double getYieldAsPercentage(double yield, MeasureUnitContainer container) {
        return (1.0 - StockYieldHelper.getYieldFactor(yield, container)) * 100.0;
    }

    public static void setYieldAsPercentage(StockItem theItem, double percent) {
        StockYieldHelper.setYieldFactor(theItem, -1.0 * percent / 100.0 + 1.0);
    }

    protected static double getYieldFromPercentage(double percent, MeasureUnitContainer container) {
        return StockYieldHelper.getYieldFromYieldFactor(-1.0 * percent / 100.0 + 1.0, container);
    }

    public static Quantity convertYieldPercentageToQuantity(double percent, MeasureUnitContainer container, MeasureUnitI ingredientMeausreUnit) {
        double tempYield = StockYieldHelper.getYieldFromPercentage(percent, container);
        return StockYieldHelper.getYieldAsQuantity(tempYield, container, ingredientMeausreUnit);
    }

    public static double convertYieldQuantityToPercentage(Quantity yieldQty, MeasureUnitContainer container) {
        double tempYield = StockYieldHelper.getYieldFromQuantity(yieldQty, container);
        return StockYieldHelper.getYieldAsPercentage(tempYield, container);
    }
}

