/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.liquorfile;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.stock.liquorfile.PriceBookCategory;
import ordermate.database.stock.liquorfile.PriceBookDepartment;
import ordermate.database.stock.liquorfile.PriceBookGroup;

public class PriceBookProduct
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String description = "";
    private Integer unitSize = 0;
    private Reference<PriceBookProduct> parentProduct;
    private Integer boughtQty;
    private Integer packQty;
    private Double unitSplitQty;
    private String splitDesc;
    private Integer volume;
    private Reference<PriceBookGroup> pricebookGroup;
    private Reference<PriceBookDepartment> pricebookDepartment;
    private Reference<PriceBookCategory> pricebookCategory;
    private Price costPrice;
    private Integer defaultSupp;

    public PriceBookProduct() {
        this.parentProduct = this.createReference(PriceBookProduct.Properties.PARENT_PRODUCT);
        this.boughtQty = 0;
        this.packQty = 0;
        this.unitSplitQty = 0.0;
        this.splitDesc = "";
        this.volume = 0;
        this.pricebookGroup = this.createReference(PriceBookProduct.Properties.PRICEBOOK_GROUP);
        this.pricebookDepartment = this.createReference(PriceBookProduct.Properties.PRICEBOOK_DEPARTMENT);
        this.pricebookCategory = this.createReference(PriceBookProduct.Properties.PRICEBOOK_CATEGORY);
        this.costPrice = Price.ZERO_DOLLAR;
        this.defaultSupp = 0;
    }

    public PriceBookProduct(long id) {
        this.parentProduct = this.createReference(PriceBookProduct.Properties.PARENT_PRODUCT);
        this.boughtQty = 0;
        this.packQty = 0;
        this.unitSplitQty = 0.0;
        this.splitDesc = "";
        this.volume = 0;
        this.pricebookGroup = this.createReference(PriceBookProduct.Properties.PRICEBOOK_GROUP);
        this.pricebookDepartment = this.createReference(PriceBookProduct.Properties.PRICEBOOK_DEPARTMENT);
        this.pricebookCategory = this.createReference(PriceBookProduct.Properties.PRICEBOOK_CATEGORY);
        this.costPrice = Price.ZERO_DOLLAR;
        this.defaultSupp = 0;
        this.setID(id);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getUnitSize() {
        return this.unitSize;
    }

    public void setUnitSize(Integer unitSize) {
        this.unitSize = unitSize;
    }

    public PriceBookProduct getParentProduct() {
        return this.parentProduct.get();
    }

    public void setParentProduct(PriceBookProduct parentProduct) {
        this.parentProduct.set(parentProduct);
    }

    public Integer getBoughtQty() {
        return this.boughtQty;
    }

    public void setBoughtQty(Integer boughtQty) {
        this.boughtQty = boughtQty;
    }

    public Integer getPackQty() {
        return this.packQty;
    }

    public void setPackQty(Integer packQty) {
        this.packQty = packQty;
    }

    public Double getUnitSplitQty() {
        return this.unitSplitQty;
    }

    public void setUnitSplitQty(Double unitSplitQty) {
        this.unitSplitQty = unitSplitQty;
    }

    public String getSplitDesc() {
        return this.splitDesc;
    }

    public void setSplitDesc(String splitDesc) {
        this.splitDesc = splitDesc;
    }

    public Integer getVolume() {
        return this.volume;
    }

    public void setVolume(Integer volume) {
        this.volume = volume;
    }

    public PriceBookGroup getPricebookGroup() {
        return this.pricebookGroup.get();
    }

    public void setPricebookGroup(PriceBookGroup priceBookGroup) {
        this.pricebookGroup.set(priceBookGroup);
    }

    public PriceBookDepartment getPricebookDepartment() {
        return this.pricebookDepartment.get();
    }

    public void setPricebookDepartment(PriceBookDepartment priceBookDepartment) {
        this.pricebookDepartment.set(priceBookDepartment);
    }

    public PriceBookCategory getPricebookCategory() {
        return this.pricebookCategory.get();
    }

    public void setPricebookCategory(PriceBookCategory priceBookCategory) {
        this.pricebookCategory.set(priceBookCategory);
    }

    public Price getCostPrice() {
        return this.costPrice;
    }

    public void setCostPrice(Price costPrice) {
        this.costPrice = costPrice;
    }

    public Integer getDefaultSupp() {
        return this.defaultSupp;
    }

    public void setDefaultSupp(Integer defaultSupp) {
        this.defaultSupp = defaultSupp;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static List<PriceBookProduct> getChildren(PriceBookProduct product) {
        ObjectQuery oQuery = new ObjectQuery().select(PriceBookProduct.class).equals(PriceBookProduct.Properties.PARENT_PRODUCT, product.getID());
        return PersistenceManager.getObjectList(PriceBookProduct.class, oQuery.toString());
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property DESCRIPTION;
        public PropertiedObject.Property UNIT_SIZE;
        public PropertiedObject.Property<PriceBookProduct> PARENT_PRODUCT;
        public PropertiedObject.Property BOUGHT_QTY;
        public PropertiedObject.Property PACK_QTY;
        public PropertiedObject.Property UNIT_SPLIT_QTY;
        public PropertiedObject.Property SPLIT_DESC;
        public PropertiedObject.Property VOLUME;
        public PropertiedObject.Property<PriceBookGroup> PRICEBOOK_GROUP;
        public PropertiedObject.Property<PriceBookDepartment> PRICEBOOK_DEPARTMENT;
        public PropertiedObject.Property<PriceBookCategory> PRICEBOOK_CATEGORY;
        public PropertiedObject.Property COST_PRICE;
        public PropertiedObject.Property DEFAULT_SUPP;
    }
}

