/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.liquorfile.dataimporter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.stock.liquorfile.PriceBookProduct;
import ordermate.database.stock.liquorfile.dataimporter.LiquorFileImportStrategy;

public abstract class AbstractPriceBookImportHandler<T> {
    Map<PriceBookProduct, T> createdItems = new HashMap<PriceBookProduct, T>();
    List<LiquorFileImportStrategy<T>> strategies = new ArrayList<LiquorFileImportStrategy<T>>();
    boolean checkLocalCreatedList = true;
    boolean checkDatabase = true;

    public void setStrategies(List<LiquorFileImportStrategy<T>> toUse) {
        this.strategies = toUse;
    }

    public List<LiquorFileImportStrategy<T>> getStrategies() {
        return this.strategies;
    }

    public List<T> getCreatedItems() {
        return new ArrayList<T>(this.createdItems.values());
    }

    protected void clearCreatedItems() {
        this.createdItems.clear();
    }

    public T getObject(PriceBookProduct product) throws Exception {
        PriceBookProduct key = product.getParentProduct() == null ? product : product.getParentProduct();
        T toReturn = null;
        if (this.checkLocalCreatedList) {
            toReturn = this.checkCreatedValues(product);
        }
        if (toReturn == null) {
            toReturn = this.createObject(product);
            this.createdItems.put(key, toReturn);
        }
        this.createdItems.put(key, this.addToObject(toReturn, product));
        return toReturn;
    }

    public T searchExistingObject(PriceBookProduct product) {
        return this.performStrategies(product);
    }

    private T checkCreatedValues(PriceBookProduct product) {
        PriceBookProduct parent = product;
        while (parent.getParentProduct() != null) {
            parent = parent.getParentProduct();
        }
        return this.createdItems.get(parent);
    }

    private T performStrategies(PriceBookProduct product) {
        T toReturn = null;
        for (int i = 0; toReturn == null && i < this.strategies.size(); ++i) {
            toReturn = this.getStrategies().get(i).doSearch(product);
        }
        return toReturn;
    }

    protected abstract T createObject(PriceBookProduct var1) throws Exception;

    protected abstract T addToObject(T var1, PriceBookProduct var2) throws Exception;

    public void setCheckLocalCreatedList(boolean b) {
        this.checkLocalCreatedList = b;
    }

    public void setCheckDatabase(boolean b) {
        this.checkDatabase = b;
    }
}

