/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.liquorfile.dataimporter;

import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.queries.inventory.InventoryGroupQueries;
import ordermate.database.stock.liquorfile.PriceBookGroup;
import ordermate.database.stock.liquorfile.PriceBookProduct;
import ordermate.database.stock.liquorfile.dataimporter.AbstractPriceBookImportHandler;
import ordermate.database.stock.liquorfile.dataimporter.LiquorFileImportStrategy;
import ordermate.database.stock.liquorfile.inventoryitemstrategy.InventoryItemBestMatchStrategy;
import ordermate.database.stock.liquorfile.inventoryitemstrategy.InventoryItemLiquorFileIDStrategy;
import ordermate.database.stock.liquorfile.inventoryitemstrategy.InventoryItemLiquorFileParentStrategy;

public class InventoryItemHandler
extends AbstractPriceBookImportHandler<InventoryItem> {
    public InventoryItemHandler() {
        this.setStrategies(new ArrayList<LiquorFileImportStrategy<InventoryItem>>(){
            {
                this.add(new InventoryItemLiquorFileIDStrategy());
                this.add(new InventoryItemLiquorFileParentStrategy());
                this.add(new InventoryItemBestMatchStrategy());
            }
        });
    }

    @Override
    protected InventoryItem createObject(PriceBookProduct product) throws Exception {
        PriceBookProduct parent = product;
        while (parent.getParentProduct() != null) {
            parent = parent.getParentProduct();
        }
        InventoryItem toBuild = new InventoryItem();
        toBuild.setLabel(this.buildName(parent.getDescription()));
        toBuild.setMenuGroup(this.checkForInventoryGroup(parent.getPricebookGroup()));
        toBuild.setPrinterGroup(this.getAnyPrinterGroup());
        return toBuild;
    }

    private PrinterGroup getAnyPrinterGroup() throws Exception {
        List<PrinterGroup> printerGroups = PrinterGroup.getPrinterGroups();
        if (printerGroups.isEmpty()) {
            throw new IllegalStateException("No printer groups to set on the InventoryItem");
        }
        return printerGroups.get(0);
    }

    private String buildName(String uglyName) {
        List<String> nameSplit = StringUtils.splitToList(uglyName.toLowerCase(), " ");
        StringBuilder sb = new StringBuilder();
        for (String word : nameSplit) {
            sb.append(StringUtils.firstCharToUpperCase(word));
            sb.append(" ");
        }
        String name = sb.toString();
        name = name.substring(0, name.length() - 1);
        return name;
    }

    private InventoryGroup checkForInventoryGroup(PriceBookGroup group) throws Exception {
        InventoryGroup toCreate = null;
        if (group != null) {
            toCreate = InventoryGroupQueries.getInventoryGroupForName(group.getName());
        }
        if (toCreate == null) {
            toCreate = InventoryGroupQueries.getAnyInventoryGroup();
        }
        if (toCreate == null) {
            throw new IllegalStateException("No InventoryGroup to build InventoryItems on");
        }
        return toCreate;
    }

    @Override
    protected InventoryItem addToObject(InventoryItem toAddTo, PriceBookProduct product) throws Exception {
        return toAddTo;
    }
}

