/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.liquorfile.dataimporter;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.stock.liquorfile.PriceBookAPN;
import ordermate.database.stock.liquorfile.PriceBookProduct;
import ordermate.database.stock.liquorfile.dataimporter.AbstractPriceBookImportHandler;
import ordermate.database.stock.liquorfile.dataimporter.InventoryItemUnitFKInventoryItemStrategy;
import ordermate.database.stock.liquorfile.dataimporter.LiquorFileImportStrategy;

public class InventoryItemUnitHandler
extends AbstractPriceBookImportHandler<InventoryItemUnit> {
    InventoryItem parentInvItem;
    InventoryItemUnitFKInventoryItemStrategy fkStrategy;

    public InventoryItemUnitHandler() {
        this.setStrategies(new ArrayList<LiquorFileImportStrategy<InventoryItemUnit>>(){
            {
                InventoryItemUnitHandler.this.fkStrategy = new InventoryItemUnitFKInventoryItemStrategy();
                InventoryItemUnitHandler.this.fkStrategy.setInventoryItem(InventoryItemUnitHandler.this.parentInvItem);
                this.add(InventoryItemUnitHandler.this.fkStrategy);
            }
        });
        super.setCheckLocalCreatedList(false);
    }

    @Override
    protected InventoryItemUnit createObject(PriceBookProduct product) throws Exception {
        InventoryItemSize size = this.getInventoryItemSize(product);
        InventoryItemUnit toReturn = new InventoryItemUnit(size);
        toReturn.addUnitPriceLevel(this.getUnitPrice(toReturn));
        this.addBarcodes(toReturn, product.getID());
        this.parentInvItem.addUnit(toReturn);
        return toReturn;
    }

    private UnitPriceLevel getUnitPrice(InventoryItemUnit unit) throws Exception {
        PriceLevel defaultLevel = PriceLevel.getDefaultPriceLevel();
        UnitPriceLevel price = new UnitPriceLevel(unit, defaultLevel);
        price.setPrice(Price.ZERO_DOLLAR);
        return price;
    }

    private InventoryItemSize getInventoryItemSize(PriceBookProduct product) {
        String sizeString = StringUtils.eachWordToUpperCase(product.getSplitDesc().toLowerCase());
        InventoryItemSize size = InventoryItemSize.findSize(sizeString);
        if (size == null) {
            size = new InventoryItemSize();
            size.setLabel(sizeString);
            size.setShortName(sizeString);
            size.save();
        }
        return size;
    }

    public void setParentInventoryItem(InventoryItem toSet) {
        this.parentInvItem = toSet;
        this.fkStrategy.setInventoryItem(this.parentInvItem);
    }

    @Override
    protected InventoryItemUnit addToObject(InventoryItemUnit toAddTo, PriceBookProduct product) throws Exception {
        return toAddTo;
    }

    private void addBarcodes(InventoryItemUnit toAddTo, Long id) {
        List<PriceBookAPN> barcodes = PriceBookAPN.getAllEANforID(id);
        for (PriceBookAPN apn : barcodes) {
            InventoryItemUnit.addUnitBarcode(apn.getEan(), toAddTo);
        }
    }
}

