/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.liquorfile.dataimporter;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.stock.ScanDataLinkSummary;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.liquorfile.PriceBookProduct;
import ordermate.database.stock.liquorfile.dataimporter.InventoryItemHandler;
import ordermate.database.stock.liquorfile.dataimporter.InventoryItemUnitHandler;
import ordermate.database.stock.liquorfile.dataimporter.StockInventoryUsageLinkHandler;
import ordermate.database.stock.liquorfile.dataimporter.StockItemHandler;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;

public class PriceBookDataImporter {
    Map<PriceBookProduct, ScanDataLinkSummary> allSummaries;
    StockItemHandler stockItemHandler = new StockItemHandler();
    InventoryItemHandler invItemHandler = new InventoryItemHandler();
    InventoryItemUnitHandler invItemUnitHandler = new InventoryItemUnitHandler();
    StockInventoryUsageLinkHandler stockInvUsageLinkHandler = new StockInventoryUsageLinkHandler();

    public PriceBookDataImporter() {
        this.allSummaries = new HashMap<PriceBookProduct, ScanDataLinkSummary>();
    }

    public void createSummaries(List<PriceBookProduct> productsToImport) throws Exception {
        for (PriceBookProduct pricebookProd : productsToImport) {
            ScanDataLinkSummary summary = this.createSummary(pricebookProd);
            this.allSummaries.put(this.getParentProduct(pricebookProd), summary);
        }
    }

    public Collection<ScanDataLinkSummary> getAllSummaries() {
        return this.allSummaries.values();
    }

    protected ScanDataLinkSummary createSummary(PriceBookProduct product) throws Exception {
        ScanDataLinkSummary toCreate = null;
        StockItem stockItem = (StockItem)this.stockItemHandler.getObject(product);
        StockItem stockItemFromDB = (StockItem)this.stockItemHandler.searchExistingObject(product);
        InventoryItem invItem = (InventoryItem)this.invItemHandler.getObject(product);
        InventoryItem invItemFromDB = (InventoryItem)this.invItemHandler.searchExistingObject(product);
        this.invItemUnitHandler.setParentInventoryItem(invItem);
        InventoryItemUnit invItemUnit = (InventoryItemUnit)this.invItemUnitHandler.getObject(product);
        this.stockInvUsageLinkHandler.setParentInventoryItemUnit(invItemUnit);
        this.stockInvUsageLinkHandler.setParentStockItem(stockItem);
        StockInventoryUsageLink stockInvUsageLink = (StockInventoryUsageLink)this.stockInvUsageLinkHandler.getObject(product);
        stockInvUsageLink.setLiquorfileId(product.getID().intValue());
        toCreate = new ScanDataLinkSummary(stockItem, invItem, stockItemFromDB, invItemFromDB);
        return toCreate;
    }

    private PriceBookProduct getParentProduct(PriceBookProduct prod) {
        PriceBookProduct parent = prod;
        while (parent.getParentProduct() != null) {
            parent = parent.getParentProduct();
        }
        return parent;
    }

    public void setCheckDatabase(boolean value) {
        this.stockItemHandler.setCheckDatabase(value);
        this.invItemHandler.setCheckDatabase(value);
        this.invItemUnitHandler.setCheckDatabase(value);
        this.stockInvUsageLinkHandler.setCheckDatabase(value);
    }
}

