/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.liquorfile.dataimporter;

import java.util.ArrayList;
import java.util.List;
import ordermate.database.config.Quantity;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.liquorfile.PriceBookProduct;
import ordermate.database.stock.liquorfile.dataimporter.AbstractPriceBookImportHandler;
import ordermate.database.stock.liquorfile.dataimporter.LiquorFileImportStrategy;
import ordermate.database.stock.liquorfile.dataimporter.StockInventoryUsageLinkFKLinksStrategy;
import ordermate.database.stock.liquorfile.dataimporter.StockInventoryUsageLinkLiquorFileIDStrategy;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import org.apache.commons.lang.NullArgumentException;

public class StockInventoryUsageLinkHandler
extends AbstractPriceBookImportHandler<StockInventoryUsageLink> {
    InventoryItemUnit parentInvItemUnit;
    StockItem parentStockItem;
    StockInventoryUsageLinkFKLinksStrategy fkStrategy;

    public StockInventoryUsageLinkHandler() {
        this.setStrategies(new ArrayList<LiquorFileImportStrategy<StockInventoryUsageLink>>(){
            {
                this.add(new StockInventoryUsageLinkLiquorFileIDStrategy());
                StockInventoryUsageLinkHandler.this.fkStrategy = new StockInventoryUsageLinkFKLinksStrategy();
                StockInventoryUsageLinkHandler.this.fkStrategy.setInventoryItemUnit(StockInventoryUsageLinkHandler.this.parentInvItemUnit);
                StockInventoryUsageLinkHandler.this.fkStrategy.setStockItem(StockInventoryUsageLinkHandler.this.parentStockItem);
                this.add(StockInventoryUsageLinkHandler.this.fkStrategy);
            }
        });
        super.setCheckLocalCreatedList(false);
    }

    @Override
    protected StockInventoryUsageLink createObject(PriceBookProduct product) throws Exception {
        StockInventoryUsageLink toReturn = null;
        Quantity createdQuantity = new Quantity(this.parentStockItem.getIngredientMeasureUnit(), product.getPackQty().doubleValue());
        this.parentInvItemUnit.setStockUsage(this.parentStockItem, createdQuantity);
        List<StockInventoryUsageLink> allLinksOnInvItemUnit = this.parentInvItemUnit.getStockInventoryUsageLinks();
        for (StockInventoryUsageLink fetched : allLinksOnInvItemUnit) {
            if (!fetched.getStockItem().equals(this.parentStockItem) || !fetched.getQuantity().equals(createdQuantity)) continue;
            toReturn = fetched;
            toReturn.setLiquorfileId(new Integer(product.getID().intValue()));
        }
        if (toReturn == null) {
            throw new NullArgumentException("No matching StockInventoryUsageLink found in the InventoryItemUnit that setStockUsage() was used on: ");
        }
        return toReturn;
    }

    public void setParentInventoryItemUnit(InventoryItemUnit toSet) {
        this.parentInvItemUnit = toSet;
        this.fkStrategy.setInventoryItemUnit(this.parentInvItemUnit);
    }

    public void setParentStockItem(StockItem toSet) {
        this.parentStockItem = toSet;
        this.fkStrategy.setStockItem(this.parentStockItem);
    }

    protected StockInventoryUsageLinkFKLinksStrategy getFKStrategy() {
        return this.fkStrategy;
    }

    @Override
    protected StockInventoryUsageLink addToObject(StockInventoryUsageLink toAddTo, PriceBookProduct product) throws Exception {
        return toAddTo;
    }
}

