/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.liquorfile.dataimporter;

import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.config.MeasureContainer;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;
import ordermate.database.stock.liquorfile.PriceBookAPN;
import ordermate.database.stock.liquorfile.PriceBookGroup;
import ordermate.database.stock.liquorfile.PriceBookProduct;
import ordermate.database.stock.liquorfile.dataimporter.AbstractPriceBookImportHandler;
import ordermate.database.stock.liquorfile.dataimporter.LiquorFileImportStrategy;
import ordermate.database.stock.liquorfile.stockitemstrategy.StockItemBestMatchStrategy;
import ordermate.database.stock.liquorfile.stockitemstrategy.StockItemLiquorFileIDStrategy;
import ordermate.database.stock.liquorfile.stockitemstrategy.StockItemLiquorFileParentStrategy;

class StockItemHandler
extends AbstractPriceBookImportHandler<StockItem> {
    StockItemHandler() {
        this.setStrategies(new ArrayList<LiquorFileImportStrategy<StockItem>>(){
            {
                this.add(new StockItemLiquorFileIDStrategy());
                this.add(new StockItemLiquorFileParentStrategy());
                this.add(new StockItemBestMatchStrategy());
            }
        });
    }

    @Override
    protected StockItem createObject(PriceBookProduct product) throws Exception {
        PriceBookProduct parent = product;
        while (parent.getParentProduct() != null) {
            parent = parent.getParentProduct();
        }
        Double purchaseQuantity = parent.getUnitSplitQty();
        StockItem toCreate = new StockItem();
        toCreate.setName(this.buildName(parent.getDescription()));
        MeasureUnitContainer measureUnitContainer = this.getMeasureUnitContainer(parent.getUnitSize(), parent.getSplitDesc());
        toCreate.setDisplayMeasureUnitContainer(measureUnitContainer);
        toCreate.setPurchaseQty(measureUnitContainer.getMeasureUnit(), (double)parent.getUnitSize().intValue() * purchaseQuantity);
        toCreate.setCurrentCost(parent.getCostPrice());
        StockGroup stockgroup = this.getStockGroup(parent.getPricebookGroup());
        toCreate.setStockGroup(stockgroup);
        StockSupplier supplier = this.getStockSupplier();
        toCreate.addSupplier(supplier);
        toCreate.setOuterQuantity(1.0);
        toCreate.setOuterName(this.getLowestPriceBookProductNatUnitSplit(parent).getSplitDesc().toLowerCase());
        this.addBarcodes(toCreate, parent.getID());
        return toCreate;
    }

    private StockSupplier getStockSupplier() {
        StockSupplier supplieToCreate = null;
        if (supplieToCreate == null) {
            supplieToCreate = StockSupplier.getDefaultSupplier();
        }
        if (supplieToCreate == null) {
            throw new IllegalStateException("No Stock Supplier to build Stock Items on");
        }
        return supplieToCreate;
    }

    private void addBarcodes(StockItem toCreate, Long id) {
        List<PriceBookAPN> barcodes = PriceBookAPN.getAllEANforID(id);
        for (PriceBookAPN apn : barcodes) {
            toCreate.addBarcode(apn.getEan());
        }
    }

    private PriceBookProduct getLowestPriceBookProductNatUnitSplit(PriceBookProduct parent) {
        List<PriceBookProduct> children = PriceBookProduct.getChildren(parent);
        PriceBookProduct lowestPriceBookProductNatUnitSplit = parent;
        for (PriceBookProduct child : children) {
            if (!(child.getUnitSplitQty() < lowestPriceBookProductNatUnitSplit.getUnitSplitQty())) continue;
            lowestPriceBookProductNatUnitSplit = child;
        }
        return lowestPriceBookProductNatUnitSplit;
    }

    private StockGroup getStockGroup(PriceBookGroup group) {
        StockGroup toCreate = null;
        if (group != null) {
            toCreate = StockGroup.getStockGroupForName(group.getName());
        }
        if (toCreate == null) {
            toCreate = StockGroup.getDefaultStockGroup();
        }
        if (toCreate == null) {
            throw new IllegalStateException("No Stock Group to build Stock Items on");
        }
        return toCreate;
    }

    private MeasureUnitContainer getMeasureUnitContainer(Integer unitSize, String splitDesc) {
        MeasureUnit unit = MeasureUnitHelper.getMeasureUnit("millilitres");
        MeasureContainer container = MeasureUnitHelper.getContainerForName(splitDesc, true);
        MeasureUnitContainer unitContainer = new MeasureUnitContainer(unit, container, unitSize.intValue());
        return unitContainer;
    }

    private String buildName(String uglyName) {
        List<String> nameSplit = StringUtils.splitToList(uglyName.toLowerCase(), " ");
        StringBuilder sb = new StringBuilder();
        for (String word : nameSplit) {
            sb.append(StringUtils.firstCharToUpperCase(word));
            sb.append(" ");
        }
        String name = sb.toString();
        name = name.substring(0, name.length() - 1);
        return name;
    }

    @Override
    protected StockItem addToObject(StockItem toAddTo, PriceBookProduct product) throws Exception {
        this.addBarcodes(toAddTo, product.getID());
        return toAddTo;
    }
}

