/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.liquorfile.inventoryitemstrategy;

import au.com.ordermate.util.StringUtils;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.List;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.queries.inventory.InventoryItemQueries;
import ordermate.database.searchers.inventoryitem.InventoryItemSearcher;
import ordermate.database.stock.liquorfile.PriceBookProduct;
import ordermate.database.stock.liquorfile.dataimporter.LiquorFileImportStrategy;

public class InventoryItemBestMatchStrategy
implements LiquorFileImportStrategy<InventoryItem> {
    @Override
    public InventoryItem doSearch(PriceBookProduct product) {
        EventList resultsOfSearch;
        InventoryItemQueries.clearCache();
        EventList unfilteredList = GlazedLists.eventList(InventoryItemQueries.getInventoryItems());
        InventoryItemSearcher searcher = new InventoryItemSearcher();
        searcher.setPreferredInventoryGroup(null);
        searcher.setSearchList(unfilteredList);
        searcher.setSearchString(product.getDescription());
        int p = 0;
        do {
            List<String> words;
            if (!(words = StringUtils.splitToList(product.getDescription(), " ")).isEmpty()) {
                StringBuilder sb = new StringBuilder().append(words.get(0));
                for (int i = 1; i < words.size() - 1 + p; ++i) {
                    sb.append(" ");
                    sb.append(words.get(i));
                }
                searcher.setSearchString(sb.toString());
            }
            resultsOfSearch = searcher.getResultingList();
            ++p;
        } while (resultsOfSearch.size() > 1);
        return resultsOfSearch.size() > 0 ? (InventoryItem)resultsOfSearch.get(0) : null;
    }
}

