/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.liquorfile.stockitemstrategy;

import au.com.ordermate.util.StringUtils;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.List;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.searchers.stock.StockItemSearcher;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.liquorfile.PriceBookProduct;
import ordermate.database.stock.liquorfile.dataimporter.LiquorFileImportStrategy;

public class StockItemBestMatchStrategy
implements LiquorFileImportStrategy<StockItem> {
    @Override
    public StockItem doSearch(PriceBookProduct product) {
        EventList resultsOfSearch;
        StockItemQueries.clearCache();
        EventList unfilteredList = GlazedLists.eventList(StockItemQueries.getStockItems());
        StockItemSearcher searcher = new StockItemSearcher();
        searcher.setSearchParameters((List<StockItem>)unfilteredList, null);
        int p = 0;
        do {
            List<String> words;
            if (!(words = StringUtils.splitToList(product.getDescription(), " ")).isEmpty()) {
                StringBuilder sb = new StringBuilder().append(words.get(0));
                for (int i = 1; i < words.size() - 1 + p; ++i) {
                    sb.append(" ");
                    sb.append(words.get(i));
                }
                searcher.setSearchString(sb.toString());
            }
            resultsOfSearch = searcher.getResultingItems();
            ++p;
        } while (resultsOfSearch.size() > 1);
        return resultsOfSearch.size() > 0 ? (StockItem)resultsOfSearch.get(0) : null;
    }
}

