/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.requisition;

import ordermate.database.stock.StockItem;

public class StockItemQtyCalculator {
    private StockItem item;
    private double outerQty;
    private double unitQty;
    private double totalQty;

    public StockItemQtyCalculator(StockItem item, double qty) {
        this.item = item;
        this.totalQty = qty;
        this.calculateOuterAndUnit();
    }

    public StockItemQtyCalculator(StockItem item, double outerQty, double unit) {
        this.item = item;
        this.outerQty = outerQty;
        this.unitQty = unit;
        this.calculateTotal();
    }

    private void calculateTotal() {
        this.totalQty = this.outerQty * this.item.getOuterQuantity() * this.item.getPurchaseQty().doubleValue() + this.unitQty;
    }

    public void calculateOuterAndUnit() {
        if (this.item.getOuterContainer() != null) {
            this.unitQty = this.totalQty % (this.item.getOuterQuantity() * this.item.getPurchaseQty().doubleValue());
            this.outerQty = (this.totalQty - this.unitQty) / (this.item.getOuterQuantity() * this.item.getPurchaseQty().doubleValue());
        } else {
            this.unitQty = this.totalQty;
            this.outerQty = 0.0;
        }
    }

    public double getOuterQty() {
        return this.outerQty;
    }

    public double getUnitQty() {
        return this.unitQty;
    }

    public double getTotalQty() {
        return this.totalQty;
    }
}

