/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.requisition;

import java.text.DecimalFormat;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.requisition.StockItemQtyCalculator;

public class StockItemQuantityHelper {
    public double getOuterQty(StockItem item, double totalUnitQty) {
        StockItemQtyCalculator calc = new StockItemQtyCalculator(item, totalUnitQty);
        return calc.getOuterQty();
    }

    public double getUnitQty(StockItem item, double totalUnitQty) {
        StockItemQtyCalculator calc = new StockItemQtyCalculator(item, totalUnitQty);
        return calc.getUnitQty();
    }

    public double getTotalQty(StockItem item, double outerQty, double unitQty) {
        StockItemQtyCalculator calc = new StockItemQtyCalculator(item, outerQty, unitQty);
        return calc.getTotalQty();
    }

    public boolean hasOuterQty(StockItem item, double totalOuterQty) {
        return this.getOuterQty(item, totalOuterQty) > 0.0 && item.getOuterContainer() != null;
    }

    public boolean hasUnitQty(StockItem item, double totalUnitQty) {
        return this.getUnitQty(item, totalUnitQty) > 0.0;
    }

    public String getUnitDisplayString(StockItem item, double totalUnitQty) {
        StockItemQtyCalculator calc = new StockItemQtyCalculator(item, totalUnitQty);
        return new Quantity(item.getDisplayMeasureUnitContainer(), calc.getUnitQty(), false).toString();
    }

    public String getOuterDiplayString(StockItem item, double totalUnitQty) {
        StockItemQtyCalculator calc = new StockItemQtyCalculator(item, totalUnitQty);
        calc.calculateOuterAndUnit();
        return new DecimalFormat("0.###").format(calc.getOuterQty()) + " " + item.getOuterDisplayName();
    }
}

