/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.requisition;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Transient;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.requisition.StockItemQuantityHelper;
import ordermate.database.stock.requisition.StockRequisitionOrder;
import ordermate.database.stock.requisition.StockRequisitionOrderStatus;

public class StockRequisition
extends PersistentDisplayableObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<StockRequisitionOrder> stockRequisitionOrder;
    private Reference<StockItem> stockItem;
    private double rawOriginalQuantity;
    private double rawQuantity;

    public StockRequisition() {
        this.stockRequisitionOrder = this.createReference(StockRequisition.Properties.STOCK_REQUISITION_ORDER);
        this.stockItem = this.createReference(StockRequisition.Properties.STOCK_ITEM);
    }

    public StockRequisition(StockItem item) {
        this(item, new Quantity(item.getDisplayMeasureUnitContainer(), 1.0, true));
    }

    public StockRequisition(StockItem item, Quantity qty) {
        this.stockRequisitionOrder = this.createReference(StockRequisition.Properties.STOCK_REQUISITION_ORDER);
        this.stockItem = this.createReference(StockRequisition.Properties.STOCK_ITEM);
        this.setStockItem(item);
        this.setStockQty(qty);
    }

    public StockRequisitionOrder getStockRequisitionOrder() {
        return this.stockRequisitionOrder.get();
    }

    public void setStockRequisitionOrder(StockRequisitionOrder stockRequisitionOrder) {
        this.stockRequisitionOrder.set(stockRequisitionOrder);
    }

    public StockItem getStockItem() {
        return this.stockItem.get();
    }

    public void setStockItem(StockItem stockItem) {
        this.stockItem.set(stockItem);
    }

    @Transient
    public Quantity getStockQty() {
        if (this.getStockItem() != null) {
            return new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), this.rawQuantity * this.getStockItem().getDisplayMeasureUnitContainer().getMultiplier(), true);
        }
        return new Quantity(0.0);
    }

    @Transient
    public void setStockQty(Quantity stockQty) {
        if (this.stockRequisitionOrder.get() == null || !StockRequisitionOrderStatus.PICKING.equals((Object)this.stockRequisitionOrder.get().getStatus())) {
            this.rawOriginalQuantity = stockQty.doubleValue();
        }
        this.rawQuantity = stockQty.doubleValue();
    }

    public double getRawQuantity() {
        return this.rawQuantity;
    }

    public void setRawQuantity(double quantity) {
        if (this.stockRequisitionOrder.get() == null || !StockRequisitionOrderStatus.PICKING.equals((Object)this.stockRequisitionOrder.get().getStatus())) {
            this.rawOriginalQuantity = quantity;
        }
        this.rawQuantity = quantity;
    }

    @Transient
    public Quantity getOriginalStockQty() {
        if (this.getStockItem() != null) {
            return new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), this.rawOriginalQuantity * this.getStockItem().getDisplayMeasureUnitContainer().getQuantityPerContainer(), true);
        }
        return new Quantity(0.0);
    }

    @Transient
    public void setOriginalStockQty(Quantity stockQty) {
        this.rawOriginalQuantity = stockQty.doubleValue();
    }

    public double getRawOriginalQuantity() {
        return this.rawOriginalQuantity;
    }

    public void setRawOriginalQuantity(double quantity) {
        this.rawOriginalQuantity = quantity;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public String getDisplayableLabel() {
        StringBuilder SB = new StringBuilder();
        StockItemQuantityHelper helper = new StockItemQuantityHelper();
        double totalUnitQty = this.getRawQuantity();
        SB.append("<html>");
        SB.append(this.getStockItem().toString());
        SB.append("\n<p>");
        if (helper.hasOuterQty(this.getStockItem(), totalUnitQty)) {
            SB.append(helper.getOuterDiplayString(this.getStockItem(), totalUnitQty));
        }
        if (helper.hasOuterQty(this.getStockItem(), totalUnitQty) && helper.hasUnitQty(this.getStockItem(), totalUnitQty)) {
            SB.append(" and ");
        }
        if (helper.hasUnitQty(this.getStockItem(), totalUnitQty) || !helper.hasOuterQty(this.getStockItem(), totalUnitQty) && !helper.hasUnitQty(this.getStockItem(), totalUnitQty)) {
            SB.append(helper.getUnitDisplayString(this.getStockItem(), totalUnitQty));
        }
        SB.append("</html>");
        return SB.toString();
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<StockRequisitionOrder> STOCK_REQUISITION_ORDER;
        public PropertiedObject.Property<StockItem> STOCK_ITEM;
        public PropertiedObject.Property RAW_ORIGINAL_QUANTITY;
        public PropertiedObject.Property RAW_QUANTITY;
    }
}

