/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.requisition;

import java.util.ArrayList;
import java.util.List;
import ordermate.database.config.Quantity;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockParLevel;
import ordermate.database.stock.requisition.StockRequisition;
import ordermate.database.stock.requisition.StockRequisitionOrder;
import ordermate.database.stock.usage.StockTransfer;

public class StockRequisitionManager {
    public static void performTransfer(StockRequisitionOrder order) {
        List<StockRequisition> requisitions = order.getRequisitions();
        for (StockRequisition req : requisitions) {
            StockTransfer transfer = new StockTransfer();
            transfer.setUser(order.getUser());
            transfer.setStockItem(req.getStockItem());
            transfer.setStockArea(order.getStockAreaSender());
            transfer.setStockAreaTransferTo(order.getStockAreaReceiver());
            transfer.setQuantityUsed(req.getStockQty());
            transfer.setReason(order.getReason());
            transfer.commit();
        }
    }

    public static void applyParLevelsToOrder(StockParLevel level, StockRequisitionOrder order, boolean isRoundUpToOuter) {
        order.clearRequisitions();
        StockArea toTransferTo = order.getStockAreaReceiver();
        StockArea toTransferFrom = order.getStockAreaSender();
        List itemsInAreaFrom = StockItemQueries.getStockItems(toTransferFrom);
        List<StockItem> itemsInAreaTo = StockItemQueries.getAllStockItems(toTransferTo);
        List<StockItem> sharedItems = StockRequisitionManager.getSharedStockItems(itemsInAreaFrom, itemsInAreaTo);
        List<StockRequisition> newRequisitions = StockRequisitionManager.createRequisitionsForItemsBelowPar(level, toTransferTo, toTransferFrom, sharedItems, isRoundUpToOuter);
        order.addRequisitions(newRequisitions);
    }

    private static List<StockItem> getSharedStockItems(List<StockItem> itemsFrom, List<StockItem> itemsTo) {
        ArrayList<StockItem> sharedItems = new ArrayList<StockItem>();
        for (StockItem item : itemsTo) {
            if (!itemsFrom.contains(item)) continue;
            sharedItems.add(item);
        }
        return sharedItems;
    }

    private static List<StockRequisition> createRequisitionsForItemsBelowPar(StockParLevel level, StockArea areaTo, StockArea areaFrom, List<StockItem> items, boolean isRoundUpToOuter) {
        ArrayList<StockRequisition> toReturn = new ArrayList<StockRequisition>();
        for (StockItem item : items) {
            Quantity toAddToRequisition = StockRequisitionManager.calcQuantityForSOHMax(item, areaTo, level, isRoundUpToOuter);
            if (!toAddToRequisition.greaterThan(Quantity.ZERO())) continue;
            toReturn.add(new StockRequisition(item, toAddToRequisition));
        }
        return toReturn;
    }

    static Quantity calcQuantityForSOHMax(StockItem item, StockArea areaTo, StockParLevel level, boolean isRoundUpToOuter) {
        Quantity sohTo = item.getStockOnHand(areaTo);
        Quantity suggMax = item.getSuggestedMax(areaTo, level);
        Quantity doubleValueOfQty = Quantity.ZERO();
        if (sohTo.lessThan(suggMax)) {
            if (isRoundUpToOuter && item.getOuterContainer() != null) {
                Quantity qtyToRoundUp = suggMax.subtract(sohTo);
                doubleValueOfQty = StockRequisitionManager.roundUpToOuter(item, qtyToRoundUp);
            } else {
                Quantity qtyToRoundUp = suggMax.subtract(sohTo);
                doubleValueOfQty = StockRequisitionManager.roundUpToUnit(item, qtyToRoundUp);
            }
        }
        return doubleValueOfQty;
    }

    static Quantity roundUpToOuter(StockItem item, Quantity qtyToRoundUp) {
        double outerQty = item.getOuterQuantity();
        Quantity tempQty = new Quantity(item.getDisplayMeasureUnitContainer(), qtyToRoundUp.getRawValue(), true);
        double roundedUpOuterCount = Math.ceil(tempQty.doubleValue() / outerQty);
        Quantity roundedUpQty = new Quantity(item.getDisplayMeasureUnitContainer(), roundedUpOuterCount * outerQty, false);
        return roundedUpQty;
    }

    static Quantity roundUpToUnit(StockItem item, Quantity qtyToRoundUp) {
        double unitQty = item.getPurchaseQty().doubleValue();
        Quantity tempQty = new Quantity(item.getDisplayMeasureUnitContainer(), qtyToRoundUp.getRawValue(), true);
        double roundedUpOuterCount = Math.ceil(tempQty.doubleValue() / unitQty);
        Quantity roundedUpQty = new Quantity(item.getDisplayMeasureUnitContainer(), roundedUpOuterCount * unitQty, false);
        return roundedUpQty;
    }

    public static double calculateOuterQty(StockItem item, Quantity purchaseQty) {
        return purchaseQty.doubleValue() / item.getOuterQuantity();
    }
}

