/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.requisition;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import ordermate.database.Lockable;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.requisition.StockRequisition;
import ordermate.database.stock.requisition.StockRequisitionEvent;
import ordermate.database.stock.requisition.StockRequisitionOrderStatus;
import ordermate.database.users.User;

public class StockRequisitionOrder
extends PersistentDisplayableObject
implements Saveable,
Lockable {
    public static final Props Properties = new Props();
    private Reference<StockArea> stockAreaReceiver;
    private Reference<StockArea> stockAreaSender;
    private Date creationDateTime;
    private Date modifiedDateTime;
    private Reference<User> userCreated;
    private Reference<User> userAccepted;
    private Reference<User> user;
    private StockRequisitionOrderStatus status;
    private String reason;
    private PersistentWriteableList<StockRequisition> requisitions;
    private PersistentWriteableList<StockRequisitionEvent> events;
    private String systemState;
    private boolean printed;

    public StockRequisitionOrder() {
        this.stockAreaReceiver = this.createReference(StockRequisitionOrder.Properties.STOCK_AREA_RECEIVER);
        this.stockAreaSender = this.createReference(StockRequisitionOrder.Properties.STOCK_AREA_SENDER);
        this.userCreated = this.createReference(StockRequisitionOrder.Properties.USER_CREATED);
        this.userAccepted = this.createReference(StockRequisitionOrder.Properties.USER_ACCEPTED);
        this.user = this.createReference(StockRequisitionOrder.Properties.USER);
        this.status = StockRequisitionOrderStatus.NEW;
        this.requisitions = (PersistentWriteableList)this.createList(StockRequisitionOrder.Properties.REQUISITIONS);
        this.events = (PersistentWriteableList)this.createList(StockRequisitionOrder.Properties.EVENTS);
        this.systemState = "ACTIVE";
    }

    public StockRequisitionOrder(StockArea reciever, StockArea sender, User user) {
        Date toSet;
        this.stockAreaReceiver = this.createReference(StockRequisitionOrder.Properties.STOCK_AREA_RECEIVER);
        this.stockAreaSender = this.createReference(StockRequisitionOrder.Properties.STOCK_AREA_SENDER);
        this.userCreated = this.createReference(StockRequisitionOrder.Properties.USER_CREATED);
        this.userAccepted = this.createReference(StockRequisitionOrder.Properties.USER_ACCEPTED);
        this.user = this.createReference(StockRequisitionOrder.Properties.USER);
        this.status = StockRequisitionOrderStatus.NEW;
        this.requisitions = (PersistentWriteableList)this.createList(StockRequisitionOrder.Properties.REQUISITIONS);
        this.events = (PersistentWriteableList)this.createList(StockRequisitionOrder.Properties.EVENTS);
        this.systemState = "ACTIVE";
        this.creationDateTime = toSet = new Date();
        this.modifiedDateTime = toSet;
        this.setStockAreaReceiver(reciever);
        this.setStockAreaSender(sender);
        this.setUser(user);
        this.setUserCreated(user);
        this.setStatus(StockRequisitionOrderStatus.NEW);
        this.printed = false;
    }

    @ManyToOne
    @JoinColumn(name="fk_stock_area_receiver")
    public StockArea getStockAreaReceiver() {
        return this.stockAreaReceiver.get();
    }

    public void setStockAreaReceiver(StockArea stockAreaReceiver) {
        this.stockAreaReceiver.set(stockAreaReceiver);
    }

    @ManyToOne
    @JoinColumn(name="fk_stock_area_sender")
    public StockArea getStockAreaSender() {
        return this.stockAreaSender.get();
    }

    public void setStockAreaSender(StockArea stockAreaSender) {
        this.stockAreaSender.set(stockAreaSender);
    }

    @Column(name="date_created")
    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    protected void setCreationDateTime(Date creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    @Column(name="date_modified")
    public Date getModifiedDateTime() {
        return this.modifiedDateTime;
    }

    public void setModifiedDateTime(Date modifiedDateTime) {
        this.modifiedDateTime = modifiedDateTime;
    }

    @Column(name="fk_user_created")
    public User getUserCreated() {
        return this.userCreated.get();
    }

    void setUserCreated(User userCreated) {
        this.userCreated.set(userCreated);
    }

    @Column(name="fk_user_accepted")
    public User getUserAccepted() {
        return this.userAccepted.get();
    }

    public void setUserAccepted(User userAccepted) {
        this.userAccepted.set(userAccepted);
    }

    @Column(name="status")
    public StockRequisitionOrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(StockRequisitionOrderStatus status) {
        this.status = status;
    }

    @Column(name="reason")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    @ManyToOne
    @JoinColumn(name="fk_user")
    public User getUser() {
        return this.user.get();
    }

    public void setUser(User user) {
        this.user.set(user);
    }

    public boolean isPrinted() {
        return this.printed;
    }

    public void setPrinted(boolean value) {
        this.printed = value;
    }

    @OneToMany(mappedBy="stockRequisitionOrder", targetEntity=StockRequisition.class, fetch=FetchType.LAZY)
    public List<StockRequisition> getRequisitions() {
        return this.requisitions.getUnmodifiable();
    }

    void setRequisitions(List<StockRequisition> req) {
        this.requisitions.set(req);
    }

    public void addRequisition(StockRequisition req) {
        if (!this.requisitions.contains(req)) {
            this.requisitions.add(req);
        }
    }

    public void addRequisitions(List<StockRequisition> reqs) {
        for (StockRequisition req : reqs) {
            this.addRequisition(req);
        }
    }

    public void removeRequisition(StockRequisition req) {
        this.requisitions.remove(req);
        req.deleteChild();
    }

    public void clearRequisitions() {
        for (StockRequisition req : this.requisitions) {
            req.deleteChild();
        }
        this.requisitions.clear();
    }

    @OneToMany(mappedBy="stockRequisitionOrder", targetEntity=StockRequisitionEvent.class, fetch=FetchType.LAZY)
    public List<StockRequisitionEvent> getEvents() {
        return this.events.getUnmodifiable();
    }

    void setEvents(List<StockRequisitionEvent> evtList) {
        this.events.set(evtList);
    }

    public void addEvent(StockRequisitionEvent evt) {
        this.events.add(evt);
    }

    public void addEvents(List<StockRequisitionEvent> evtList) {
        this.events.addAll(evtList);
    }

    public void removeEvent(StockRequisitionEvent evt) {
        this.events.remove(evt);
        evt.deleteChild();
    }

    public void clearEvents() {
        for (StockRequisitionEvent evt : this.events) {
            evt.deleteChild();
        }
        this.events.clear();
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.setModifiedDateTime(new Date());
        PersistenceManager.save(this);
        this.requisitions.saveChild();
        this.events.saveChild();
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public boolean lock(User lockUser) {
        if (lockUser == null) {
            this.user.set(null);
            return false;
        }
        if (this.isLocked()) {
            return false;
        }
        this.user.set(lockUser);
        return true;
    }

    @Override
    @Transient
    public boolean isLocked() {
        return this.getUser() != null;
    }

    @Override
    public boolean isLocked(User byUser) {
        if (!this.isLocked()) {
            return false;
        }
        return this.getUser().equals(byUser);
    }

    @Override
    public void unlock() {
        this.lock(null);
    }

    @Override
    public boolean relock(User lock) {
        this.user.set(lock);
        return this.getUser().equals(lock);
    }

    @Override
    public String getLabel() {
        StringBuilder SB = new StringBuilder();
        SB.append(this.getID()).append("\n");
        for (StockRequisition req : this.getRequisitions()) {
            SB.append(req.getStockItem()).append(" - ").append(req.getStockQty()).append("\n");
        }
        return SB.toString();
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<StockArea> STOCK_AREA_RECEIVER;
        public PropertiedObject.Property<StockArea> STOCK_AREA_SENDER;
        public PropertiedObject.Property<Date> CREATION_DATE_TIME;
        public PropertiedObject.Property<Date> MODIFIED_DATE_TIME;
        public PropertiedObject.Property<User> USER_CREATED;
        public PropertiedObject.Property<User> USER_ACCEPTED;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<StockRequisitionOrderStatus> STATUS;
        public PropertiedObject.Property REASON;
        public PropertiedObject.Property<StockRequisition> REQUISITIONS;
        public PropertiedObject.Property<StockRequisitionEvent> EVENTS;
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property PRINTED;
    }
}

