/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.usage;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Price;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.DataService;
import ordermate.database.DataServiceSaveContext;
import ordermate.database.stock.usage.PersistentStockUsage;

public class AbstractWriteableStockUsage
extends PersistentStockUsage
implements SaveableChild {
    public static final Props Properties = new Props();
    private DataServiceSaveContext saveContext;
    private double previousQuantity = 0.0;

    @Override
    public void prepareForSave(SaveContext context) {
        if (!(context instanceof DataServiceSaveContext)) {
            throw new IllegalArgumentException("Save context should be instance of DatabaseServiceContext instead was " + (context != null ? context.getClass().getName() : " null"));
        }
        this.saveContext = (DataServiceSaveContext)context;
    }

    protected DataServiceSaveContext getSaveContext() {
        if (this.saveContext == null) {
            throw new IllegalStateException("Save context has not been initialized");
        }
        return this.saveContext;
    }

    @Override
    public void saveChild() {
        if (this.getCreationDate() == null) {
            this.setCreationDate(new Date());
        }
        PersistenceManager.saveChild(this);
        double quantityAdd = this.getRawQuantity() - this.previousQuantity;
        this.useStock(quantityAdd * -1.0);
        this.saveContext = null;
    }

    private void useStock(double quantity) {
        try {
            Price cost = this.getHistoricalCost().multiply(quantity);
            if (this.getRawQuantity() != 0.0) {
                cost = cost.divide(this.getRawQuantity());
            } else {
                OrderMate.LOG.warn("Save stock usage with raw quantity of zero");
                cost = Price.ZERO_DOLLAR;
            }
            DataService data = this.getSaveContext().getDataService();
            long stockId = this.getStockItem().getID();
            long areaId = this.getStockArea().getID();
            data.adjustStockOnHand(stockId, quantity, cost.doubleValue(), areaId, true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void deleteChild() {
        this.useStock(this.getRawQuantity());
        PersistenceManager.deleteChild(this);
        this.saveContext = null;
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void setRawQuantity(double quantity) {
        if (this.getStockItem() != null) {
            this.previousQuantity = this.getQuantityUsed() != null ? this.getQuantityUsed().getRawValue() : 0.0;
        }
        super.setRawQuantity(quantity);
    }

    @Override
    public double getRawQuantity() {
        if (this.getStockItem() == null) {
            return 0.0;
        }
        return super.getRawQuantity();
    }

    public static class Props
    extends PersistentStockUsage.Props {
    }
}

