/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.usage;

import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.Map;
import ordermate.database.config.Quantity;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.sales.SalesComponent;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usage.StockUsageInterface;
import ordermate.database.users.User;

public class PersistentStockUsage
extends PersistentDisplayableObject
implements StockUsageInterface {
    public static final Props Properties = new Props();
    public static final Map<String, SystemState> systemStateRegister = PersistentEnumeration.buildRegister(SystemState.ACTIVE_STATE, SystemState.DELETED_STATE, SystemState.CLONED_STATE);
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private double rawQuantity;
    private String reason;
    private String usageState;
    private Date usageDate;
    private Date creationDate;
    private Price historicalCost = new Price(0.0, 1.0E-6);
    private Reference<StockItem> stockItem;
    private Reference<SalesComponent> salesComponent;
    private Reference<User> user;
    private Reference<StockArea> stockArea;
    private Reference<StockArea> stockAreaTransferTo;

    public PersistentStockUsage() {
        this.stockItem = this.createReference(PersistentStockUsage.Properties.STOCK_ITEM);
        this.salesComponent = this.createReference(PersistentStockUsage.Properties.SALES_COMPONENT);
        this.user = this.createReference(PersistentStockUsage.Properties.USER);
        this.stockArea = this.createReference(PersistentStockUsage.Properties.STOCK_AREA);
        this.stockAreaTransferTo = this.createReference(PersistentStockUsage.Properties.STOCK_AREA_TRANSFER_TO);
    }

    protected void setHistoricalCost(Price price) {
        this.historicalCost = price;
    }

    public void setSystemState(SystemState state) {
        this.systemState = state;
    }

    public SystemState getSystemState() {
        return this.systemState;
    }

    public SalesComponent getSalesComponent() {
        return this.salesComponent.get();
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public Price getHistoricalCost() {
        return this.historicalCost;
    }

    @Override
    public Quantity getQuantityUsed() {
        if (this.getStockItem() != null) {
            return new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), this.rawQuantity, true);
        }
        return new Quantity(0.0);
    }

    protected double getRawQuantity() {
        return this.rawQuantity;
    }

    public void setRawQuantity(double quantity) {
        this.rawQuantity = quantity;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public StockArea getStockArea() {
        return this.stockArea.get();
    }

    @Override
    public StockArea getStockAreaTransferTo() {
        return this.stockAreaTransferTo.get();
    }

    @Override
    public StockItem getStockItem() {
        return this.stockItem.get();
    }

    @Override
    public Date getUsageDate() {
        return this.usageDate;
    }

    @Override
    public String getUsageState() {
        return this.usageState;
    }

    public void setUsageState(String state) {
        this.usageState = state;
    }

    @Override
    public User getUser() {
        return this.user.get();
    }

    @Override
    public void setReason(String str) {
        this.reason = str;
    }

    @Override
    public void setStockArea(StockArea newArea) {
        this.stockArea.set(newArea);
    }

    @Override
    public void setStockItem(StockItem newItem) {
        this.stockItem.set(newItem);
    }

    @Override
    public void setUsageDate(Date date) {
        this.usageDate = date;
    }

    @Override
    public void setUser(User u) {
        this.user.set(u);
    }

    public static String getUsageStateForSalesItemQuantityState(String itemState) {
        if (itemState.equals("DELETED_WASTED") || itemState.equals("REFUNDED_WASTED")) {
            return "WASTED";
        }
        if (itemState.equals("ACTIVE") || itemState.equals("REFUNDED") || itemState.equals("DELETED")) {
            return "NORMAL";
        }
        if (itemState.equals("MOVED")) {
            return "TRANSFER";
        }
        throw new IllegalArgumentException("Sales Item Quantity state not mapped to stock usage state: " + itemState);
    }

    protected void setCreationDate(Date date) {
        this.creationDate = date;
    }

    @Override
    public String getLabel() {
        String stockItemLabel = "MISSING ITEM";
        if (this.getStockItem() != null) {
            stockItemLabel = this.getStockItem().getLabel();
        }
        return stockItemLabel + " - " + this.getQuantityUsed();
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property RAW_QUANTITY;
        public PropertiedObject.Property<StockItem> STOCK_ITEM;
        public PropertiedObject.Property<SalesComponent> SALES_COMPONENT;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property REASON;
        public PropertiedObject.Property USAGE_STATE;
        public PropertiedObject.Property<StockArea> STOCK_AREA_TRANSFER_TO;
        public PropertiedObject.Property USAGE_DATE;
        public PropertiedObject.Property<StockArea> STOCK_AREA;
        public PropertiedObject.Property CREATION_DATE;
        public PropertiedObject.Property HISTORICAL_COST;
        public PersistentObject.DerivedProperty<Quantity> QUANTITY_USED = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PersistentStockUsage.class), "quantityUsed");
    }
}

