/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.usage;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import ordermate.database.config.Quantity;
import ordermate.database.stock.usage.AbstractWriteableStockUsage;
import ordermate.database.stock.usage.PreProdProduceUsage;
import ordermate.database.stock.usage.StockUsageType;

public class PreProdConsumeUsage
extends AbstractWriteableStockUsage {
    public static final StockUsageType type = StockUsageType.PRE_PROD_CONSUME;
    public static final Props Properties = new Props();
    private final Reference<PreProdProduceUsage> producedUsage;

    public PreProdConsumeUsage() {
        this.producedUsage = this.createReference(PreProdConsumeUsage.Properties.PRODUCED_USAGE);
        this.setUsageState("NORMAL");
    }

    public PreProdProduceUsage getProducedUsage() {
        return this.producedUsage.get();
    }

    protected void setProducedUsage(PreProdProduceUsage parent) {
        this.producedUsage.set(parent);
    }

    @Override
    public Quantity getQuantityUsed() {
        if (this.getStockItem() != null) {
            return new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), this.getRawQuantity() * -1.0, true);
        }
        return new Quantity(0.0);
    }

    @Override
    public String getLabel() {
        String stockItem = "MISSING ITEM";
        if (this.getStockItem() != null) {
            stockItem = this.getStockItem().getLabel();
        }
        return stockItem + " - " + this.getQuantityUsed().multiply(-1.0);
    }

    public static class Props
    extends AbstractWriteableStockUsage.Props {
        public PropertiedObject.Property<PreProdProduceUsage> PRODUCED_USAGE;
    }
}

