/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.usage;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.util.Price;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.Stack;
import ordermate.database.Data;
import ordermate.database.DataServiceSaveContext;
import ordermate.database.EventContext;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockLink;
import ordermate.database.stock.usage.PreProdConsumeUsage;
import ordermate.database.stock.usage.PreProdManager;
import ordermate.database.stock.usage.PreProdProduceUsage;
import ordermate.database.stock.usagelink.StockItemIngredientLink;
import ordermate.services.stock.StockCostCalculator;

public class PreProdManagerImpl
extends UnicastRemoteObject
implements PreProdManager {
    @Override
    public boolean canProduceItem(StockArea area, StockItem item, double unitQty) throws RemoteException {
        boolean hasEnough = true;
        for (StockLink stockLink : item.getStockIngredientLinks()) {
            if (!hasEnough) break;
            StockItem ingredientItem = stockLink.getStockItem();
            Quantity qtyOnHand = ingredientItem.reload().getStockOnHand(area);
            hasEnough &= !qtyOnHand.subtract(stockLink.getQuantity().multiply(unitQty)).lessThan(Quantity.ZERO());
        }
        return hasEnough;
    }

    @Override
    public PreProdProduceUsage produceItem(StockArea area, StockItem itemToProduce, double quantityToProduce, EventContext context) throws RemoteException {
        if (area == null) {
            throw new IllegalArgumentException("Stock area cannot be null");
        }
        if (itemToProduce == null) {
            throw new IllegalArgumentException("Stock Item cannot be null");
        }
        if (this.getCycleChecker().checkCycles(itemToProduce) != null) {
            throw new IllegalStateException("Item to produce would lead to a cycle of the ingredients " + itemToProduce);
        }
        if (itemToProduce.isPersistent()) {
            itemToProduce = (StockItem)PersistenceManager.reacquire(itemToProduce);
        }
        PreProdProduceUsage produceUsage = this.createProduceUsage(area, itemToProduce, quantityToProduce, context);
        for (StockLink stockLink : itemToProduce.getStockIngredientLinks()) {
            produceUsage.addConsumeUsage(this.consumeIngredient(produceUsage, stockLink, quantityToProduce, area, context));
        }
        return produceUsage;
    }

    @Override
    public PersistentObjDescriptor<PreProdProduceUsage> saveUsageAndUseStock(PreProdProduceUsage usage) throws RemoteException {
        PreProdProduceUsage newProducedUsage = this.produceItem(usage.getStockArea(), usage.getStockItem(), usage.getRawQuantity(), new EventContext(null, usage.getUser()));
        boolean producedLinkedIngredients = false;
        for (PreProdConsumeUsage consumeUsage : newProducedUsage.getConsumedUsages()) {
            Quantity used;
            Quantity qtyOnHand = consumeUsage.getStockItem().reload().getStockOnHand(newProducedUsage.getStockArea());
            if (!qtyOnHand.lessThan(used = consumeUsage.getQuantityUsed().multiply(-1.0)) || consumeUsage.getStockItem().getStockIngredientLinks().isEmpty()) continue;
            used = used.getAsMeasure(qtyOnHand.getMeasureUnit());
            this.saveUsageAndUseStock(this.produceItem(newProducedUsage.getStockArea(), consumeUsage.getStockItem(), used.subtract(qtyOnHand).getRawValue() * -1.0, new EventContext(consumeUsage.getUser())));
            producedLinkedIngredients = true;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (producedLinkedIngredients) {
            newProducedUsage = this.produceItem(usage.getStockArea(), usage.getStockItem(), usage.getRawQuantity(), new EventContext(null, usage.getUser()));
        }
        newProducedUsage.prepareForSave(new DataServiceSaveContext(Data.database));
        newProducedUsage.saveChild();
        return newProducedUsage.describe();
    }

    @Override
    public void deleteUsageAndRevertStock(PreProdProduceUsage usage) throws RemoteException {
        usage.prepareForSave(new DataServiceSaveContext(Data.database));
        usage.deleteChild();
    }

    @Override
    public CycleChecker getCycleChecker() throws RemoteException {
        return new CycleChecker();
    }

    protected PreProdConsumeUsage consumeIngredient(PreProdProduceUsage produceUsage, StockLink ingredient, double qtyToProduce, StockArea area, EventContext context) {
        PreProdConsumeUsage consumeUsage = new PreProdConsumeUsage();
        consumeUsage.setStockArea(area);
        consumeUsage.setStockItem(ingredient.getStockItem());
        consumeUsage.setReason("Preproduction consumption");
        double quantityConsumed = ingredient.getQuantity().getRawValue() * qtyToProduce / produceUsage.getStockItem().getPurchaseQty().getRawValue();
        consumeUsage.setRawQuantity(quantityConsumed);
        consumeUsage.setHistoricalCost(new Price(StockCostCalculator.getCostPerAtomicUnit(ingredient.getStockItem(), area) * quantityConsumed, 1.0E-6));
        consumeUsage.setUser(context.getUser());
        return consumeUsage;
    }

    PreProdProduceUsage createProduceUsage(StockArea area, StockItem itemToProduce, double quantityToProduce, EventContext context) {
        PreProdProduceUsage produceUsage = new PreProdProduceUsage();
        produceUsage.setStockArea(area);
        produceUsage.setStockItem(itemToProduce);
        produceUsage.setRawQuantity(quantityToProduce * -1.0);
        produceUsage.setUser(context.getUser());
        produceUsage.setReason("Preproduction");
        return produceUsage;
    }

    public static class CycleChecker
    implements Serializable {
        public Stack checkCycles(StockItem itemToProduce) {
            return this.findCycle(itemToProduce, new Stack<StockItem>(), new Stack<StockItem>());
        }

        public Stack checkCycles(StockItem item, Collection<StockItemIngredientLink> ingredients) {
            return this.findCycle(item, ingredients, new Stack<StockItem>(), new Stack<StockItem>());
        }

        Stack findCycle(StockItem next, Stack<StockItem> result, Stack<StockItem> visitedStack) {
            return this.findCycle(next, next.getStockIngredientLinks(), result, visitedStack);
        }

        Stack findCycle(StockItem next, Collection<StockItemIngredientLink> links, Stack<StockItem> result, Stack<StockItem> visitedStack) {
            if (result.contains(next)) {
                result.push(next);
                return result;
            }
            if (visitedStack.contains(next)) {
                return null;
            }
            result.push(next);
            for (StockLink stockLink : links) {
                Stack cycle = this.findCycle(stockLink.getStockItem(), result, visitedStack);
                if (cycle == null) continue;
                return cycle;
            }
            visitedStack.add(result.pop());
            return null;
        }
    }
}

