/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.usage;

import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.stock.usage.AbstractWriteableStockUsage;
import ordermate.database.stock.usage.PreProdConsumeUsage;
import ordermate.database.stock.usage.StockUsageType;

public class PreProdProduceUsage
extends AbstractWriteableStockUsage {
    public static final StockUsageType type = StockUsageType.PRE_PROD_PRODUCE;
    public static final Props Properties = new Props();
    private PersistentWriteableList<PreProdConsumeUsage> consumedUsages;

    public PreProdProduceUsage() {
        this.consumedUsages = this.createWriteableList(PreProdProduceUsage.Properties.CONSUMED_USAGES);
        this.setUsageState("NORMAL");
    }

    protected void addConsumeUsage(PreProdConsumeUsage usage) {
        this.consumedUsages.add(usage);
        this.setHistoricalCost(this.getHistoricalCost().subtract(usage.getHistoricalCost()));
    }

    public List<PreProdConsumeUsage> getConsumedUsages() {
        return this.consumedUsages.getUnmodifiable();
    }

    protected void setConsumedUsages(List<PreProdConsumeUsage> usage) {
        this.consumedUsages.set(usage);
    }

    @Override
    public void prepareForSave(SaveContext context) {
        super.prepareForSave(context);
        if (!this.getConsumedUsages().isEmpty()) {
            this.consumedUsages.prepareForSave(context);
        }
    }

    @Override
    public void saveChild() {
        if (this.isPersistent()) {
            throw new IllegalStateException("Pre prod production usage is immutable once persisted, can only be deleted not edited");
        }
        Price ingredientCost = Price.ZERO;
        for (PreProdConsumeUsage ingredient : this.consumedUsages) {
            ingredientCost = ingredientCost.add(ingredient.getHistoricalCost());
        }
        this.setHistoricalCost(ingredientCost.negate());
        super.saveChild();
        this.consumedUsages.saveChild();
    }

    @Override
    public void deleteChild() {
        this.consumedUsages.deleteChild();
        super.deleteChild();
    }

    @Override
    public boolean hasChildChanged() {
        return this.consumedUsages.hasChildChanged() || super.hasChildChanged();
    }

    @Override
    public String getLabel() {
        String stockItem = "MISSING ITEM";
        if (this.getStockItem() != null) {
            stockItem = this.getStockItem().getLabel();
        }
        return stockItem + " - " + this.getQuantityUsed().multiply(-1.0);
    }

    public static class Props
    extends AbstractWriteableStockUsage.Props {
        public PropertiedObject.Property<PreProdConsumeUsage> CONSUMED_USAGES;
    }
}

