/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.usage;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.Data;
import ordermate.database.config.Quantity;
import ordermate.database.stock.usage.StockUsage;

public class StockAdjustment
extends StockUsage {
    public StockAdjustment() {
        this.setUsageState("ADJUST");
    }

    public StockAdjustment(long newID) {
        super(newID);
    }

    public Quantity getAdjustQty() {
        Quantity qty = this.getQuantityUsed();
        return new Quantity(qty.getMeasureUnit(), -qty.getRawValue());
    }

    public void setAdjustQty(Quantity qty) {
        Quantity setQty = new Quantity(qty, -qty.getRawValue());
        this.setQuantityUsed(setQty);
    }

    public static List getStockAdjustments(Date from, Date to) {
        List retval = new ArrayList();
        try {
            retval = Data.database.getStockAdjustments(from, to);
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
        return retval;
    }

    @Override
    public String toString() {
        return "Adjustment of " + this.getStockItem();
    }
}

