/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.usage;

import au.com.ordermate.util.Assert;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.rmi.RemoteException;
import java.util.Date;
import ordermate.database.ButtonInfo;
import ordermate.database.Data;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockOnHand;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.usage.StockUsageInterface;
import ordermate.database.users.User;

public abstract class StockUsage
extends ButtonInfo
implements StockUsageInterface {
    public static final int MAX_REASON_CHAR_LIMIT = 100;
    private StockItem stockItem = null;
    private StockArea stockArea = null;
    private StockArea stockAreaTransferredTo = null;
    private User user = null;
    private Date usageDate = new Date();
    private String reason = null;
    private Quantity quantity = new Quantity(0.0);
    private String usageState = "NORMAL";

    public StockUsage() {
        super(0L, "StockUsage");
    }

    public StockUsage(long id) {
        super(id, "StockUsage");
    }

    public boolean isInDatabase() {
        return this.getID() != 0L;
    }

    public void commit() {
        if (!this.isInDatabase()) {
            Assert.isTrue(this.stockItem != null, "StockUsage cannot have a null stock item");
            Assert.isTrue(this.stockArea != null, "StockUsage cannot have a null stock area");
            try {
                long stockItemID = this.stockItem.intID();
                long userID = this.user != null ? this.user.intID() : 0L;
                long stockAreaID = this.stockArea.intID();
                long newID = 0L;
                double totalCost = this.stockItem.getCostOfStockOnHandIncTax(this.getStockArea()).doubleValue() * this.getQuantityUsed().getRawValue() / this.stockItem.getPurchaseQty().getRawValue();
                if (this.usageState.equals("TRANSFER")) {
                    Assert.isTrue(this.stockAreaTransferredTo != null, "Cannot transfer to a null stock area");
                    newID = Data.database.transferStock(stockItemID, this.quantity.getRawValue(), userID, this.reason, stockAreaID, this.stockAreaTransferredTo.intID(), this.usageDate, false, totalCost);
                } else {
                    newID = Data.database.useStock(stockItemID, this.quantity.getRawValue(), userID, 0L, this.reason, this.usageState, stockAreaID, this.usageDate, false, totalCost);
                }
                this.setID(newID);
                Assert.isTrue(this.isInDatabase(), "Saved StockUsage is not in database!");
            }
            catch (RemoteException e) {
                Data.handleException(e);
                this.setID(0L);
            }
        }
    }

    @Override
    public String getUsageState() {
        if (this.isInDatabase()) {
            String retval = null;
            try {
                retval = Data.database.getStockUsageState(this.getID());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
            return retval;
        }
        return this.usageState;
    }

    protected void setUsageState(String usage) {
        if (this.isInDatabase()) {
            try {
                Data.database.setStockUsageState(this.getID(), usage);
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        } else {
            this.usageState = usage;
        }
    }

    @Override
    public StockItem getStockItem() {
        if (this.isInDatabase()) {
            StockItem retval = null;
            try {
                retval = Data.database.getStockUsageItem(this.getID());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
            return retval;
        }
        return this.stockItem;
    }

    public String getStockId() {
        return this.getStockItem().getID().toString();
    }

    @Override
    public void setStockItem(StockItem newItem) {
        if (this.isInDatabase()) {
            try {
                StockItem currentItem = this.getStockItem();
                StockArea area = this.getStockArea();
                long areaID = area.intID();
                double qty = this.getQuantityUsed().getRawValue();
                double oldCost = this.getHistoricalCost().doubleValue();
                Data.database.adjustStockOnHand(currentItem.intID(), qty, oldCost, areaID, false);
                StockOnHand soh = StockOnHand.getSOHForItemAndArea(newItem, area);
                double newCost = soh.getOnHandCostPerItem().doubleValue() * this.getQuantityUsed().getRawValue() / newItem.getPurchaseQty().getRawValue();
                Data.database.adjustStockOnHand(newItem.intID(), -qty, -newCost, areaID, false);
                Data.database.setStockUsageHistoricalCost(this.getID(), newCost);
                if (this.getUsageState().equals("TRANSFER")) {
                    StockArea transferredTo = this.getStockAreaTransferTo();
                    long transferAreaID = transferredTo.intID();
                    Data.database.adjustStockOnHand(currentItem.intID(), -qty, -oldCost, transferAreaID, false);
                    Data.database.adjustStockOnHand(newItem.intID(), qty, newCost, transferAreaID, false);
                }
                long itemID = newItem.intID();
                Data.database.setStockUsageItem(this.getID(), itemID);
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        } else {
            this.stockItem = newItem;
            this.quantity = new Quantity(this.stockItem.getDisplayMeasureUnitContainer(), this.quantity.getRawValue(), true);
        }
    }

    @Override
    public String getReason() {
        if (this.isInDatabase()) {
            String retval = null;
            try {
                retval = Data.database.getStockUsageReason(this.getID());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
            return retval;
        }
        return this.reason;
    }

    @Override
    public void setReason(String str) {
        if (this.isInDatabase()) {
            try {
                Data.database.setStockUsageReason(this.getID(), str);
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        } else {
            this.reason = str;
        }
    }

    @Override
    public void setUser(User u) {
        if (this.isInDatabase()) {
            try {
                long userID = u != null ? u.intID() : 0L;
                Data.database.setStockUsageUser(this.getID(), userID);
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        } else {
            this.user = u;
        }
    }

    @Override
    public User getUser() {
        if (this.isInDatabase()) {
            User retval = null;
            try {
                retval = Data.database.getStockUsageUser(this.getID());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
            return retval;
        }
        return this.user;
    }

    @Override
    public StockArea getStockArea() {
        if (this.isInDatabase()) {
            StockArea retval = null;
            try {
                retval = Data.database.getStockUsageArea(this.getID());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
            return retval;
        }
        return this.stockArea;
    }

    @Override
    public void setStockArea(StockArea newArea) {
        Assert.isTrue(newArea != null, "Cannot set a null stock area");
        if (this.isInDatabase()) {
            StockArea currentArea = this.getStockArea();
            if (!currentArea.equals(newArea)) {
                try {
                    long areaID = newArea != null ? newArea.intID() : 0L;
                    Data.database.setStockUsageArea(this.getID(), areaID);
                    double qty = this.getQuantityUsed().getRawValue();
                    double oldCost = this.getHistoricalCost().doubleValue();
                    double newCost = this.getStockItem().getCostOfStockOnHandIncTax(newArea).doubleValue() * this.getQuantityUsed().getRawValue() / this.getStockItem().getPurchaseQty().getRawValue();
                    Data.database.setStockUsageHistoricalCost(this.getID(), newCost);
                    Data.database.adjustStockOnHand(this.getStockItem().intID(), qty, oldCost, currentArea.intID(), false);
                    Data.database.adjustStockOnHand(this.getStockItem().intID(), -qty, -newCost, areaID, false);
                    if (this.getUsageState().equals("TRANSFER")) {
                        StockArea areaTransferredTo = this.getStockAreaTransferTo();
                        Data.database.adjustStockOnHand(this.getStockItem().intID(), -qty, -oldCost, areaTransferredTo.intID(), false);
                        Data.database.adjustStockOnHand(this.getStockItem().intID(), qty, newCost, areaTransferredTo.intID(), false);
                    }
                }
                catch (RemoteException e) {
                    Data.handleException(e);
                }
            }
        } else {
            this.stockArea = newArea;
        }
    }

    @Override
    public StockArea getStockAreaTransferTo() {
        Assert.isEqual(this.getUsageState(), "TRANSFER", "StockUsage must be a Transfer to get the area transferred to");
        if (this.isInDatabase()) {
            StockArea retval = null;
            try {
                retval = Data.database.getStockUsageAreaTransferredTo(this.getID());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
            return retval;
        }
        return this.stockAreaTransferredTo;
    }

    public void setStockAreaTransferTo(StockArea newArea) {
        Assert.isEqual(this.getUsageState(), "TRANSFER", "StockUsage must be a Transfer to set the area transferred to");
        if (this.isInDatabase()) {
            try {
                StockArea currentArea = this.getStockAreaTransferTo();
                long areaID = newArea != null ? newArea.intID() : 0L;
                Data.database.setStockUsageAreaTransferredTo(this.getID(), areaID);
                double oldCost = this.getHistoricalCost().doubleValue();
                double qty = this.getQuantityUsed().getRawValue();
                Data.database.adjustStockOnHand(this.getStockItem().intID(), -qty, -oldCost, currentArea.intID(), false);
                Data.database.adjustStockOnHand(this.getStockItem().intID(), qty, oldCost, areaID, false);
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        } else {
            this.stockAreaTransferredTo = newArea;
        }
    }

    @Override
    public Date getCreationDate() {
        try {
            return Data.database.getStockUsageCreationDate(this.getID());
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return null;
        }
    }

    @Override
    public Date getUsageDate() {
        Date retval = null;
        if (this.isInDatabase()) {
            try {
                retval = Data.database.getStockUsageDate(this.getID());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        } else {
            retval = this.usageDate;
        }
        return new DateDMY(retval);
    }

    @Override
    public void setUsageDate(Date date) {
        if (this.isInDatabase()) {
            try {
                Data.database.setStockUsageDate(this.getID(), date);
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        } else {
            this.usageDate = date;
        }
    }

    @Override
    public Quantity getQuantityUsed() {
        double retval = 0.0;
        if (this.isInDatabase()) {
            try {
                retval = Data.database.getStockUsageQty(this.getID());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
            return new Quantity(this.getStockItem().getDisplayMeasureUnitContainer(), retval, true);
        }
        return this.quantity;
    }

    @Override
    public Price getHistoricalCost() {
        try {
            double cost = Data.database.getStockUsageHistoricalCost(this.getID());
            return new Price(cost, 0.0);
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return null;
        }
    }

    public void setQuantityUsed(Quantity qty) {
        double rawQty = qty.getRawValue();
        if (this.isInDatabase()) {
            try {
                double diffCost;
                double currentQty = this.getQuantityUsed().getRawValue();
                double diff = rawQty - currentQty;
                long areaID = this.getStockArea().intID();
                long itemID = this.getStockItem().intID();
                double cost = this.getHistoricalCost().doubleValue();
                if (!MathsUtils.approxEquals(currentQty, 0.0)) {
                    diffCost = cost * (diff / currentQty);
                } else {
                    double qtyPerUnit = this.getStockItem().getPurchaseQty().getRawValue();
                    diffCost = this.getStockItem().getCostOfStockOnHandIncTax(this.getStockArea()).doubleValue() * qty.doubleValue() / qtyPerUnit;
                }
                Data.database.adjustStockOnHand(itemID, -diff, -diffCost, areaID, false);
                if (this.getUsageState().equals("TRANSFER")) {
                    Data.database.adjustStockOnHand(itemID, diff, diffCost, this.getStockAreaTransferTo().intID(), false);
                }
                Data.database.setStockUsageQty(this.getID(), rawQty);
                Data.database.setStockUsageHistoricalCost(this.getID(), cost + diffCost);
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        } else {
            this.quantity = qty;
        }
    }

    public void cancelUsage() {
        try {
            Data.database.cancelStockUsage(this.getID(), false);
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
    }

    public boolean isFrozen() {
        long creationDate = this.getCreationDate().getTime();
        StockTake lastSavedStockTake = StockTake.getLastSavedStockTake();
        if (lastSavedStockTake == null) {
            return false;
        }
        return creationDate < lastSavedStockTake.getDate().getTime();
    }
}

