/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.usage;

import java.util.List;
import ordermate.OrderMate;
import ordermate.database.sales.AccountSaveContext;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemHelper;
import ordermate.database.stock.StockControlProperty;
import ordermate.futureorder.FutureOrderManager;

public class StockUsageWatchdog {
    private static final StockUsageWatchdog instance = new StockUsageWatchdog();

    public static StockUsageWatchdog getInstance() {
        return instance;
    }

    public void checkSaveStockUsages(SalesLineItem salesLineItem) {
        if (salesLineItem == null) {
            OrderMate.LOG.warn("Why are we trying to consume stock from a null salesLineItem?");
            return;
        }
        SalesLineItemHelper sliHelper = new SalesLineItemHelper(salesLineItem);
        AccountSaveContext context = sliHelper.getSaveContext();
        boolean hasTimeDue = salesLineItem.getAccount().hasTimeDue();
        StockControlProperty props = StockControlProperty.getInstance();
        if (!hasTimeDue && salesLineItem.isPersistent() && !salesLineItem.getLocalQuantities().isEmpty()) {
            this.consumeStockForQuantities(salesLineItem, props, context, salesLineItem.getLocalQuantities());
        } else if (hasTimeDue && !FutureOrderManager.getInstance().checkInterceptPrintConditions(salesLineItem.getAccount())) {
            boolean noUsagesExist;
            boolean bl = noUsagesExist = !this.checkIfUsagesExist(salesLineItem);
            if (noUsagesExist && props.isStockControlEnabled()) {
                this.consumeStockForQuantities(salesLineItem, props, context, salesLineItem.getSalesItemQuantities());
            } else if (!salesLineItem.getLocalQuantities().isEmpty()) {
                this.consumeStockForQuantities(salesLineItem, props, context, salesLineItem.getLocalQuantities());
            }
        }
    }

    void consumeStockForQuantities(SalesLineItem parentItem, StockControlProperty props, AccountSaveContext context, List<SalesItemQuantity> qtysToConsume) {
        if (context == null) {
            OrderMate.LOG.warn("We're trying to consume stock without context for: " + parentItem);
            return;
        }
        for (SalesItemQuantity savedQty : qtysToConsume) {
            parentItem.consumeStockIfLegal(savedQty, context.getUser(), context.reason, context.usage, props, parentItem.getOriginalTerminal());
        }
    }

    boolean checkIfUsagesExist(SalesLineItem salesLineItem) {
        if (salesLineItem instanceof SalesCombo) {
            boolean toReturn = false;
            for (SalesItem item : ((SalesCombo)salesLineItem).getSalesItems()) {
                toReturn |= this.checkIfUsagesExist(item);
            }
            return toReturn;
        }
        boolean toReturn = false;
        for (SalesComponent comp : ((SalesItem)salesLineItem).getComponentList()) {
            comp.refreshStockUsages();
            toReturn |= !comp.getStockUsage().isEmpty();
        }
        return toReturn;
    }
}

