/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.usage;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.config.Quantity;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usage.StockUsage;
import ordermate.database.stock.usage.StockWastage;
import ordermate.docketprocessor.DocketProcessor;

public class StockWastageHelper {
    public static StockWastage createStockWastage(StockItem newItem, double quantity, EventContext eContext) {
        StockWastage newlink = new StockWastage();
        newlink.setStockItem(newItem);
        newlink.setUser(eContext.getUser());
        newlink.setQuantityUsed(new Quantity(newItem.getDisplayMeasureUnitContainer(), quantity, false));
        StockArea area = eContext.getTerminal().getStockArea();
        if (area == null && StockArea.getStockAreas().size() > 0) {
            area = StockArea.getStockAreas().get(0);
        }
        newlink.setStockArea(area);
        return newlink;
    }

    public static void wasteStockWastagesAndPrint(List<StockWastage> wastages, EventContext eContext, String reason) {
        StockWastageHelper.wasteStockWastages(wastages, eContext, reason);
        if (SystemProperty.getInstance().isPrintWastageDockets()) {
            StockWastageHelper.PrintWastageDocket(wastages, eContext);
        }
    }

    protected static void wasteStockWastages(List<StockWastage> wastages, EventContext eContext, String reason) {
        for (StockWastage waste : wastages) {
            waste.setReason(reason);
            waste.setUsageDate(Calendar.getInstance().getTime());
            waste.commit();
            OrderMate.LOG.info("Wasting " + waste);
            TerminalEventLog.logWastageItem(eContext, waste.getStockItem().getLabel() + " (" + waste.getQuantityUsed().toString() + ")", reason);
        }
    }

    protected static boolean PrintWastageDocket(List<StockWastage> wastages, EventContext eContext) {
        if (wastages == null || wastages.isEmpty()) {
            return false;
        }
        String docketText = StockWastageHelper.getDocketText(wastages, eContext);
        try {
            if (!docketText.isEmpty()) {
                DocketProcessor.printSimpleDocket(docketText);
            }
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn("Problem printing wastages.", (Throwable)ex);
        }
        return !docketText.isEmpty();
    }

    protected static String getDocketText(List<StockWastage> wastages, EventContext eContext) {
        StringBuilder sb = new StringBuilder();
        BusinessInfo businessInfo = BusinessInfo.getInstance();
        sb.append("***Wastage Docket***\n");
        sb.append("Location: " + businessInfo.getLocation() + "\n");
        sb.append("Terminal: " + eContext.getTerminal() + "\n");
        sb.append("User: " + eContext.getUser() + "\n");
        Date usageDate = wastages.get(0).getUsageDate();
        sb.append("Time: " + DateTimeUtils.getDateTimeFormat().format(usageDate) + "\n");
        sb.append("--- \n");
        Price totalWaste = new Price(0.0, 0.01);
        for (StockWastage wastage : wastages) {
            sb.append(wastage.getQuantityUsed() + " " + wastage.getStockItem() + "\n");
        }
        sb.append("Reason : " + wastages.get(0).getReason());
        return sb.toString();
    }

    public static void wasteAccountComponenetsAndPrint(Account account, EventContext eContext, String reason) {
        List<StockWastage> wastages = StockWastageHelper.wasteAccountComponenets(account, eContext, reason);
        if (SystemProperty.getInstance().isPrintWastageDockets()) {
            StockWastageHelper.PrintWastageDocket(wastages, eContext);
        }
    }

    protected static List<StockWastage> wasteAccountComponenets(Account account, EventContext eContext, String reason) {
        ArrayList<StockWastage> wastages = new ArrayList<StockWastage>();
        for (SalesLineItem items : account.getItems()) {
            if (items instanceof SalesCombo) {
                SalesCombo combo = (SalesCombo)items;
                for (SalesItem salesItem : combo.getSalesItems()) {
                    List<SalesComponent> components = salesItem.getComponentList();
                    wastages.addAll(StockWastageHelper.wasteComponents(components, salesItem.getQuantity(), eContext, reason));
                }
                continue;
            }
            if (!(items instanceof SalesItem)) continue;
            SalesItem salesItem = (SalesItem)items;
            List<SalesComponent> components = salesItem.getComponentList();
            wastages.addAll(StockWastageHelper.wasteComponents(components, items.getQuantity(), eContext, reason));
        }
        TerminalEventLog.logWastageAccount(eContext, account.getLabel(), reason, account);
        return wastages;
    }

    private static List<StockWastage> wasteComponents(List<SalesComponent> components, SalesQuantity qty, EventContext eContext, String reason) {
        ArrayList<StockWastage> wastages = new ArrayList<StockWastage>();
        for (SalesComponent comp : components) {
            List<StockUsage> recentUsages = comp.useLinkedStock(qty, eContext.getUser(), reason, "WASTED", comp.getInventoryItem().getDecrementStockArea(eContext.getTerminal()));
            if (recentUsages != null) {
                for (StockUsage usage : recentUsages) {
                    if (!(usage instanceof StockWastage)) continue;
                    wastages.add((StockWastage)usage);
                }
            }
            OrderMate.LOG.info("Wasting " + comp);
        }
        return wastages;
    }
}

