/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.usagelink;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Price;
import java.awt.Color;
import ordermate.database.config.Quantity;
import ordermate.database.inventory.InventoryIngredients;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryRemovable;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesRemoveStocked;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockUsageLink;

public class StockInventoryUsageLink
extends StockUsageLink
implements SaveableChild,
Displayable,
InventoryRemovable<SalesRemoveStocked> {
    public static final Props Properties = new Props();
    private Integer liquorfileId;
    private Reference<InventoryItemUnit> inventoryItemUnit;
    private Color foregroundColor;
    private Color backgroundColor;
    private boolean removable;
    private Price removePrice;
    private InventoryIngredients inventoryIngredient;

    @Deprecated
    public StockInventoryUsageLink() {
        this.inventoryItemUnit = this.createReference(StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT);
        this.removable = false;
    }

    @Override
    protected Reference<StockItem> createStockReference() {
        return this.createReference(StockInventoryUsageLink.Properties.STOCK_ITEM);
    }

    public StockInventoryUsageLink(InventoryItemUnit anItemUnit, StockItem aStockItem, Quantity aQty) {
        this.inventoryItemUnit = this.createReference(StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT);
        this.removable = false;
        if (anItemUnit == null) {
            throw new NullPointerException("Cannot create a link from menu to stock with a null menu item unit");
        }
        if (aStockItem == null) {
            throw new NullPointerException("Cannot create a link from menu to stock with a null stock item");
        }
        if (aQty == null) {
            throw new NullPointerException("Cannot create a link from menu to stock with a null Quantity");
        }
        this.inventoryItemUnit.set(anItemUnit);
        this.setStockItem(aStockItem);
        this.setQuantity(aQty);
        this.removable = false;
    }

    public void setLiquorfileId(Integer id) {
        this.liquorfileId = id;
    }

    public Integer getLiquorfileId() {
        return this.liquorfileId;
    }

    public InventoryItemUnit getInventoryItemUnit() {
        return this.inventoryItemUnit.get();
    }

    @Override
    public String toString() {
        return this.getInventoryItemUnit() != null ? this.getInventoryItemUnit().getLabel() + " using " + this.toUsageString() : "No Stock Usage Link, ID:" + this.getID();
    }

    public String toUsageString() {
        return this.getStockItemName() + " - " + this.getQuantity();
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public String getLabel() {
        return this.toUsageString();
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void setRemovable(boolean isRemoveable) {
        this.removable = isRemoveable;
    }

    public void setForegroundColor(Color fg) {
        this.foregroundColor = fg;
    }

    public void setBackgroundColor(Color bg) {
        this.backgroundColor = bg;
    }

    public void setRemovePrice(Price removePrice) {
        this.removePrice = removePrice;
    }

    public Price getRemovePrice() {
        return this.removePrice;
    }

    @Override
    public SalesRemoveStocked createSalesRemove(SalesComponent component) {
        return new SalesRemoveStocked(component, this);
    }

    public InventoryIngredients getInventoryIngredient() {
        return this.inventoryIngredient;
    }

    public void setInventoryIngredient(InventoryIngredients inventoryIngredient) {
        this.inventoryIngredient = inventoryIngredient;
    }

    @Override
    public void saveChild() {
        if (!this.hasIngredientsSavedAlready() && this.getInventoryIngredient() == null) {
            this.inventoryIngredient = new InventoryIngredients();
            this.inventoryIngredient.setMeasureUnitContainer(null);
            this.inventoryIngredient.setStockInventoryUsageLink(this);
            StockItem item = this.getStockItem();
            if (item != null) {
                this.inventoryIngredient.setStockItem(item);
            }
            this.inventoryIngredient.setStockUsageModLink(null);
        }
        PersistenceManager.saveChild(this);
        if (this.getInventoryIngredient() != null) {
            this.getInventoryIngredient().saveChild();
        }
    }

    private boolean hasIngredientsSavedAlready() {
        return true;
    }

    public static class Props
    extends StockUsageLink.Props {
        public PropertiedObject.Property<InventoryItemUnit> INVENTORY_ITEM_UNIT;
        public PropertiedObject.Property LIQUORFILE_ID;
        public PersistentObject.DerivedProperty<StockInventoryUsageLink> STOCK_ITEM_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockInventoryUsageLink.class), "stockItemName");
        public PropertiedObject.Property REMOVE_PRICE;
        public PropertiedObject.Property BACKGROUND_COLOR;
        public PropertiedObject.Property FOREGROUND_COLOR;
        public PropertiedObject.Property REMOVABLE;
        public PropertiedObject.Property INVENTORY_INGREDIENT;
    }
}

