/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.usagelink;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockLink;
import stockmate.database.interfaces.stock.MeasureUnitI;

public abstract class StockUsageLink
extends PersistentObject
implements SaveableChild,
StockLink {
    public static final Props Properties = new Props();
    private Reference<StockItem> stockItem = this.createStockReference();
    private double quantity;
    private boolean fixedQuantity = false;

    protected abstract Reference<StockItem> createStockReference();

    @Override
    public void saveChild() {
        if (this.quantity == 0.0) {
            throw new IllegalStateException("Cannot save usage with zero quantity for " + this + " with ID: " + this.getID());
        }
        PersistenceManager.saveChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public Quantity getQuantity() {
        StockItem item = this.getStockItemNoCollapse();
        if (item == null) {
            return new Quantity((MeasureUnitI)MeasureUnitHelper.getMeasureUnit("each"), 1.0);
        }
        return new Quantity(item.getIngredientMeasureUnit(), this.quantity);
    }

    @Override
    public void setQuantity(Quantity newQuantity) {
        this.quantity = newQuantity.getRawValue();
    }

    protected void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    @Override
    public StockItem getStockItem() {
        if (this.stockItem.isPersistent()) {
            this.stockItem.collapse();
        }
        return this.getStockItemNoCollapse();
    }

    protected StockItem getStockItemNoCollapse() {
        return this.stockItem.get();
    }

    @Override
    public void setStockItem(StockItem item) {
        this.stockItem.set(item);
    }

    public boolean isLinkingStockItem(StockItem item) {
        return this.getStockItemNoCollapse().equals(item);
    }

    public Quantity getStockOnHand() {
        return this.getStockItemNoCollapse().getTotalStockOnHand();
    }

    @Override
    public double calculateStockItemLinkCost(StockArea area, boolean incTax, boolean useAvg) {
        StockItem theItem = this.getStockItem();
        Quantity ingredQty = this.getQuantity();
        double rawIngredQty = ingredQty.getRawValue();
        Price theCost = theItem.getStockItemCost(useAvg, area);
        if (theCost.isZero()) {
            theCost = theItem.getStockItemCost(!useAvg, area);
        }
        double stockItemCost = theCost.doubleValue();
        double stockItemQtyPerUnit = theItem.getPurchaseQty().getRawValue();
        if (!incTax && theItem.isTaxIncluded() || !incTax && theItem.isReplacementCostMatchPreProdCost()) {
            stockItemCost = FinanceUtils.removeTax(stockItemCost, SystemProperty.getInstance().getBaseTaxRate());
        }
        return rawIngredQty * stockItemCost / stockItemQtyPerUnit;
    }

    public String getStockItemName() {
        if (this.getStockItemNoCollapse() != null) {
            return this.getStockItemNoCollapse().getLabel();
        }
        return "No stock item";
    }

    public String getShortName() {
        if (this.getStockItemNoCollapse() != null) {
            String tempName = this.getStockItemNoCollapse().getShortName();
            if (tempName == null || "".equals(tempName)) {
                tempName = this.getStockItemNoCollapse().getName();
            }
            return tempName;
        }
        return "No stock item";
    }

    @Override
    public String toString() {
        if (this.getStockItemNoCollapse() != null) {
            return this.getStockItemName() + " (" + this.getQuantity() + ")";
        }
        return "Missing stock item for " + this.getID();
    }

    @Override
    public boolean isFixedQuantity() {
        return this.fixedQuantity;
    }

    @Override
    public void setFixedQuantity(boolean fixedQuantity) {
        this.fixedQuantity = fixedQuantity;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<StockItem> STOCK_ITEM;
        public PropertiedObject.Property QUANTITY;
        public PropertiedObject.Property FIXED_QUANTITY;
    }
}

