/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock.usagelink;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import ordermate.database.config.Quantity;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockUsageModLink;

public class StockUsageOptionLink
extends StockUsageModLink {
    public static final Props Properties = new Props();
    private Reference<InventoryOption> inventoryOption;

    public StockUsageOptionLink() {
        this.inventoryOption = this.createReference(StockUsageOptionLink.Properties.INVENTORY_OPTION);
    }

    public StockUsageOptionLink(StockItem aStockItem, InventoryOption anInventoryOption, Quantity aQuantity) {
        this.inventoryOption = this.createReference(StockUsageOptionLink.Properties.INVENTORY_OPTION);
        if (aStockItem == null) {
            throw new NullPointerException("Try to create a StockUsageOption link with a null StockItem");
        }
        if (anInventoryOption == null) {
            throw new NullPointerException("Try to create a StockUsageOption link with a null InventoryOption");
        }
        if (aQuantity == null) {
            throw new NullPointerException("Try to create a StockUsageOption link with a null Quantity");
        }
        this.setQuantity(aQuantity);
        this.setStockItem(aStockItem);
        this.setInventoryOption(anInventoryOption);
    }

    protected void setInventoryOption(InventoryOption option) {
        this.inventoryOption.set(option);
    }

    public InventoryOption getInventoryOption() {
        return this.inventoryOption.get();
    }

    @Override
    public String toString() {
        return this.getStockItem() != null ? this.getQuantity() + " of " + this.getStockItem().getName() : "No stock item for usage option, ID:" + this.getID();
    }

    public static class Props
    extends StockUsageModLink.Props {
        public PropertiedObject.Property<InventoryOption> INVENTORY_OPTION;
    }
}

