/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.tables;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.colour.ConfigColor;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTableState;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.database.users.User;
import ordermate.integration.PropertyIntegrationUtils;
import ordermate.integration.ReservationIntegrationUtils;
import org.apache.logging.log4j.Level;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Where;

@Entity
@Table(name="config_table")
@AccessType(value="property")
public class LogicalTable
extends PersistentObject
implements SaveableChild,
Lockable,
Displayable {
    private static final long HALF_MINUTE = 30000L;
    private static final long serialVersionUID = 1L;
    public static final Props Properties = new Props();
    private static Reference TABLE_LOCKED = ConfigColor.createLocalCachedReference("Table Locked");
    private static Reference TABLE_OPEN = ConfigColor.createLocalCachedReference("Table Open");
    private PersistentWriteableList<PhysicalTable> physicalTables;
    private Reference<TableGroup> tableGroup;
    private Reference<User> user;
    private Reference<PhysicalTable> primaryPhysicalTable;
    private Reference<TableAccount> account;
    private PersistentWriteableList<BarTabAccount> barTabs;
    private String systemState;
    private Long stateTime;
    private Reference<LogicalTableState> tableState;
    private Rectangle boundingBox;
    private boolean backgroundIsCached;
    private Color backgroundCachedColor;
    private transient String timeString;
    private transient long lastUpdate;
    private static boolean boundingBoxIncludesAllTables;

    public static void setBoundingBoxIncludesAllTables(boolean value) {
        boundingBoxIncludesAllTables = value;
    }

    public static boolean isBoundingBoxIncludesAllTables() {
        return boundingBoxIncludesAllTables;
    }

    public LogicalTable() {
        this.physicalTables = (PersistentWriteableList)this.createList(LogicalTable.Properties.PHYSICAL_TABLES);
        this.tableGroup = this.createReference(LogicalTable.Properties.TABLE_GROUP);
        this.user = this.createReference(LogicalTable.Properties.USER);
        this.primaryPhysicalTable = this.createReference(LogicalTable.Properties.PRIMARY_PHYSICAL_TABLE);
        this.account = this.createReference(LogicalTable.Properties.ACCOUNT);
        this.barTabs = (PersistentWriteableList)this.createList(LogicalTable.Properties.BAR_TABS);
        this.systemState = "ACTIVE";
        this.tableState = this.createReference(LogicalTable.Properties.TABLE_STATE);
        this.boundingBox = null;
        this.backgroundIsCached = false;
        this.backgroundCachedColor = null;
        this.lastUpdate = 0L;
    }

    @Override
    public void init() {
        super.init();
        this.getPhysicalTables();
    }

    @Override
    public void deleteChild() {
        this.systemState = "DELETED";
        for (PhysicalTable pt : this.physicalTables) {
            pt.deleteChild();
        }
        PersistenceManager.saveChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        if (this.tableGroup.get() == null && TableGroup.getTableGroups().size() > 0) {
            this.setTableGroup(TableGroup.getTableGroups().get(0));
        }
        boolean isPrimaryTablePersistent = this.primaryPhysicalTable.isExpanded() && !this.primaryPhysicalTable.isNull() && this.primaryPhysicalTable.get().isPersistent();
        PersistenceManager.saveChild(this);
        this.primaryPhysicalTable.saveChild();
        this.physicalTables.saveChild();
        if (!isPrimaryTablePersistent) {
            PersistenceManager.updateChild(this, new PropertiedObject.Property[]{LogicalTable.Properties.PRIMARY_PHYSICAL_TABLE});
        }
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    private void clearBackgroundCache() {
        this.backgroundCachedColor = null;
        this.backgroundIsCached = false;
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        if (this.backgroundIsCached) {
            return this.backgroundCachedColor;
        }
        Color retval = null;
        if (this.isLocked()) {
            retval = ((ConfigColor)TABLE_LOCKED.get()).getColor();
        } else if (this.isLockedByBarTab()) {
            retval = ((ConfigColor)TABLE_LOCKED.get()).getColor();
        } else if (this.hasAccount()) {
            TableAccount currentAccount = this.getAccount();
            if (currentAccount != null) {
                retval = currentAccount.getBackgroundColor();
            }
            if (retval == null) {
                retval = ((ConfigColor)TABLE_OPEN.get()).getColor();
            }
        } else {
            retval = null;
        }
        this.backgroundCachedColor = retval;
        this.backgroundIsCached = true;
        return retval;
    }

    @Transient
    public PhysicalTable getPrimaryPhysicalTable() {
        if (!this.primaryPhysicalTable.isExpanded()) {
            this.matchPrimaryTableReference();
        }
        return this.primaryPhysicalTable.get();
    }

    private void matchPrimaryTableReference() {
        PhysicalTable primary = this.primaryPhysicalTable.get();
        int index = this.physicalTables.indexOf(primary);
        if (index != -1) {
            this.primaryPhysicalTable.set((PhysicalTable)((PersistentObjectI)this.physicalTables.get(index)));
        } else if (this.physicalTables.size() != 0 || !this.getSystemState().equals("DELETED")) {
            OrderMate.LOG.warn("LogicalTable@" + System.identityHashCode(this) + " with ID: " + this.getID() + " :  Couldn't find primary physical table \"" + primary + "\" in table list " + this.physicalTables);
        }
    }

    void setPrimaryPhysicalTable(PhysicalTable pt) {
        this.primaryPhysicalTable.set(pt);
        if (pt != null && !this.physicalTables.contains(pt)) {
            this.physicalTables.add(pt);
        }
        this.boundingBox = null;
    }

    public boolean isPrimaryPhysicalTable(PhysicalTable table) {
        return this.getPrimaryPhysicalTable().equals(table);
    }

    @OneToMany(mappedBy="logicalTable", targetEntity=PhysicalTable.class, fetch=FetchType.LAZY)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Where(clause="system_state = 'ACTIVE'")
    public List<PhysicalTable> getPhysicalTables() {
        if (!PersistenceManager.getPersistenceDelegate().isHeadOffice() && !this.physicalTables.isExpanded()) {
            this.matchPrimaryTableReference();
        }
        return this.physicalTables.getUnmodifiable();
    }

    public synchronized boolean hasAccount() {
        return this.getAccount() != null || !this.getBarTabs().isEmpty();
    }

    boolean addLogicalTable(LogicalTable toAdd, boolean rearrange) {
        if (rearrange) {
            Rectangle bounding = toAdd.getBoundingRect();
            Rectangle nearestPt = this.getNearestAdjacentCell(bounding);
            if (nearestPt != null) {
                int xOffset = nearestPt.x - bounding.x;
                int yOffset = nearestPt.y - bounding.y;
                List<PhysicalTable> extraPhysicalTables = toAdd.removeAllTables();
                for (PhysicalTable nextTable : extraPhysicalTables) {
                    nextTable.setPosition(nextTable.getX() + xOffset, nextTable.getY() + yOffset);
                    this.physicalTables.add(nextTable);
                }
                this.boundingBox = null;
                return true;
            }
            OrderMate.LOG.log(Level.WARN, "Cannot add table, no point available");
            return false;
        }
        this.physicalTables.addAll(toAdd.removeAllTables());
        return true;
    }

    void addPhysicalTables(List physTables) {
        if (this.physicalTables.isEmpty()) {
            throw new IllegalStateException("Cannot call LogicalTable.addPhysicalTables() before primary table has been added.");
        }
        for (PhysicalTable physTable : physTables) {
            this.addPhysicalTable(physTable);
        }
    }

    void addPhysicalTable(PhysicalTable physTable) {
        Rectangle nearestPt;
        if (this.physicalTables.isEmpty()) {
            throw new IllegalStateException("Cannot call LogicalTable.addPhysicalTable() before primary table has been added.");
        }
        if (this.physicalTables.contains(physTable)) {
            return;
        }
        if (!this.physicalTables.isEmpty() && (nearestPt = this.getNearestAdjacentCell(new Rectangle(physTable.getX(), physTable.getY(), physTable.getTableImageWidth(), physTable.getTableImageHeight()))) != null) {
            physTable.setPosition(nearestPt.x, nearestPt.y);
            physTable.setLogicalTable(this);
            this.physicalTables.add(physTable);
            this.boundingBox = null;
        }
    }

    public void setPosition(int x, int y) {
        Rectangle boundingRect = this.getBoundingRect();
        int offsetX = x - boundingRect.x;
        int offsetY = y - boundingRect.y;
        for (PhysicalTable table : this.getPhysicalTables()) {
            table.setX(table.getX() + offsetX);
            table.setY(table.getY() + offsetY);
        }
        boundingRect = null;
    }

    void removeTable(PhysicalTable table) {
        this.physicalTables.remove(table);
        this.boundingBox = null;
    }

    void removeTables(List tables) {
        this.physicalTables.removeAll(tables);
        this.boundingBox = null;
    }

    List<PhysicalTable> removeAllTables() {
        ArrayList<PhysicalTable> tables = new ArrayList<PhysicalTable>(this.physicalTables);
        this.physicalTables.clear();
        this.boundingBox = null;
        return tables;
    }

    @Override
    @Transient
    public synchronized boolean isLocked() {
        return !this.user.isNull();
    }

    @Transient
    public synchronized boolean isLockedByBarTab() {
        if (this.barTabs.size() == 0) {
            return false;
        }
        for (BarTabAccount bTab : this.barTabs) {
            if (bTab.isLocked()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean isLocked(User byUser) {
        return !this.user.isNull() && this.user.getObjectID().equals(PersistenceManager.getID(byUser));
    }

    @Override
    public synchronized boolean lock(User lockUser) {
        boolean lockSucceeded;
        User resultingUser;
        if (this.isPersistent()) {
            resultingUser = PersistenceManager.getServerConnection().runSync(new LogicalTableLocker(lockUser));
            if (resultingUser == null) {
                lockSucceeded = true;
                resultingUser = lockUser;
            } else {
                lockSucceeded = false;
            }
        } else {
            resultingUser = lockUser;
            lockSucceeded = true;
        }
        if (this.needToIncrement(resultingUser)) {
            this.getTableGroup().incrementReloadNum();
        }
        this.setUser(resultingUser);
        if (lockSucceeded) {
            TerminalEventLog.logLockTable(this, resultingUser, Terminal.getLocalHost());
        }
        this.clearBackgroundCache();
        return lockSucceeded;
    }

    private boolean needToIncrement(User aUser) {
        boolean needToIncrement = aUser == null && this.user.isNull() ? false : (aUser == null || this.user.isNull() ? true : aUser != this.user.get());
        return needToIncrement;
    }

    @Override
    public synchronized boolean relock(User lockUser) {
        this.unlock();
        return this.lock(lockUser);
    }

    @Override
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_user")
    public synchronized User getUser() {
        return this.user.get();
    }

    protected void setUser(User aUser) {
        this.user.set(aUser);
    }

    @Override
    public synchronized void unlock() {
        if (this.needToIncrement(null)) {
            this.getTableGroup().incrementReloadNum();
        }
        this.setUser(null);
        if (this.isPersistent()) {
            PersistenceManager.updateChild(this, new PropertiedObject.Property[]{LogicalTable.Properties.USER});
        }
        this.clearBackgroundCache();
    }

    @Transient
    public TableAccount getAccount() {
        return this.account.get();
    }

    public void setAccount(TableAccount acct) {
        if (acct == null != this.hasAccount()) {
            this.getTableGroup().incrementReloadNum();
        }
        this.account.set(acct);
        this.clearBackgroundCache();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_table_group")
    public TableGroup getTableGroup() {
        return this.tableGroup.get();
    }

    public void setTableGroup(TableGroup group) {
        this.tableGroup.set(group);
        this.boundingBox = null;
    }

    @Transient
    public List<BarTabAccount> getBarTabs() {
        return this.barTabs;
    }

    @Transient
    protected void setBarTabs(List<BarTabAccount> values) {
        this.barTabs = this.barTabs.clone();
        this.barTabs.set(values);
        this.clearBackgroundCache();
    }

    public void linkBarTab(BarTabAccount toLink) {
        if (!this.barTabs.contains(toLink)) {
            this.getTableGroup().incrementReloadNum();
            this.barTabs.add(toLink);
            this.clearBackgroundCache();
        }
    }

    public void delinkBarTab(BarTabAccount toLink) {
        this.barTabs.remove(toLink);
        this.getTableGroup().incrementReloadNum();
        this.clearBackgroundCache();
    }

    @Override
    @Transient
    public String getLabel() {
        if (this.getPrimaryPhysicalTable() != null) {
            return this.getPrimaryPhysicalTable().getName();
        }
        return "";
    }

    @Transient
    public int getNumberOfSeats() {
        int seats = 0;
        for (PhysicalTable pt : this.getPhysicalTables()) {
            seats += pt.getSeats();
        }
        return seats;
    }

    @Transient
    public int getNumberOfTables() {
        return this.physicalTables.size();
    }

    private Set<Point> getEmptyAdjacentPoints(Rectangle cellSize) {
        int newTableWidth = cellSize.width;
        int newTableHeight = cellSize.height;
        ArrayList<Point> tablePositions = new ArrayList<Point>(this.physicalTables.size());
        for (PhysicalTable pt : this.physicalTables) {
            tablePositions.add(pt.getPosition());
        }
        HashSet<Point> emptyAdjacentPoints = new HashSet<Point>();
        for (PhysicalTable pt : this.physicalTables) {
            emptyAdjacentPoints.add(new Point(pt.getX() + pt.getTableImageWidth(), pt.getY()));
            emptyAdjacentPoints.add(new Point(pt.getX() - newTableWidth, pt.getY()));
            emptyAdjacentPoints.add(new Point(pt.getX(), pt.getY() + pt.getTableImageHeight()));
            emptyAdjacentPoints.add(new Point(pt.getX(), pt.getY() - newTableHeight));
            emptyAdjacentPoints.add(new Point(pt.getX() + pt.getTableImageWidth() - newTableWidth, pt.getY() - newTableHeight));
            emptyAdjacentPoints.add(new Point(pt.getX() + pt.getTableImageWidth() - newTableWidth, pt.getY() + pt.getTableImageHeight()));
            emptyAdjacentPoints.add(new Point(pt.getX() + pt.getTableImageWidth(), pt.getY() + pt.getTableImageHeight() - newTableHeight));
            emptyAdjacentPoints.add(new Point(pt.getX() - newTableWidth, pt.getY() + pt.getTableImageHeight() - newTableHeight));
            if (pt.getTableImageWidth() != newTableWidth) {
                emptyAdjacentPoints.add(new Point(pt.getX() + (pt.getTableImageWidth() - newTableWidth) / 2, pt.getY() - newTableHeight));
                emptyAdjacentPoints.add(new Point(pt.getX() + (pt.getTableImageWidth() - newTableWidth) / 2, pt.getY() + pt.getTableImageHeight()));
            }
            if (pt.getTableImageHeight() == newTableHeight) continue;
            emptyAdjacentPoints.add(new Point(pt.getX() - newTableWidth, pt.getY() + (pt.getTableImageHeight() - newTableHeight) / 2));
            emptyAdjacentPoints.add(new Point(pt.getX() + pt.getTableImageWidth(), pt.getY() + (pt.getTableImageHeight() - newTableHeight) / 2));
        }
        emptyAdjacentPoints.removeAll(tablePositions);
        this.cullCollidingPoints(emptyAdjacentPoints, cellSize);
        return emptyAdjacentPoints;
    }

    private void cullCollidingPoints(Set pointSet, Rectangle newTableBounds) {
        if (this.physicalTables.size() > 1) {
            Iterator points = pointSet.iterator();
            Rectangle toPlace = new Rectangle(0, 0, newTableBounds.width, newTableBounds.height);
            Rectangle testTable = new Rectangle();
            block0: while (points.hasNext()) {
                Point nextPoint = (Point)points.next();
                toPlace.setLocation(nextPoint.x, nextPoint.y);
                for (PhysicalTable nextTable : this.physicalTables) {
                    testTable.setLocation(nextTable.getPosition());
                    testTable.setSize(nextTable.getTableSize());
                    if (!testTable.intersects(toPlace)) continue;
                    points.remove();
                    continue block0;
                }
            }
        }
    }

    public Rectangle getNearestAdjacentCell(Rectangle newTableSize) {
        ArrayList<Point> emptyAdjacentPoints = new ArrayList<Point>(this.getEmptyAdjacentPoints(newTableSize));
        if (emptyAdjacentPoints.isEmpty()) {
            return null;
        }
        int x = newTableSize.x;
        int y = newTableSize.y;
        int tableWidth = newTableSize.width;
        int tableHeight = newTableSize.height;
        Rectangle sectionSize = new Rectangle(0, 0, this.getTableGroup().getBackgroundImageWidth(), this.getTableGroup().getBackgroundImageHeight());
        Rectangle closestEmptyCell = null;
        boolean foundValue = false;
        int minDistance = 0;
        for (Point pt : emptyAdjacentPoints) {
            int dx = pt.x - x;
            int dy = pt.y - y;
            int distSq = dx * dx + dy * dy;
            Rectangle currentCell = new Rectangle(pt.x, pt.y, tableWidth, tableHeight);
            if (foundValue && distSq >= minDistance || !sectionSize.contains(currentCell)) continue;
            foundValue = true;
            minDistance = distSq;
            closestEmptyCell = currentCell;
        }
        return closestEmptyCell;
    }

    @Transient
    List<PhysicalTable> getLonelyPhysicalTables() {
        ArrayList<PhysicalTable> lonelyList = new ArrayList<PhysicalTable>(this.getPhysicalTables());
        HashSet<PhysicalTable> connectedTables = new HashSet<PhysicalTable>();
        this.addConnectedTables(this.getPrimaryPhysicalTable(), connectedTables);
        lonelyList.removeAll(connectedTables);
        return lonelyList;
    }

    private void addConnectedTables(PhysicalTable toExamine, Set<PhysicalTable> connectedTables) {
        if (!connectedTables.contains(toExamine)) {
            connectedTables.add(toExamine);
            Rectangle vTouch = new Rectangle(toExamine.getPosition().x, toExamine.getPosition().y - 1, toExamine.getTableImageWidth(), toExamine.getTableImageHeight() + 2);
            Rectangle hTouch = new Rectangle(toExamine.getPosition().x - 1, toExamine.getPosition().y, toExamine.getTableImageWidth() + 2, toExamine.getTableImageHeight());
            for (PhysicalTable nextTable : this.physicalTables) {
                if (connectedTables.contains(nextTable)) continue;
                if (vTouch.intersects(nextTable.getX(), nextTable.getY(), nextTable.getTableImageWidth(), nextTable.getTableImageHeight())) {
                    this.addConnectedTables(nextTable, connectedTables);
                    continue;
                }
                if (!hTouch.intersects(nextTable.getX(), nextTable.getY(), nextTable.getTableImageWidth(), nextTable.getTableImageHeight())) continue;
                this.addConnectedTables(nextTable, connectedTables);
            }
        }
    }

    @Transient
    public int getX() {
        return this.getBoundingRect().x;
    }

    @Transient
    public int getY() {
        return this.getBoundingRect().y;
    }

    @Transient
    public Rectangle getBoundingRect() {
        this.boundingBox = this.calculateBoundingBox();
        return this.boundingBox;
    }

    private Rectangle calculateBoundingBox() {
        if (boundingBoxIncludesAllTables) {
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (PhysicalTable table : this.physicalTables) {
                int tx = table.getX();
                int ty = table.getY();
                if (tx < minX) {
                    minX = tx;
                }
                if (tx + table.getTableImageWidth() > maxX) {
                    maxX = tx + table.getTableImageWidth();
                }
                if (ty < minY) {
                    minY = ty;
                }
                if (ty + table.getTableImageHeight() <= maxY) continue;
                maxY = ty + table.getTableImageHeight();
            }
            return new Rectangle(minX, minY, maxX - minX, maxY - minY);
        }
        return this.getPrimaryPhysicalTable().getRect();
    }

    protected void setPhysicalTables(List<PhysicalTable> tables) {
        this.physicalTables = this.physicalTables.clone();
        this.physicalTables.set(tables);
    }

    protected void setSystemState(String value) {
        this.systemState = value;
    }

    @Transient
    public LogicalTableState getTableState() {
        return this.tableState.get();
    }

    protected void setTableState(LogicalTableState value) {
        this.tableState.set(value);
    }

    @Column(name="state_time", nullable=true)
    public Long getStateTime() {
        return this.stateTime;
    }

    public void setStateTime(Long value) {
        this.stateTime = value;
        this.timeString = null;
        if (!PersistenceManager.getPersistenceDelegate().isHeadOffice() && this.getTableGroup() != null) {
            this.getTableGroup().incrementReloadNum();
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    @Transient
    public String getStateTimeAsString() {
        if (this.timeString == null || System.currentTimeMillis() - this.lastUpdate > 30000L) {
            this.updateTimeString();
        }
        return this.timeString;
    }

    private void updateTimeString() {
        this.lastUpdate = System.currentTimeMillis();
        if (this.getTableState() != null) {
            StringBuilder SB = new StringBuilder(this.tableState.get().getShortLabel());
            if (this.stateTime != null && this.stateTime > 0L) {
                SB.append(" ");
                SB.append(DateTimeUtils.toHoursMinutes(this.lastUpdate - this.stateTime));
            }
            this.timeString = SB.toString();
        } else {
            this.timeString = "";
        }
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return null;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public boolean canOrderTo() {
        boolean canOrder = false;
        for (PhysicalTable physTable : this.physicalTables) {
            canOrder = canOrder || physTable.isCanOrderTo();
        }
        return canOrder;
    }

    public void updateTableState(LogicalTableState state, EventContext context) {
        if (state != this.getTableState()) {
            TerminalEventLog.logTableStateChanged(this, this.getTableState(), state, context, this.getAccount());
            this.setTableState(state);
            PropertyIntegrationUtils.tableStateUpdated(this.getAccount(), state);
            ReservationIntegrationUtils.tableStateUpdated(this.getAccount(), state);
            this.setStateTime(state != null ? Long.valueOf(System.currentTimeMillis()) : null);
        }
    }

    @Transient
    public String getGroupAndLabel() {
        TableGroup parent = this.getTableGroup();
        if (parent != null && SystemProperty.getInstance().isShowSectionOnDockets()) {
            StringBuilder SB = new StringBuilder(parent.getLabel());
            SB.append(" ").append(this.getLabel());
            return SB.toString();
        }
        return this.getLabel();
    }

    private final class LogicalTableLocker
    extends Executable<User> {
        private final User lockUser;

        private LogicalTableLocker(User newLockUser) {
            this.lockUser = newLockUser;
        }

        @Override
        public User execute() {
            LogicalTable fresh = (LogicalTable)PersistenceManager.reacquire(LogicalTable.this);
            if (!fresh.isLocked()) {
                fresh.user.set(this.lockUser);
                PersistenceManager.updateChild(fresh, new PropertiedObject.Property[]{LogicalTable.Properties.USER});
                return null;
            }
            return fresh.getUser();
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<PhysicalTable> PHYSICAL_TABLES;
        public PropertiedObject.Property<TableGroup> TABLE_GROUP;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<PhysicalTable> PRIMARY_PHYSICAL_TABLE;
        public PropertiedObject.Property<TableAccount> ACCOUNT;
        public PropertiedObject.Property<BarTabAccount> BAR_TABS;
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<LogicalTableState> TABLE_STATE;
        public PropertiedObject.Property<Long> STATE_TIME;
        public PersistentObject.DerivedProperty<String> LABEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)LogicalTable.class), "label");
    }
}

