/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.tables;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Color;
import java.awt.Image;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.swing.ImageIcon;
import ordermate.database.Sequenced;
import ordermate.database.misc.Course;
import ordermate.database.sales.AccountState;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_table_state")
public class LogicalTableState
extends PersistentObject
implements Saveable,
Sequenced {
    public static final Props Properties = new Props();
    private String label = "Unknown State";
    private String shortLabel = "Unk";
    private String icon;
    private int sequence;
    private Reference<Course> course;
    private AccountState accountState;
    private String externalLabel;
    private Color colour;
    private transient boolean resolved;
    private transient Image image;

    public LogicalTableState() {
        this.course = this.createReference(LogicalTableState.Properties.COURSE);
        this.accountState = null;
        this.resolved = false;
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Column(name="icon")
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String value) {
        this.icon = value;
        this.image = null;
        this.resolved = false;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="fk_config_course", referencedColumnName="ID")
    public Course getCourse() {
        return this.course.get();
    }

    public void setCourse(Course value) {
        this.course.set(value);
    }

    @Column(name="colour")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color value) {
        this.colour = value;
    }

    @Column(name="account_state")
    @Enumerated(value=EnumType.STRING)
    public AccountState getAccountState() {
        return this.accountState;
    }

    public void setAccountState(AccountState value) {
        this.accountState = value;
    }

    @Column(name="short_label")
    @Basic(optional=false)
    public String getShortLabel() {
        return this.shortLabel;
    }

    public void setShortLabel(String value) {
        this.shortLabel = value;
    }

    @Column(name="external_label")
    public String getExternalLabel() {
        return this.externalLabel;
    }

    public void setExternalLabel(String externalLabel) {
        this.externalLabel = externalLabel;
    }

    @Transient
    public Image getImage() {
        if (!this.resolved) {
            ImageIcon theIcon;
            if (this.icon != null && (theIcon = IconLoader.get(this.icon)) != null) {
                this.image = theIcon.getImage();
                this.image = new ImageHelper().fitImageTo(this.image, 28, 28);
            }
            this.resolved = true;
        }
        return this.image;
    }

    @Override
    public String toString() {
        if (this.label != null) {
            return this.label;
        }
        return super.toString();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public int compareTo(Object o) {
        if (o instanceof Sequenced) {
            return this.sequence - ((Sequenced)o).getSequence();
        }
        return 0;
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    public static LogicalTableState getStateFor(AccountState tableState) {
        return PersistenceManager.getObject(LogicalTableState.class, Query.select(LogicalTableState.class).equals(LogicalTableState.Properties.ACCOUNT_STATE, (Object)tableState).toString(), null);
    }

    public static LogicalTableState getStateForCourse(Course course) {
        return PersistenceManager.getObject(LogicalTableState.class, Query.select(LogicalTableState.class).equals(LogicalTableState.Properties.COURSE, course).toString(), null);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> SHORT_LABEL;
        public PropertiedObject.Property<String> ICON;
        public PropertiedObject.Property<Course> COURSE;
        public PropertiedObject.Property<Color> COLOUR;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<String> EXTERNAL_LABEL;
        public PropertiedObject.Property<AccountState> ACCOUNT_STATE;
    }
}

