/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.tables;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.swing.ImageIcon;
import ordermate.OrderMate;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.TableGroup;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="config_table_physical")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class PhysicalTable
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private String systemState = "ACTIVE";
    private int x;
    private int y;
    private String name;
    private Reference<LogicalTable> logicalTable;
    private int seats;
    private int permanentX;
    private int permanentY;
    private Reference<PhysicalTable> permanentPrimaryPhysicalTable;
    private boolean canOrderTo;
    private String tableImagePath;
    private Dimension tableSize;

    public PhysicalTable() {
        this.logicalTable = this.createReference(PhysicalTable.Properties.LOGICAL_TABLE);
        this.seats = 10;
        this.permanentPrimaryPhysicalTable = this.createReference(PhysicalTable.Properties.PERMANENT_PRIMARY_PHYSICAL_TABLE);
        this.canOrderTo = true;
    }

    public PhysicalTable(String newName, int xCoord, int yCoord) {
        this();
        this.setLogicalTable(new LogicalTable());
        this.setName(newName);
        this.setX(xCoord);
        this.setY(yCoord);
    }

    protected PhysicalTable(PhysicalTable toCopy) {
        this();
        this.systemState = toCopy.systemState;
        this.x = toCopy.x;
        this.y = toCopy.y;
        this.name = toCopy.name;
        this.seats = toCopy.seats;
        this.permanentX = toCopy.permanentX;
        this.permanentY = toCopy.permanentY;
        this.canOrderTo = toCopy.canOrderTo;
        this.tableImagePath = toCopy.tableImagePath;
        this.setLogicalTable(new LogicalTable());
        this.setPermanentPrimaryPhysicalTable(this);
    }

    @Override
    public void saveChild() {
        if (this.logicalTable == null) {
            this.setLogicalTable(new LogicalTable());
        }
        if (!this.isPersistent() && this.permanentPrimaryPhysicalTable.isNull()) {
            this.permanentX = this.x;
            this.permanentY = this.y;
            this.permanentPrimaryPhysicalTable.set(this.getLogicalTable().getPrimaryPhysicalTable());
        }
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        this.systemState = "DELETED";
        PersistenceManager.saveChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Transient
    public Rectangle getRect() {
        return new Rectangle(this.getX(), this.getY(), this.getTableImageWidth(), this.getTableImageHeight());
    }

    @Column(name="X")
    public int getX() {
        return this.x;
    }

    @Column(name="Y")
    public int getY() {
        return this.y;
    }

    public void setX(int xCoord) {
        this.x = xCoord;
        if (this.x < 0) {
            this.x = 0;
        }
        if (!this.isPersistent()) {
            this.permanentX = this.x;
        }
    }

    public void setY(int yCoord) {
        this.y = yCoord;
        if (this.y < 0) {
            this.y = 0;
        }
        if (!this.isPersistent()) {
            this.permanentY = this.y;
        }
    }

    @Column(name="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String tableName) {
        this.name = tableName;
    }

    @Override
    public String toString() {
        return this.getName() != null ? this.getName() : "Physical Table : no name, ID:" + this.getID();
    }

    @Transient
    public Point getPosition() {
        return new Point(this.x, this.y);
    }

    public void setPosition(int xCoord, int yCoord) {
        this.setX(xCoord);
        this.setY(yCoord);
    }

    @Column(name="PermanentX")
    public int getPermanentX() {
        return this.permanentX;
    }

    @Column(name="PermanentY")
    public int getPermanentY() {
        return this.permanentY;
    }

    @Transient
    public Point getPermanentPosition() {
        return new Point(this.permanentX, this.permanentY);
    }

    public void setPermanentPosition(int xCoord, int yCoord) {
        this.permanentX = xCoord;
        this.permanentY = yCoord;
        if (this.permanentX < 0) {
            this.permanentX = 0;
        }
        if (this.permanentY < 0) {
            this.permanentY = 0;
        }
    }

    void restorePermanentPositions() {
        LogicalTable permanentLogical;
        if (!this.isPersistent() || this.getPermanentPrimaryPhysicalTable() == null) {
            return;
        }
        PhysicalTable permanentPrimary = this.getPermanentPrimaryPhysicalTable();
        TableGroup tableGroup = this.getLogicalTable().getTableGroup();
        if (!permanentPrimary.equals(this) && (permanentLogical = tableGroup.getTableInstance(permanentPrimary.getLogicalTable())) != null && !permanentLogical.equals(this.getLogicalTable())) {
            tableGroup.getHelper().joinTables(permanentLogical, this.getLogicalTable(), true);
        }
        this.x = this.getPermanentX();
        this.y = this.getPermanentY();
    }

    void savePermanentPositions() {
        this.setPermanentPosition(this.x, this.y);
        this.setPermanentPrimaryPhysicalTable(this.getLogicalTable().getPrimaryPhysicalTable());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_table_physical_permanent")
    public PhysicalTable getPermanentPrimaryPhysicalTable() {
        return this.permanentPrimaryPhysicalTable.get();
    }

    public void setPermanentPrimaryPhysicalTable(PhysicalTable table) {
        this.permanentPrimaryPhysicalTable.set(table);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_table")
    public LogicalTable getLogicalTable() {
        if (this.logicalTable.get() == null && !PersistenceManager.getPersistenceDelegate().isHeadOffice()) {
            this.setLogicalTable(new LogicalTable());
        }
        return this.logicalTable.get();
    }

    public void setLogicalTable(LogicalTable newTable) {
        this.logicalTable.set(newTable);
    }

    @Column(name="seats")
    public int getSeats() {
        return this.seats;
    }

    public void setSeats(int numSeats) {
        this.seats = numSeats;
    }

    public void setCanOrderTo(boolean canOrder) {
        this.canOrderTo = canOrder;
    }

    @Column(name="can_order_to")
    public boolean isCanOrderTo() {
        return this.canOrderTo;
    }

    public void setTableImagePath(String path) {
        this.tableImagePath = path;
        this.tableSize = null;
    }

    @Column(name="table_image")
    public String getTableImagePath() {
        return this.tableImagePath;
    }

    @Transient
    public ImageIcon getTableImage() {
        TableGroup group;
        if (this.tableImagePath != null && !this.tableImagePath.isEmpty()) {
            ImageIcon image;
            block4: {
                image = null;
                try {
                    image = IconLoader.get(this.tableImagePath);
                }
                catch (IconLoader.IconNotFoundException ex) {
                    if (image != null) break block4;
                    image = IconLoader.getBrokenIcon();
                    IconLoader.put(this.tableImagePath, image);
                    OrderMate.LOG.warn("Could not resolve image path for table : " + this + "  path:" + this.tableImagePath);
                }
            }
            return image;
        }
        LogicalTable logicTable = this.getLogicalTable();
        if (logicTable != null && (group = logicTable.getTableGroup()) != null) {
            return group.getDefaultTableImage();
        }
        return IconLoader.get("/waitermate/images/icon_edittable16.png");
    }

    @Transient
    public int getTableImageWidth() {
        return this.getTableImage().getIconWidth();
    }

    @Transient
    public int getTableImageHeight() {
        return this.getTableImage().getIconHeight();
    }

    public PhysicalTable copy() {
        return new PhysicalTable(this);
    }

    @Transient
    public Dimension getTableSize() {
        if (this.tableSize == null) {
            this.tableSize = this.calcTableSize();
        }
        return this.tableSize;
    }

    private Dimension calcTableSize() {
        Dimension retval = new Dimension(0, 0);
        String tableImName = this.getTableImagePath();
        try {
            ImageIcon imageIcon = IconLoader.get(tableImName);
            retval.width = imageIcon.getIconWidth();
            retval.height = imageIcon.getIconHeight();
        }
        catch (NullPointerException e) {
            OrderMate.LOG.warn("Couldn't obtain size of table : " + this.getID() + " with table image \"" + tableImName + "\"", (Throwable)e);
        }
        return retval;
    }

    protected void setSystemState(String newSystemState) {
        this.systemState = newSystemState;
    }

    protected void setPermanentY(int newPermanentY) {
        this.permanentY = newPermanentY;
    }

    protected void setPermanentX(int newPermanentX) {
        this.permanentX = newPermanentX;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property X;
        public PropertiedObject.Property Y;
        public PropertiedObject.Property NAME;
        public PropertiedObject.Property<LogicalTable> LOGICAL_TABLE;
        public PropertiedObject.Property SEATS;
        public PropertiedObject.Property PERMANENT_X;
        public PropertiedObject.Property PERMANENT_Y;
        public PropertiedObject.Property<PhysicalTable> PERMANENT_PRIMARY_PHYSICAL_TABLE;
        public PropertiedObject.Property TABLE_IMAGE_PATH;
        public PropertiedObject.Property CAN_ORDER_TO;
    }
}

